/*
 * Decompiled with CFR 0.152.
 */
package sandro.Core.Patch.MC1_12;

import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import sandro.Core.Main;

public class RegistryLibrary {
    private static ArrayList<Block> blockList = new ArrayList();
    private static ArrayList<Item> itemList = new ArrayList();
    private static ArrayList<Item> itemListRenderers = new ArrayList();
    private static ArrayList<IGuiHandler> guiHandlers = new ArrayList();
    private static ArrayList<Class<? extends Entity>> entityList = new ArrayList();
    private static ArrayList<Integer> entityTrackingRange = new ArrayList();
    private static ArrayList<Integer> entityUpdateFrequency = new ArrayList();
    private static ArrayList<Boolean> sendsVelocityUpdates = new ArrayList();
    private static ArrayList<String> entityNames = new ArrayList();
    private static ArrayList<String> entityModIds = new ArrayList();
    public static HashMap<Class<? extends Entity>, Class<? extends Entity>> subEntityMap = new HashMap();

    public static void registerBlock(Block block) {
        if (blockList == null) {
            return;
        }
        if (!blockList.contains(block)) {
            blockList.add(block);
        }
    }

    public static void registerBlocks(IForgeRegistry registry) {
        if (blockList == null) {
            return;
        }
        for (int i = 0; i < blockList.size(); ++i) {
            registry.register((IForgeRegistryEntry)blockList.get(i));
        }
        blockList = null;
    }

    public static void registerItem(Item item) {
        if (itemList == null) {
            return;
        }
        if (!itemList.contains(item)) {
            itemList.add(item);
        }
    }

    public static void registerItems(IForgeRegistry registry) {
        if (itemList == null) {
            return;
        }
        for (int i = 0; i < itemList.size(); ++i) {
            registry.register((IForgeRegistryEntry)itemList.get(i));
        }
        itemList = null;
    }

    public static void registerItemRenderer(Item item) {
        if (!itemListRenderers.contains(item)) {
            itemListRenderers.add(item);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerItemRenderers() {
        for (int i = 0; i < itemListRenderers.size(); ++i) {
            Item item = itemListRenderers.get(i);
            ModelResourceLocation model = new ModelResourceLocation(item.getRegistryName(), "inventory");
            ModelLoader.registerItemVariants((Item)item, (ResourceLocation[])new ResourceLocation[]{model});
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)model);
        }
    }

    public static void registerGuiHandler(IGuiHandler guiHandler) {
        if (!guiHandlers.contains(guiHandler)) {
            guiHandlers.add(guiHandler);
        }
    }

    public static void registerGuiHandlers() {
        for (int i = 0; i < guiHandlers.size(); ++i) {
            NetworkRegistry.INSTANCE.registerGuiHandler((Object)Main.instance, guiHandlers.get(i));
        }
    }

    public static <T extends Entity> void registerEntity(String name, String ModID, Class<T> entity, int trackingRange, int updateFrequency, boolean velocityUpdates) {
        if (!entityList.contains(entity)) {
            entityList.add(entity);
            entityTrackingRange.add(trackingRange);
            entityUpdateFrequency.add(updateFrequency);
            sendsVelocityUpdates.add(velocityUpdates);
            entityNames.add(name);
            entityModIds.add(ModID);
        }
    }

    public static void registerEntities() {
        for (int i = 0; i < entityList.size(); ++i) {
            Class<? extends Entity> entityClass = entityList.get(i);
            EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation(entityModIds.get(i), entityNames.get(i)), entityClass, (String)entityNames.get(i), (int)i, (Object)entityModIds.get(i), (int)entityTrackingRange.get(i), (int)entityUpdateFrequency.get(i), (boolean)sendsVelocityUpdates.get(i));
        }
    }
}

