/*
 * Decompiled with CFR 0.152.
 */
package sandro.Core.Patch.MC1_12;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.fml.common.FMLContainer;
import net.minecraftforge.fml.common.InjectedModContainer;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import sandro.Core.PatchLibrary.PatchLoader;
import sandro.Core.PatchRegistry.IRegistry.IPatchLibrary;

public class PatchLibrary
implements IPatchLibrary {
    private static String ModID = null;
    private static ASMDataTable asmData;

    @Override
    public void setRegistryName(Object obj, String name) {
        IForgeRegistryEntry.Impl reg = (IForgeRegistryEntry.Impl)obj;
        if (reg.getRegistryName() != null) {
            throw new IllegalStateException("Attempted to set registry name with existing registry name! New: " + name + " Old: " + reg.getRegistryName());
        }
        int index = name.lastIndexOf(58);
        String oldPrefix = index == -1 ? "" : name.substring(0, index);
        name = index == -1 ? name : name.substring(index + 1);
        String prefix = this.getModID();
        if (!oldPrefix.equals("")) {
            prefix = oldPrefix;
        }
        PatchLoader.setPrivateField(reg, IForgeRegistryEntry.Impl.class, "registryName", new ResourceLocation(prefix, name));
    }

    @Override
    public String getModID() {
        if (ModID != null) {
            return ModID;
        }
        ModContainer mc = Loader.instance().activeModContainer();
        String prefix = mc == null || mc instanceof InjectedModContainer && ((InjectedModContainer)mc).wrappedContainer instanceof FMLContainer ? "minecraft" : mc.getModId().toLowerCase();
        return prefix;
    }

    @Override
    public void setModID(String modid) {
        ModID = modid;
    }

    @Override
    public void sendWindowProperty(IContainerListener icontainerlistener, Container containerIn, int varToUpdate, int newValue) {
        icontainerlistener.func_71112_a(containerIn, varToUpdate, newValue);
    }

    @Override
    public void drawString(GuiContainer gui, String text, int x, int y, int color) {
        Minecraft mc = Minecraft.func_71410_x();
        FontRenderer fontRenderObj = mc.field_71466_p;
        fontRenderObj.func_78276_b(text, x, y, color);
    }

    @Override
    public boolean intersectsWith(AxisAlignedBB object, AxisAlignedBB other) {
        return object.func_72326_a(other);
    }

    @Override
    public boolean attemptDamageItem(ItemStack stack, int amount, Random random) {
        return stack.func_96631_a(amount, random, null);
    }

    @Override
    public boolean pistonCanPush(IBlockState state) {
        return state.func_185905_o() != EnumPushReaction.BLOCK;
    }

    @Override
    public boolean pistonCanDestroy(IBlockState state) {
        return state.func_185905_o() == EnumPushReaction.DESTROY;
    }

    @Override
    public boolean pistonCanPushOnly(IBlockState state) {
        return state.func_185905_o() == EnumPushReaction.PUSH_ONLY;
    }

    @Override
    public boolean pistonCanStick(IBlockState state) {
        return state.func_185905_o() == EnumPushReaction.NORMAL;
    }

    @Override
    public Block getBlockFromName(String name) {
        return Block.func_149684_b((String)name);
    }

    @Override
    public List<Block> getModBlockList(String domain) {
        ArrayList<Block> list = new ArrayList<Block>();
        Set set = ForgeRegistries.BLOCKS.getEntries();
        for (Map.Entry e : set) {
            if (!((ResourceLocation)e.getKey()).func_110624_b().equals(domain)) continue;
            list.add((Block)e.getValue());
        }
        return list;
    }

    @Override
    public List<Block> getBlockList() {
        ArrayList<Block> list = new ArrayList<Block>();
        Set set = ForgeRegistries.BLOCKS.getEntries();
        for (Map.Entry e : set) {
            list.add((Block)e.getValue());
        }
        return list;
    }

    public static void setASMData(ASMDataTable asmDataTable) {
        asmData = asmDataTable;
    }

    @Override
    public ASMDataTable getASMData() {
        return asmData;
    }
}

