/*
 * Decompiled with CFR 0.152.
 */
package democat.aggrotp.handlers;

import democat.aggrotp.AggroTP;
import democat.aggrotp.config.Configuration;
import democat.aggrotp.util.MathMethods;
import democat.aggrotp.util.SoundMethods;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import org.apache.logging.log4j.Level;

public class EntityEventHandler {
    private Map<EntityLiving, Map.Entry<Configuration.MobEntry, Integer>> tpTimer = new HashMap<EntityLiving, Map.Entry<Configuration.MobEntry, Integer>>();

    @SubscribeEvent
    public void setAttackTargetEvent(LivingSetAttackTargetEvent event) {
        EntityLivingBase mob = event.getEntityLiving();
        EntityLivingBase target = event.getTarget();
        if (mob == null || target == null || mob instanceof FakePlayer || target instanceof FakePlayer || target.field_70170_p.field_72995_K) {
            return;
        }
        this.debug("Living entity " + mob.func_70005_c_() + " has acquired attack target " + target.func_70005_c_());
        if (!(mob instanceof EntityLiving) || !(target instanceof EntityPlayer)) {
            return;
        }
        this.debug("Passed first check");
        EntityLiving livingMob = (EntityLiving)mob;
        EntityPlayer targetPlayer = (EntityPlayer)target;
        EntityEntry ee = EntityRegistry.getEntry(livingMob.getClass());
        if (ee == null) {
            return;
        }
        this.debug("Entity registry entry found: " + ee.getRegistryName());
        if (ee != null && Configuration.mobTeleports.containsKey(ee.getRegistryName())) {
            AggroTP.logger.log(Level.DEBUG, "Target " + livingMob.func_70005_c_() + " has attack target " + (livingMob.func_70638_az() != null ? livingMob.func_70638_az().func_70005_c_() : "NULL"));
            if (!this.tpTimer.containsKey(livingMob) && livingMob.func_70638_az() instanceof EntityPlayer) {
                Configuration.MobEntry mobentry = Configuration.mobTeleports.get(ee.getRegistryName());
                int delay = (int)MathMethods.randomRangeSec((float)mobentry.delay - mobentry.offset, (float)mobentry.delay + mobentry.offset);
                this.debug("Entry for " + livingMob.func_70005_c_() + " does not exist in tpTimer. Placing entry with timer " + delay);
                this.tpTimer.put(livingMob, new AbstractMap.SimpleEntry<Configuration.MobEntry, Integer>(mobentry, delay));
            } else if (livingMob.func_70638_az() instanceof EntityPlayer && this.tpTimer.get(livingMob).getValue() == -1) {
                Configuration.MobEntry mobentry = Configuration.mobTeleports.get(ee.getRegistryName());
                int delay = (int)MathMethods.randomRangeSec((float)mobentry.delay - mobentry.offset, (float)mobentry.delay + mobentry.offset);
                this.debug("Entry for " + livingMob.func_70005_c_() + " exists in tpTimer. Replacing entry with timer " + delay);
                this.tpTimer.replace(livingMob, new AbstractMap.SimpleEntry<Configuration.MobEntry, Integer>(mobentry, delay));
            }
        }
    }

    @SubscribeEvent
    public void serverTickEvent(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        this.tpTimer.forEach((entity, entry) -> {
            if (entity.field_70128_L && (Integer)entry.getValue() != -1) {
                entry.setValue(-1);
                this.debug("Entity is dead. Setting timer to -1: " + entity.func_70005_c_());
            } else if ((Integer)entry.getValue() == 0) {
                Configuration.MobEntry mobentry = (Configuration.MobEntry)entry.getKey();
                this.debug("Timer is 0 for entity " + entity.func_70005_c_() + ". Preparing to tp.");
                boolean success = this.teleport((EntityLiving)entity, mobentry);
                this.debug("TP Success: " + success);
                entry.setValue((int)MathMethods.randomRangeSec((float)mobentry.delay - mobentry.offset, (float)mobentry.delay + mobentry.offset));
                this.debug("Setting timer of entity " + entity.func_70005_c_() + " to " + entry.getValue());
            } else if ((Integer)entry.getValue() > 0) {
                if (entity.func_70638_az() instanceof EntityPlayer) {
                    entry.setValue((Integer)entry.getValue() - 1);
                    this.debug("Decrementing... " + entity.func_70005_c_() + " has timer value " + entry.getValue());
                } else {
                    entry.setValue(-1);
                    this.debug("Entity " + entity.func_70005_c_() + " no longer has player attack target. Setting timer to -1.");
                }
            }
        });
    }

    public boolean teleport(EntityLiving target, Configuration.MobEntry entry) {
        if (!(target.func_70638_az() instanceof EntityPlayer)) {
            return false;
        }
        this.debug("TP method: passed first check.");
        EntityPlayer attacker = (EntityPlayer)target.func_70638_az();
        if (attacker == null || attacker instanceof FakePlayer || attacker.field_70128_L) {
            return false;
        }
        this.debug("TP method: passed second check.");
        ArrayList<EntityPlayer> entityTeleportList = new ArrayList<EntityPlayer>();
        if (entry.tpAllPlayers) {
            entityTeleportList.addAll(target.field_70170_p.field_73010_i);
        } else {
            entityTeleportList.add(attacker);
        }
        this.debug("Entity teleport list: " + ((Object)entityTeleportList).toString());
        boolean success = true;
        for (EntityPlayer player : entityTeleportList) {
            double x = target.field_70165_t + (Math.random() - 0.5) * (double)entry.radius * 2.0;
            double temp = Math.random() - 0.5;
            double y = target.field_70163_u + (temp < 0.0 ? 0.0 : temp) * (double)entry.radius * 2.0;
            double z = target.field_70161_v + (Math.random() - 0.5) * (double)entry.radius * 2.0;
            this.debug("Obtained x, y, z " + x + ", " + y + ", " + z + " for player " + player.func_70005_c_());
            EnderTeleportEvent event = new EnderTeleportEvent((EntityLivingBase)player, x, y, z, 0.0f);
            if (MinecraftForge.EVENT_BUS.post((Event)event) || event == null || player == null) continue;
            this.debug("EVENT BUS Post check passed for " + player.func_70005_c_());
            boolean flag = player.func_184595_k(event.getTargetX(), event.getTargetY(), event.getTargetZ());
            if (flag) {
                SoundMethods.playSound((Entity)player, SoundEvents.field_187534_aX);
                this.debug("Played tp sound");
                continue;
            }
            this.debug("Attempting second teleport directly");
            event = new EnderTeleportEvent((EntityLivingBase)player, target.field_70165_t, target.field_70163_u, target.field_70161_v, 0.0f);
            flag = player.func_184595_k(event.getTargetX(), event.getTargetY(), event.getTargetZ());
            if (flag) {
                SoundEvent sound = new SoundEvent(entry.soundResloc);
                SoundMethods.playSound((Entity)player, sound);
                this.debug("Played tp sound");
                continue;
            }
            success = false;
        }
        return success;
    }

    private void info(String message) {
        AggroTP.logger.log(Level.INFO, message);
    }

    private void debug(String message) {
        if (Configuration.debug) {
            AggroTP.logger.log(Level.DEBUG, message);
        }
    }

    private void warn(String message) {
        AggroTP.logger.log(Level.WARN, message);
    }

    private void error(String message) {
        AggroTP.logger.log(Level.ERROR, message);
    }
}

