/*
 * Decompiled with CFR 0.152.
 */
package logictechcorp.netherex.world.generation.layer;

import java.util.ArrayList;
import logictechcorp.libraryex.world.biome.data.BiomeData;
import logictechcorp.netherex.NetherEx;
import net.minecraft.init.Biomes;
import net.minecraft.util.WeightedRandom;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.layer.GenLayer;
import net.minecraft.world.gen.layer.IntCache;
import net.minecraftforge.common.BiomeManager;

public class GenLayerNetherSubBiome
extends GenLayer {
    private final GenLayer subBiomeLayer;

    public GenLayerNetherSubBiome(long seed, GenLayer biomeLayer, GenLayer subBiomeLayer) {
        super(seed);
        this.field_75909_a = biomeLayer;
        this.subBiomeLayer = subBiomeLayer;
    }

    public int[] func_75904_a(int areaX, int areaY, int areaWidth, int areaHeight) {
        int outerWidth = areaWidth + 2;
        int outerHeight = areaHeight + 2;
        int[] biomeIds = this.field_75909_a.func_75904_a(areaX - 1, areaY - 1, outerWidth, outerHeight);
        int[] subBiomeChances = this.subBiomeLayer.func_75904_a(areaX - 1, areaY - 1, outerWidth, outerHeight);
        int[] outputs = IntCache.func_76445_a((int)(areaWidth * areaHeight));
        for (int y = 0; y < areaHeight; ++y) {
            for (int x = 0; x < areaWidth; ++x) {
                boolean tryRareHillsBiome;
                this.func_75903_a(x + areaX, y + areaY);
                int biomeId = biomeIds[x + 1 + (y + 1) * outerWidth];
                int subBiomeChance = subBiomeChances[x + 1 + (y + 1) * outerWidth] % 29;
                boolean tryRareBiome = subBiomeChance == 1;
                boolean bl = tryRareHillsBiome = subBiomeChance == 2;
                if (biomeId != 0 && tryRareBiome) {
                    outputs[x + y * areaWidth] = this.getRandomBiome(biomeId);
                    continue;
                }
                if (this.func_75902_a(3) != 0 && !tryRareHillsBiome) {
                    outputs[x + y * areaWidth] = biomeId;
                    continue;
                }
                int subBiomeId = this.getRandomBiome(biomeId);
                if (subBiomeId == biomeId) {
                    outputs[x + y * areaWidth] = biomeId;
                    continue;
                }
                if (tryRareHillsBiome) {
                    subBiomeId = this.getRandomBiome(subBiomeId);
                }
                int biomeNorth = biomeIds[x + 1 + (y + 1 - 1) * outerWidth];
                int biomeEast = biomeIds[x + 1 + 1 + (y + 1) * outerWidth];
                int biomeWest = biomeIds[x + 1 - 1 + (y + 1) * outerWidth];
                int biomeSouth = biomeIds[x + 1 + (y + 1 + 1) * outerWidth];
                int surroundingSameCount = 0;
                if (GenLayerNetherSubBiome.func_151616_a((int)biomeNorth, (int)biomeId)) {
                    ++surroundingSameCount;
                }
                if (GenLayerNetherSubBiome.func_151616_a((int)biomeEast, (int)biomeId)) {
                    ++surroundingSameCount;
                }
                if (GenLayerNetherSubBiome.func_151616_a((int)biomeWest, (int)biomeId)) {
                    ++surroundingSameCount;
                }
                if (GenLayerNetherSubBiome.func_151616_a((int)biomeSouth, (int)biomeId)) {
                    ++surroundingSameCount;
                }
                outputs[x + y * areaWidth] = surroundingSameCount >= 3 ? subBiomeId : biomeId;
            }
        }
        return outputs;
    }

    private int getRandomBiome(int biomeId) {
        Biome biome = Biome.func_185357_a((int)biomeId);
        if (biome != null) {
            BiomeData biomeData = NetherEx.BIOME_DATA_MANAGER.getBiomeData(biome);
            if (biomeData != BiomeData.EMPTY) {
                ArrayList<BiomeManager.BiomeEntry> biomeEntries = new ArrayList<BiomeManager.BiomeEntry>();
                for (BiomeData subBiomeData : biomeData.getSubBiomes()) {
                    if (subBiomeData == null || !subBiomeData.isEnabled()) continue;
                    biomeEntries.add(new BiomeManager.BiomeEntry(subBiomeData.getBiome(), subBiomeData.getGenerationWeight()));
                }
                int biomeWeights = WeightedRandom.func_76272_a(biomeEntries);
                if (biomeWeights > 0) {
                    return Biome.func_185362_a((Biome)((BiomeManager.BiomeEntry)WeightedRandom.func_180166_a(biomeEntries, (int)this.func_75902_a((int)biomeWeights))).biome);
                }
            }
            return biomeId;
        }
        return Biome.func_185362_a((Biome)Biomes.field_76778_j);
    }
}

