/*
 * Decompiled with CFR 0.152.
 */
package logictechcorp.netherex.world.biome.data;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import logictechcorp.libraryex.LibraryEx;
import logictechcorp.libraryex.utility.WorldHelper;
import logictechcorp.libraryex.world.biome.data.BiomeData;
import logictechcorp.libraryex.world.biome.data.BiomeDataManager;
import logictechcorp.netherex.NetherEx;
import logictechcorp.netherex.NetherExConfig;
import logictechcorp.netherex.world.biome.data.BiomeDataBOP;
import logictechcorp.netherex.world.biome.data.BiomeDataNetherEx;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraftforge.event.world.WorldEvent;

public class BiomeDataManagerNetherEx
extends BiomeDataManager {
    public BiomeDataManagerNetherEx(String loggerName) {
        super(loggerName);
    }

    public void setup() {
        super.setup();
        if (NetherExConfig.biome.general.useGlobalBiomeConfigs) {
            Path globalBiomeConfigDirectoryPath = LibraryEx.CONFIG_DIRECTORY.toPath().resolve("netherex").resolve("nether_biomes");
            this.createBiomeDataConfigs(globalBiomeConfigDirectoryPath);
        }
    }

    public void onWorldLoad(WorldEvent.Load event) {
        World world = event.getWorld();
        if (!world.field_72995_K && world.field_73011_w.getDimension() == DimensionType.OVERWORLD.func_186068_a() && NetherExConfig.dimension.nether.overrideNether) {
            int worldTypeId;
            if (NetherExConfig.biome.general.useGlobalBiomeConfigs) {
                Path globalBiomeConfigDirectoryPath = LibraryEx.CONFIG_DIRECTORY.toPath().resolve("netherex").resolve("nether_biomes");
                this.readBiomeDataConfigs(globalBiomeConfigDirectoryPath);
            }
            if (NetherExConfig.biome.general.usePerWorldBiomeConfigs) {
                Path perWorldBiomeConfigDirectoryPath = Paths.get(WorldHelper.getSaveDirectory((World)event.getWorld()), "config", "netherex", "nether_biomes");
                this.createBiomeDataConfigs(perWorldBiomeConfigDirectoryPath);
                this.readBiomeDataConfigs(perWorldBiomeConfigDirectoryPath);
            }
            if (NetherEx.BIOMES_O_PLENTY_LOADED && ((worldTypeId = world.func_175624_G().func_82747_f()) < 6 || worldTypeId == 8)) {
                ArrayList biomes = new ArrayList();
                this.currentBiomeData.forEach((resourceLocation, biomeData) -> {
                    if (resourceLocation.func_110624_b().equals("biomesoplenty")) {
                        biomes.add(biomeData.getBiome());
                    }
                });
                biomes.forEach(arg_0 -> ((BiomeDataManagerNetherEx)this).unregisterBiomeData(arg_0));
            }
        }
    }

    public void onWorldUnload(WorldEvent.Unload event) {
        World world = event.getWorld();
        if (!world.field_72995_K && world.field_73011_w.getDimension() == DimensionType.OVERWORLD.func_186068_a()) {
            this.currentBiomeData.clear();
            this.currentBiomeEntries.clear();
        }
    }

    public BiomeData createBiomeData(ResourceLocation biomeRegistryName, int generationWeight, boolean useDefaultDecorations, boolean isSubBiome) {
        if (biomeRegistryName.func_110624_b().equals("biomesoplenty")) {
            return new BiomeDataBOP(biomeRegistryName, generationWeight, useDefaultDecorations, isSubBiome);
        }
        return new BiomeDataNetherEx(biomeRegistryName, generationWeight, useDefaultDecorations, isSubBiome);
    }
}

