/*
 * Decompiled with CFR 0.152.
 */
package logictechcorp.netherex.village;

import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;

public class PigtificateVillageFenceGateInfo {
    private final BlockPos pos;
    private final BlockPos insidePos;
    private final EnumFacing inside;
    private int lastActivityTime;
    private boolean isDetachedFromVillage;
    private int openRestrictionCounter;

    public PigtificateVillageFenceGateInfo(BlockPos pos, int deltaX, int deltaZ, int time) {
        this(pos, PigtificateVillageFenceGateInfo.getFaceDirection(deltaX, deltaZ), time);
    }

    public PigtificateVillageFenceGateInfo(BlockPos pos, EnumFacing facing, int time) {
        this.pos = pos;
        this.inside = facing;
        this.insidePos = pos.func_177967_a(facing, 2);
        this.lastActivityTime = time;
    }

    private static EnumFacing getFaceDirection(int deltaX, int deltaZ) {
        return deltaX < 0 ? EnumFacing.WEST : (deltaX > 0 ? EnumFacing.EAST : (deltaZ < 0 ? EnumFacing.NORTH : EnumFacing.SOUTH));
    }

    public int getDistanceSquared(int x, int y, int z) {
        return (int)this.pos.func_177954_c((double)x, (double)y, (double)z);
    }

    public int getDistanceToFenceGateSq(BlockPos pos) {
        return (int)pos.func_177951_i((Vec3i)this.getPos());
    }

    public int getDistanceToInsideBlockSq(BlockPos pos) {
        return (int)this.insidePos.func_177951_i((Vec3i)pos);
    }

    public boolean isInside(BlockPos pos) {
        int x = pos.func_177958_n() - this.pos.func_177958_n();
        int z = pos.func_177952_p() - this.pos.func_177956_o();
        return x * this.inside.func_82601_c() + z * this.inside.func_82599_e() >= 0;
    }

    public void resetOpenRestrictionCounter() {
        this.openRestrictionCounter = 0;
    }

    public void incrementOpenRestrictionCounter() {
        ++this.openRestrictionCounter;
    }

    public int getOpenRestrictionCounter() {
        return this.openRestrictionCounter;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public BlockPos getInsidePos() {
        return this.insidePos;
    }

    public int getInsideOffsetX() {
        return this.inside.func_82601_c() * 2;
    }

    public int getInsideOffsetZ() {
        return this.inside.func_82599_e() * 2;
    }

    public int getLastActivityTime() {
        return this.lastActivityTime;
    }

    public void setLastActivityTime(int time) {
        this.lastActivityTime = time;
    }

    public boolean isDetachedFromVillageFlag() {
        return this.isDetachedFromVillage;
    }

    public void setDetachedFromVillageFlag(boolean detached) {
        this.isDetachedFromVillage = detached;
    }

    public EnumFacing getInside() {
        return this.inside;
    }
}

