/*
 * Decompiled with CFR 0.152.
 */
package logictechcorp.netherex.block;

import java.util.Locale;
import java.util.Random;
import logictechcorp.libraryex.block.BlockMod;
import logictechcorp.libraryex.block.property.BlockProperties;
import logictechcorp.libraryex.utility.CollectionHelper;
import logictechcorp.libraryex.utility.EntityHelper;
import logictechcorp.netherex.NetherEx;
import logictechcorp.netherex.NetherExConfig;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockThornstalk
extends BlockMod {
    public static final PropertyEnum<EnumPart> PART = PropertyEnum.func_177709_a((String)"part", EnumPart.class);
    protected static final AxisAlignedBB THORNSTALK_AABB = new AxisAlignedBB(0.09999999403953552, 0.0, 0.09999999403953552, (double)0.9f, (double)0.8f, (double)0.9f);

    public BlockThornstalk() {
        super(NetherEx.getResource("thornstalk"), new BlockProperties(Material.field_151585_k, MapColor.field_151650_B).sound(SoundType.field_185850_c));
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return THORNSTALK_AABB;
    }

    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess world, BlockPos pos) {
        return field_185506_k;
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        if (entity instanceof EntityPlayer) {
            entity.func_70097_a(DamageSource.field_76367_g, 1.0f);
        } else if (entity instanceof EntityLivingBase && !CollectionHelper.contains((String[])NetherExConfig.block.thornstalk.mobBlacklist, (String)EntityHelper.getEntityLocation((EntityLivingBase)((EntityLivingBase)entity)))) {
            entity.func_70097_a(DamageSource.field_76367_g, 1.0f);
        } else if (entity instanceof EntityItem && NetherExConfig.block.thornstalk.canDestroyItems) {
            entity.func_70097_a(DamageSource.field_76367_g, 1.0f);
        }
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block neighbor, BlockPos fromPos) {
        Block blockUp = world.func_180495_p(pos.func_177984_a()).func_177230_c();
        IBlockState blockDown = world.func_180495_p(pos.func_177977_b());
        if (blockUp != Blocks.field_150350_a && blockUp != this || !blockDown.isSideSolid((IBlockAccess)world, pos.func_177977_b(), EnumFacing.UP) && blockDown.func_177230_c() != this) {
            world.func_175655_b(pos, true);
        } else {
            world.func_180501_a(pos, this.func_176221_a(state, (IBlockAccess)world, pos), 2);
        }
    }

    public boolean func_176196_c(World world, BlockPos pos) {
        Block block = world.func_180495_p(pos).func_177230_c();
        Block blockDown = world.func_180495_p(pos.func_177977_b()).func_177230_c();
        Block blockDown2 = world.func_180495_p(pos.func_177979_c(2)).func_177230_c();
        Block blockDown3 = world.func_180495_p(pos.func_177979_c(3)).func_177230_c();
        return !(blockDown == this && blockDown2 == this && blockDown3 == this || block != Blocks.field_150350_a || blockDown != this && blockDown != Blocks.field_150425_aM);
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        IBlockState stateUp = world.func_180495_p(pos.func_177984_a());
        if (stateUp.func_177230_c() != this) {
            return state.func_177226_a(PART, (Comparable)((Object)EnumPart.TOP));
        }
        if (stateUp == state.func_177226_a(PART, (Comparable)((Object)EnumPart.TOP))) {
            return state.func_177226_a(PART, (Comparable)((Object)EnumPart.MIDDLE));
        }
        return state.func_177226_a(PART, (Comparable)((Object)EnumPart.BOTTOM));
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(PART, (Comparable)((Object)EnumPart.fromMeta(meta)));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumPart)((Object)state.func_177229_b(PART))).ordinal();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{PART});
    }

    public void generate(World world, Random random, BlockPos pos) {
        int height = random.nextInt(3) + 1;
        if (height == 1) {
            world.func_180501_a(pos, this.func_176223_P().func_177226_a(PART, (Comparable)((Object)EnumPart.TOP)), 2);
        } else if (height == 2) {
            world.func_180501_a(pos.func_177984_a(), this.func_176223_P().func_177226_a(PART, (Comparable)((Object)EnumPart.TOP)), 2);
            world.func_180501_a(pos, this.func_176223_P().func_177226_a(PART, (Comparable)((Object)EnumPart.MIDDLE)), 2);
        } else {
            world.func_180501_a(pos.func_177981_b(2), this.func_176223_P().func_177226_a(PART, (Comparable)((Object)EnumPart.TOP)), 2);
            world.func_180501_a(pos.func_177984_a(), this.func_176223_P().func_177226_a(PART, (Comparable)((Object)EnumPart.MIDDLE)), 2);
            world.func_180501_a(pos, this.func_176223_P().func_177226_a(PART, (Comparable)((Object)EnumPart.BOTTOM)), 2);
        }
    }

    public PathNodeType getAiPathNodeType(IBlockState state, IBlockAccess world, BlockPos pos) {
        return PathNodeType.DAMAGE_CACTUS;
    }

    public static enum EnumPart implements IStringSerializable
    {
        TOP,
        MIDDLE,
        BOTTOM;


        public String func_176610_l() {
            return this.toString().toLowerCase(Locale.ENGLISH);
        }

        public static EnumPart fromMeta(int meta) {
            if (meta < 0 || meta >= EnumPart.values().length) {
                meta = 0;
            }
            return EnumPart.values()[meta];
        }
    }
}

