/*
 * Decompiled with CFR 0.152.
 */
package logictechcorp.netherex.block;

import com.google.common.base.Predicate;
import logictechcorp.libraryex.block.BlockMod;
import logictechcorp.libraryex.block.HarvestLevel;
import logictechcorp.libraryex.block.HarvestTool;
import logictechcorp.libraryex.block.property.BlockProperties;
import logictechcorp.netherex.NetherEx;
import logictechcorp.netherex.entity.neutral.EntityGoldGolem;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockWorldState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.block.state.pattern.BlockMaterialMatcher;
import net.minecraft.block.state.pattern.BlockPattern;
import net.minecraft.block.state.pattern.BlockStateMatcher;
import net.minecraft.block.state.pattern.FactoryBlockPattern;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class BlockAmethyst
extends BlockMod {
    private BlockPattern golemBasePattern;
    private BlockPattern golemPattern;

    public BlockAmethyst() {
        super(NetherEx.getResource("amethyst_block"), new BlockProperties(Material.field_151573_f, MapColor.field_151678_z).harvestLevel(HarvestTool.PICKAXE, HarvestLevel.IRON).hardness(5.0f).resistance(10.0f));
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        this.tryToSpawnGolem(world, pos);
    }

    private void tryToSpawnGolem(World world, BlockPos pos) {
        BlockPattern.PatternHelper golemPattern = this.getGolemPattern().func_177681_a(world, pos);
        if (golemPattern != null) {
            for (int palmOffset = 0; palmOffset < this.getGolemPattern().func_177684_c(); ++palmOffset) {
                for (int thumbOffset = 0; thumbOffset < this.getGolemPattern().func_177685_b(); ++thumbOffset) {
                    world.func_180501_a(golemPattern.func_177670_a(palmOffset, thumbOffset, 0).func_177508_d(), Blocks.field_150350_a.func_176223_P(), 2);
                }
            }
            BlockPos blockpos = golemPattern.func_177670_a(1, 2, 0).func_177508_d();
            EntityGoldGolem goldGolem = new EntityGoldGolem(world);
            goldGolem.setPlayerCreated(true);
            goldGolem.func_70012_b((double)blockpos.func_177958_n() + 0.5, (double)blockpos.func_177956_o() + 0.05, (double)blockpos.func_177952_p() + 0.5, 0.0f, 0.0f);
            world.func_72838_d((Entity)goldGolem);
            for (EntityPlayerMP player : world.func_72872_a(EntityPlayerMP.class, goldGolem.func_174813_aQ().func_186662_g(5.0))) {
                CriteriaTriggers.field_192133_m.func_192229_a(player, (Entity)goldGolem);
            }
            for (int i = 0; i < 120; ++i) {
                world.func_175688_a(EnumParticleTypes.SNOWBALL, (double)blockpos.func_177958_n() + world.field_73012_v.nextDouble(), (double)blockpos.func_177956_o() + world.field_73012_v.nextDouble() * 3.9, (double)blockpos.func_177952_p() + world.field_73012_v.nextDouble(), 0.0, 0.0, 0.0, new int[0]);
            }
            for (int palmOffset = 0; palmOffset < this.getGolemPattern().func_177684_c(); ++palmOffset) {
                for (int thumbOffset = 0; thumbOffset < this.getGolemPattern().func_177685_b(); ++thumbOffset) {
                    BlockWorldState worldState = golemPattern.func_177670_a(palmOffset, thumbOffset, 0);
                    world.func_175722_b(worldState.func_177508_d(), Blocks.field_150350_a, false);
                }
            }
        }
    }

    public boolean canDispenserPlace(World world, BlockPos pos) {
        return this.getGolemBasePattern().func_177681_a(world, pos) != null;
    }

    protected BlockPattern getGolemBasePattern() {
        if (this.golemBasePattern == null) {
            this.golemBasePattern = FactoryBlockPattern.func_177660_a().func_177659_a(new String[]{"~ ~", "###", "~#~"}).func_177662_a('#', BlockWorldState.func_177510_a((Predicate)BlockStateMatcher.func_177638_a((Block)Blocks.field_150340_R))).func_177662_a('~', BlockWorldState.func_177510_a((Predicate)BlockMaterialMatcher.func_189886_a((Material)Material.field_151579_a))).func_177661_b();
        }
        return this.golemBasePattern;
    }

    private BlockPattern getGolemPattern() {
        if (this.golemPattern == null) {
            this.golemPattern = FactoryBlockPattern.func_177660_a().func_177659_a(new String[]{"~^~", "###", "~#~"}).func_177662_a('^', BlockWorldState.func_177510_a(state -> state != null && state.func_177230_c() == this)).func_177662_a('#', BlockWorldState.func_177510_a((Predicate)BlockStateMatcher.func_177638_a((Block)Blocks.field_150340_R))).func_177662_a('~', BlockWorldState.func_177510_a((Predicate)BlockMaterialMatcher.func_189886_a((Material)Material.field_151579_a))).func_177661_b();
        }
        return this.golemPattern;
    }
}

