/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.trident.sound;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="trident")
public class TridentSounds {
    public static final List<SoundEvent> SOUNDS = Lists.newArrayList();
    public static final SoundEvent ITEM_TRIDENT_HIT = TridentSounds.register("item.trident.hit");
    public static final SoundEvent ITEM_TRIDENT_HIT_GROUND = TridentSounds.register("item.trident.hit_ground");
    public static final SoundEvent ITEM_TRIDENT_RETURN = TridentSounds.register("item.trident.return");
    public static final SoundEvent ITEM_TRIDENT_RIPTIDE_1 = TridentSounds.register("item.trident.riptide_1");
    public static final SoundEvent ITEM_TRIDENT_RIPTIDE_2 = TridentSounds.register("item.trident.riptide_2");
    public static final SoundEvent ITEM_TRIDENT_RIPTIDE_3 = TridentSounds.register("item.trident.riptide_3");
    public static final SoundEvent ITEM_TRIDENT_THROW = TridentSounds.register("item.trident.throw");
    public static final SoundEvent ITEM_TRIDENT_THUNDER = TridentSounds.register("item.trident.thunder");

    public static SoundEvent register(String key) {
        ResourceLocation location = new ResourceLocation("trident", key);
        SoundEvent sound = (SoundEvent)new SoundEvent(location).setRegistryName(location);
        SOUNDS.add(sound);
        return sound;
    }

    @SubscribeEvent
    public static void onSoundEventRegistration(RegistryEvent.Register<SoundEvent> event) {
        SOUNDS.forEach(sound -> event.getRegistry().register((IForgeRegistryEntry)sound));
    }
}

