/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.trident.mixin;

import com.github.alexthe666.iceandfire.item.ItemTideTrident;
import com.google.common.collect.Multimap;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.trident.Trident;
import net.minecraft.trident.compat.iceandfire.EntityTideTrident;
import net.minecraft.trident.compat.iceandfire.IceAndFireInit;
import net.minecraft.trident.compat.iceandfire.RenderItemTideTrident;
import net.minecraft.trident.entity.EntityTrident;
import net.minecraft.trident.item.ITrident;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Pseudo;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Pseudo
@Mixin(value={ItemTideTrident.class})
public class MixinItemTideTrident
extends Item
implements ITrident {
    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void init(CallbackInfo info) {
        this.func_185043_a(new ResourceLocation("throwing"), (stack, world, entity) -> entity != null && entity.func_184587_cr() && entity.func_184607_cu() == stack ? 2.0f : 0.0f);
    }

    public boolean canDestroyBlockInCreative(World world, BlockPos pos, ItemStack stack, EntityPlayer player) {
        return !player.func_184812_l_();
    }

    @Inject(method={"onPlayerStoppedUsing"}, at={@At(value="HEAD")}, cancellable=true)
    private void onPlayerStoppedUsing(ItemStack stack, World world, EntityLivingBase living, int timeLeft, CallbackInfo info) {
        ITrident.super.onPlayerStoppedUsing(stack, world, living, timeLeft);
        info.cancel();
    }

    @Override
    public EntityTrident getTrident(World world, EntityLivingBase thrower, ItemStack stack) {
        return new EntityTideTrident(world, thrower, stack);
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return Trident.SPEAR;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        return ITrident.super.onItemRightClick(world, player, hand);
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase target, EntityLivingBase attacker) {
        stack.func_77972_a(1, attacker);
        return true;
    }

    public boolean func_179218_a(ItemStack stack, World world, IBlockState state, BlockPos pos, EntityLivingBase living) {
        if ((double)state.func_185887_b(world, pos) != 0.0) {
            stack.func_77972_a(2, living);
        }
        return true;
    }

    public Multimap<String, AttributeModifier> func_111205_h(EntityEquipmentSlot slot) {
        Multimap attributes = super.func_111205_h(slot);
        if (slot == EntityEquipmentSlot.MAINHAND) {
            attributes.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Weapon modifier", 12.0, 0));
            attributes.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(field_185050_h, "Weapon modifier", (double)-2.9f, 0));
        }
        return attributes;
    }

    public int func_77619_b() {
        return 1;
    }

    @Override
    public ModelResourceLocation getModel() {
        return IceAndFireInit.MODEL;
    }

    @Override
    public ModelResourceLocation getHandModel() {
        return IceAndFireInit.HAND_MODEL;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void render(ItemStack stack, ItemCameraTransforms.TransformType type) {
        RenderItemTideTrident.render(stack, type);
    }
}

