/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.trident.mixin;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.trident.util.EntityHelper;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={EntityLivingBase.class})
public abstract class MixinEntityLivingBase
extends Entity {
    public MixinEntityLivingBase(World world) {
        super(world);
    }

    public int getSpinAttackDuration() {
        return EntityHelper.getSpinAttackDuration(this);
    }

    public void setSpinAttackDuration(int time) {
        EntityHelper.setSpinAttackDuration(this, time);
    }

    @Inject(method={"onLivingUpdate()V"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/EntityLivingBase;collideWithNearbyEntities()V")})
    private void livingTick(CallbackInfo info) {
        if (this instanceof EntityPlayer && this.getSpinAttackDuration() > 0) {
            this.setSpinAttackDuration(this.getSpinAttackDuration() - 1);
            this.updateSpinAttack(this.func_174813_aQ(), this.func_174813_aQ());
        }
    }

    protected void updateSpinAttack(AxisAlignedBB before, AxisAlignedBB after) {
        AxisAlignedBB box = before.func_111270_a(after);
        List entities = this.field_70170_p.func_72839_b((Entity)this, box);
        if (!entities.isEmpty()) {
            for (int i = 0; i < entities.size(); ++i) {
                Entity entity = (Entity)entities.get(i);
                if (!(entity instanceof EntityLivingBase)) continue;
                this.spinAttack((EntityLivingBase)entity);
                this.setSpinAttackDuration(0);
                this.scale(-0.2);
                break;
            }
        } else if (this.field_70123_F) {
            this.setSpinAttackDuration(0);
        }
        if (!this.field_70170_p.field_72995_K && this.getSpinAttackDuration() <= 0) {
            this.setLivingFlag(false);
        }
    }

    public void scale(double factor) {
        this.field_70159_w *= factor;
        this.field_70181_x *= factor;
        this.field_70159_w = this.field_70179_y * factor;
    }

    protected void setLivingFlag(boolean value) {
        EntityHelper.setLivingFlag((EntityPlayer)this, value);
    }

    protected void spinAttack(EntityLivingBase target) {
        EntityPlayer player = (EntityPlayer)this;
        player.func_71059_n((Entity)target);
    }
}

