/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.trident.mixin;

import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.trident.entity.EntityTrident;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={EntityArrow.class})
public abstract class MixinEntityArrow
extends Entity {
    @Shadow
    private int field_145791_d;
    @Shadow
    private int field_145792_e;
    @Shadow
    private int field_145789_f;
    @Shadow
    private Block field_145790_g;
    @Shadow
    private int field_70253_h;
    @Shadow
    protected boolean field_70254_i;
    @Shadow
    protected int field_184552_b;
    @Shadow
    public int field_70249_b;
    @Shadow
    public Entity field_70250_c;
    @Shadow
    private int field_70252_j;
    @Shadow
    private int field_70257_an;

    public MixinEntityArrow(World world) {
        super(world);
    }

    @Inject(method={"onUpdate()V"}, at={@At(value="HEAD")}, cancellable=true)
    private void onTrident(CallbackInfo info) {
        if (this instanceof EntityTrident) {
            AxisAlignedBB box;
            EntityTrident trident = (EntityTrident)((Object)this);
            super.func_70071_h_();
            boolean flag = trident.getNoClip();
            if (this.field_70127_C == 0.0f && this.field_70126_B == 0.0f) {
                float f = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
                this.field_70177_z = (float)(MathHelper.func_181159_b((double)this.field_70159_w, (double)this.field_70179_y) * 57.29577951308232);
                this.field_70125_A = (float)(MathHelper.func_181159_b((double)this.field_70181_x, (double)f) * 57.29577951308232);
                this.field_70126_B = this.field_70177_z;
                this.field_70127_C = this.field_70125_A;
            }
            BlockPos pos = new BlockPos(this.field_145791_d, this.field_145792_e, this.field_145789_f);
            IBlockState state = this.field_70170_p.func_180495_p(pos);
            Block block = state.func_177230_c();
            if (state.func_185904_a() != Material.field_151579_a && !flag && (box = state.func_185890_d((IBlockAccess)this.field_70170_p, pos)) != Block.field_185506_k && box.func_186670_a(pos).func_72318_a(new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v))) {
                this.field_70254_i = true;
            }
            if (this.field_70249_b > 0) {
                --this.field_70249_b;
            }
            if (this.func_70026_G()) {
                this.func_70066_B();
            }
            if (this.field_70254_i && !flag) {
                int meta = block.func_176201_c(state);
                if (!(block == this.field_145790_g && meta == this.field_70253_h || this.field_70170_p.func_184143_b(this.func_174813_aQ().func_186662_g(0.06)))) {
                    this.field_70254_i = false;
                    this.field_70159_w *= (double)(this.field_70146_Z.nextFloat() * 0.2f);
                    this.field_70181_x *= (double)(this.field_70146_Z.nextFloat() * 0.2f);
                    this.field_70179_y *= (double)(this.field_70146_Z.nextFloat() * 0.2f);
                    this.field_70252_j = 0;
                    this.field_70257_an = 0;
                } else {
                    ++this.field_70252_j;
                    if (this.field_70252_j >= 1200) {
                        this.func_70106_y();
                    }
                }
                ++this.field_184552_b;
            } else {
                Entity entity;
                this.field_184552_b = 0;
                ++this.field_70257_an;
                Vec3d current = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                Vec3d next = new Vec3d(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
                RayTraceResult result = this.field_70170_p.func_147447_a(current, next, false, true, false);
                current = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                next = new Vec3d(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
                if (result != null) {
                    next = new Vec3d(result.field_72307_f.field_72450_a, result.field_72307_f.field_72448_b, result.field_72307_f.field_72449_c);
                }
                if ((entity = this.func_184551_a(current, next)) != null) {
                    result = new RayTraceResult(entity);
                }
                if (result != null && result.field_72308_g instanceof EntityPlayer) {
                    EntityPlayer player = (EntityPlayer)result.field_72308_g;
                    if (this.field_70250_c instanceof EntityPlayer && !((EntityPlayer)this.field_70250_c).func_96122_a(player)) {
                        result = null;
                    }
                }
                if (result != null && !flag && !ForgeEventFactory.onProjectileImpact((Entity)this, (RayTraceResult)result)) {
                    this.func_184549_a(result);
                    this.field_70160_al = true;
                }
                if (this.func_70241_g()) {
                    for (int k = 0; k < 4; ++k) {
                        this.field_70170_p.func_175688_a(EnumParticleTypes.CRIT, this.field_70165_t + this.field_70159_w * (double)k / 4.0, this.field_70163_u + this.field_70181_x * (double)k / 4.0, this.field_70161_v + this.field_70179_y * (double)k / 4.0, -this.field_70159_w, -this.field_70181_x + 0.2, -this.field_70179_y, new int[0]);
                    }
                }
                this.field_70165_t += this.field_70159_w;
                this.field_70163_u += this.field_70181_x;
                this.field_70161_v += this.field_70179_y;
                float value = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
                this.field_70177_z = flag ? (float)(MathHelper.func_181159_b((double)(-this.field_70159_w), (double)(-this.field_70179_y)) * 57.2957763671875) : (float)(MathHelper.func_181159_b((double)this.field_70159_w, (double)this.field_70179_y) * 57.2957763671875);
                while (this.field_70125_A - this.field_70127_C < -180.0f) {
                    this.field_70125_A = (float)(MathHelper.func_181159_b((double)this.field_70181_x, (double)value) * 57.29577951308232);
                    this.field_70127_C -= 360.0f;
                }
                while (this.field_70125_A - this.field_70127_C >= 180.0f) {
                    this.field_70127_C += 360.0f;
                }
                while (this.field_70177_z - this.field_70126_B < -180.0f) {
                    this.field_70126_B -= 360.0f;
                }
                while (this.field_70177_z - this.field_70126_B >= 180.0f) {
                    this.field_70126_B += 360.0f;
                }
                this.field_70125_A = this.field_70127_C + (this.field_70125_A - this.field_70127_C) * 0.2f;
                this.field_70177_z = this.field_70126_B + (this.field_70177_z - this.field_70126_B) * 0.2f;
                float drag = 0.99f;
                float gravity = 0.05f;
                if (this.func_70090_H()) {
                    for (int i = 0; i < 4; ++i) {
                        float range = 0.25f;
                        this.field_70170_p.func_175688_a(EnumParticleTypes.WATER_BUBBLE, this.field_70165_t - this.field_70159_w * (double)range, this.field_70163_u - this.field_70181_x * (double)range, this.field_70161_v - this.field_70179_y * (double)range, this.field_70159_w, this.field_70181_x, this.field_70179_y, new int[0]);
                    }
                    drag = trident.getWaterDrag();
                }
                this.field_70159_w *= (double)drag;
                this.field_70181_x *= (double)drag;
                this.field_70179_y *= (double)drag;
                if (!this.func_189652_ae()) {
                    this.field_70181_x -= (double)gravity;
                }
                this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                this.func_145775_I();
            }
            info.cancel();
        }
    }

    @Shadow
    protected abstract void func_184549_a(RayTraceResult var1);

    @Shadow
    protected abstract Entity func_184551_a(Vec3d var1, Vec3d var2);

    @Shadow
    public abstract boolean func_70241_g();
}

