/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.trident.item;

import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.trident.Trident;
import net.minecraft.trident.capabilities.CapabilityHandler;
import net.minecraft.trident.capabilities.ISpinAttackDuration;
import net.minecraft.trident.enchantment.TridentEnchantments;
import net.minecraft.trident.entity.EntityTrident;
import net.minecraft.trident.sound.TridentSounds;
import net.minecraft.trident.util.EntityHelper;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public interface ITrident {
    default public ModelResourceLocation getModel() {
        return Trident.MODEL;
    }

    default public ModelResourceLocation getHandModel() {
        return Trident.HAND_MODEL;
    }

    @SideOnly(value=Side.CLIENT)
    default public void render(ItemStack stack, ItemCameraTransforms.TransformType type) {
    }

    default public void startSpinAttack(EntityPlayer player, int time) {
        if (player.hasCapability(CapabilityHandler.capability, null)) {
            ISpinAttackDuration trident = (ISpinAttackDuration)player.getCapability(CapabilityHandler.capability, null);
            trident.setSpinAttackDuration(time);
        }
        if (!player.field_70170_p.field_72995_K) {
            EntityHelper.setLivingFlag(player, true);
        }
    }

    default public ActionResult<ItemStack> onItemRightClick(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (stack.func_77952_i() >= stack.func_77958_k() - 1) {
            return new ActionResult(EnumActionResult.FAIL, (Object)stack);
        }
        if (TridentEnchantments.getRiptideModifier(stack) > 0 && !this.isInWaterOrRain(player)) {
            return new ActionResult(EnumActionResult.FAIL, (Object)stack);
        }
        player.func_184598_c(hand);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    default public EntityTrident getTrident(World world, EntityLivingBase thrower, ItemStack stack) {
        return new EntityTrident(world, thrower, stack);
    }

    default public void onPlayerStoppedUsing(ItemStack stack, World world, EntityLivingBase living, int timeLeft) {
        if (living instanceof EntityPlayer) {
            int riptide;
            EntityPlayer player = (EntityPlayer)living;
            int time = this.getItem().func_77626_a(stack) - timeLeft;
            if (time >= 10 && ((riptide = TridentEnchantments.getRiptideModifier(stack)) <= 0 || this.isInWaterOrRain(player))) {
                if (!world.field_72995_K) {
                    stack.func_77972_a(1, (EntityLivingBase)player);
                    if (riptide == 0) {
                        EntityTrident trident = this.getTrident(world, (EntityLivingBase)player, stack);
                        trident.func_184547_a((Entity)player, player.field_70125_A, player.field_70177_z, 0.0f, 2.5f + (float)riptide * 0.5f, 1.0f);
                        if (player.func_184812_l_()) {
                            trident.field_70251_a = EntityArrow.PickupStatus.CREATIVE_ONLY;
                        }
                        world.func_72838_d((Entity)trident);
                        world.func_184133_a(null, trident.func_180425_c(), TridentSounds.ITEM_TRIDENT_THROW, SoundCategory.PLAYERS, 1.0f, 1.0f);
                        if (!player.func_184812_l_()) {
                            player.field_71071_by.func_184437_d(stack);
                        }
                    }
                }
                if (riptide > 0) {
                    float yaw = player.field_70177_z;
                    float pitch = player.field_70125_A;
                    float motionX = -MathHelper.func_76126_a((float)(yaw * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(pitch * ((float)Math.PI / 180)));
                    float motionY = -MathHelper.func_76126_a((float)(pitch * ((float)Math.PI / 180)));
                    float motionZ = MathHelper.func_76134_b((float)(yaw * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(pitch * ((float)Math.PI / 180)));
                    float magnitude = MathHelper.func_76129_c((float)(motionX * motionX + motionY * motionY + motionZ * motionZ));
                    float power = 3.0f * ((1.0f + (float)riptide) / 4.0f);
                    player.func_70024_g((double)(motionX *= power / magnitude), (double)(motionY *= power / magnitude), (double)(motionZ *= power / magnitude));
                    this.startSpinAttack(player, 20);
                    if (player.field_70122_E) {
                        float riptideSpeed = 1.1999999f;
                        player.func_70091_d(MoverType.SELF, 0.0, (double)riptideSpeed, 0.0);
                    }
                    SoundEvent sound = riptide >= 3 ? TridentSounds.ITEM_TRIDENT_RIPTIDE_3 : (riptide == 2 ? TridentSounds.ITEM_TRIDENT_RIPTIDE_2 : TridentSounds.ITEM_TRIDENT_RIPTIDE_1);
                    world.func_184133_a(null, player.func_180425_c(), sound, SoundCategory.PLAYERS, 1.0f, 1.0f);
                }
            }
        }
    }

    default public boolean isInWaterOrRain(EntityPlayer player) {
        if (player.func_70026_G()) {
            return true;
        }
        return Trident.getRiptide().test(player);
    }

    default public boolean canApplyTridentEnchantment() {
        return true;
    }

    default public Item getItem() {
        return (Item)this;
    }
}

