/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.trident.entity;

import javax.annotation.Nullable;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.trident.Trident;
import net.minecraft.trident.enchantment.TridentEnchantments;
import net.minecraft.trident.sound.TridentSounds;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityTrident
extends EntityArrow {
    private static final DataParameter<Byte> LOYALTY_LEVEL = EntityDataManager.func_187226_a(EntityTrident.class, (DataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<Boolean> EFFECT = EntityDataManager.func_187226_a(EntityTrident.class, (DataSerializer)DataSerializers.field_187198_h);
    protected ItemStack thrownStack = new ItemStack(Trident.TRIDENT);
    private boolean dealtDamage;
    public int returningTicks;

    public EntityTrident(World world) {
        super(world);
        this.func_70105_a(0.5f, 0.5f);
    }

    public EntityTrident(World world, EntityLivingBase thrower, ItemStack thrownStack) {
        super(world, thrower);
        this.thrownStack = thrownStack.func_77946_l();
        this.field_70180_af.func_187227_b(LOYALTY_LEVEL, (Object)((byte)TridentEnchantments.getLoyaltyModifier(thrownStack)));
        this.field_70180_af.func_187227_b(EFFECT, (Object)this.hasEffect());
        this.func_70105_a(0.5f, 0.5f);
    }

    @SideOnly(value=Side.CLIENT)
    public EntityTrident(World world, double x, double y, double z) {
        super(world, x, y, z);
        this.func_70105_a(0.5f, 0.5f);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(LOYALTY_LEVEL, (Object)0);
        this.field_70180_af.func_187214_a(EFFECT, (Object)false);
    }

    public void func_70071_h_() {
        if (this.field_184552_b > 4) {
            this.dealtDamage = true;
        }
        Entity entity = this.field_70250_c;
        if ((this.dealtDamage || this.getNoClip()) && entity != null) {
            byte loyalty = (Byte)this.field_70180_af.func_187225_a(LOYALTY_LEVEL);
            if (loyalty > 0 && !this.shouldReturnToThrower()) {
                if (!this.field_70170_p.field_72995_K && this.field_70251_a == EntityArrow.PickupStatus.ALLOWED) {
                    this.func_70099_a(this.func_184550_j(), 0.1f);
                }
                this.func_70106_y();
            } else if (loyalty > 0) {
                this.setNoClip(true);
                Vec3d direction = new Vec3d(entity.field_70165_t - this.field_70165_t, entity.field_70163_u + (double)entity.func_70047_e() - this.field_70163_u, entity.field_70161_v - this.field_70161_v);
                this.field_70163_u += direction.field_72448_b * 0.015 * (double)loyalty;
                if (this.field_70170_p.field_72995_K) {
                    this.field_70137_T = this.field_70163_u;
                }
                direction = direction.func_72432_b();
                double velocity = 0.05 * (double)loyalty;
                this.field_70159_w += direction.field_72450_a * velocity - this.field_70159_w * 0.05;
                this.field_70181_x += direction.field_72448_b * velocity - this.field_70181_x * 0.05;
                this.field_70179_y += direction.field_72449_c * velocity - this.field_70179_y * 0.05;
                if (this.returningTicks == 0) {
                    this.func_184185_a(TridentSounds.ITEM_TRIDENT_RETURN, 10.0f, 1.0f);
                }
                ++this.returningTicks;
            }
        }
        super.func_70071_h_();
    }

    protected ItemStack func_184550_j() {
        return this.thrownStack.func_77946_l();
    }

    @SideOnly(value=Side.CLIENT)
    public boolean effect() {
        return (Boolean)this.field_70180_af.func_187225_a(EFFECT);
    }

    @Nullable
    protected Entity func_184551_a(Vec3d start, Vec3d end) {
        return this.dealtDamage ? null : super.func_184551_a(start, end);
    }

    protected void func_184549_a(RayTraceResult result) {
        if (result.field_72308_g != null) {
            this.onHitEntity(result);
        } else {
            super.func_184549_a(result);
        }
    }

    protected void onHitEntity(RayTraceResult result) {
        BlockPos position;
        Entity shooter;
        Entity entity = result.field_72308_g;
        float damage = (float)this.func_70242_d();
        if (entity instanceof EntityLivingBase) {
            EntityLivingBase living = (EntityLivingBase)entity;
            damage += EnchantmentHelper.func_152377_a((ItemStack)this.thrownStack, (EnumCreatureAttribute)living.func_70668_bt());
            if (entity.func_70026_G()) {
                damage = (float)((double)damage + (double)TridentEnchantments.getImpalingModifier(this.func_184550_j()) * 2.5);
            }
        }
        DamageSource source = EntityTrident.causeTridentDamage((Entity)this, (Entity)((shooter = this.field_70250_c) == null ? this : shooter));
        this.dealtDamage = true;
        SoundEvent sound = TridentSounds.ITEM_TRIDENT_HIT;
        if (entity.func_70097_a(source, damage) && entity instanceof EntityLivingBase) {
            EntityLivingBase living = (EntityLivingBase)entity;
            if (shooter instanceof EntityLivingBase) {
                EnchantmentHelper.func_151384_a((EntityLivingBase)living, (Entity)shooter);
                EnchantmentHelper.func_151385_b((EntityLivingBase)((EntityLivingBase)shooter), (Entity)living);
            }
            this.func_184548_a(living);
        }
        this.field_70159_w *= (double)-0.01f;
        this.field_70181_x *= (double)-0.1f;
        this.field_70179_y *= (double)-0.01f;
        float volume = 1.0f;
        if (this.field_70170_p.func_72911_I() && TridentEnchantments.hasChanneling(this.thrownStack) && this.field_70170_p.func_175678_i(position = entity.func_180425_c())) {
            EntityLightningBolt lightningBolt = new EntityLightningBolt(this.field_70170_p, (double)position.func_177958_n(), (double)position.func_177956_o(), (double)position.func_177952_p(), false);
            this.field_70170_p.func_72942_c((Entity)lightningBolt);
            this.addLightning(lightningBolt);
            sound = TridentSounds.ITEM_TRIDENT_THUNDER;
            volume = 5.0f;
        }
        this.func_184185_a(sound, volume, 1.0f);
    }

    public void func_70100_b_(EntityPlayer player) {
        Entity entity = this.getShootingEntity();
        if (!(entity != null && entity.func_110124_au() != player.func_110124_au() || this.field_70170_p.field_72995_K || !this.field_70254_i && !this.getNoClip() || this.field_70249_b > 0)) {
            boolean flag;
            boolean bl = flag = this.field_70251_a == EntityArrow.PickupStatus.ALLOWED || this.field_70251_a == EntityArrow.PickupStatus.CREATIVE_ONLY && player.field_71075_bZ.field_75098_d || this.getNoClip();
            if (this.field_70251_a == EntityArrow.PickupStatus.ALLOWED && !player.field_71071_by.func_70441_a(this.func_184550_j())) {
                flag = false;
            }
            if (flag) {
                player.func_71001_a((Entity)this, 1);
                this.func_70106_y();
            }
        }
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        byte i = compound.func_150299_b("Trident");
        if (i != 10) {
            this.thrownStack = new ItemStack((NBTTagCompound)compound.func_74781_a("Trident"));
        }
        this.dealtDamage = compound.func_74767_n("DealtDamage");
        this.field_70180_af.func_187227_b(LOYALTY_LEVEL, (Object)((byte)TridentEnchantments.getLoyaltyModifier(this.thrownStack)));
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74782_a("Trident", (NBTBase)this.thrownStack.func_77955_b(new NBTTagCompound()));
        compound.func_74757_a("DealtDamage", this.dealtDamage);
    }

    public void func_184185_a(SoundEvent sound, float volume, float pitch) {
        if (sound == SoundEvents.field_187731_t) {
            super.func_184185_a(this.getHitEntitySound(), volume, pitch);
        } else {
            super.func_184185_a(sound, volume, pitch);
        }
    }

    protected SoundEvent getHitEntitySound() {
        return TridentSounds.ITEM_TRIDENT_HIT_GROUND;
    }

    public float getWaterDrag() {
        return 0.99f;
    }

    protected int func_190531_bD() {
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_145770_h(double x, double y, double z) {
        return true;
    }

    public void addLightning(EntityLightningBolt lightning) {
        if (this.field_70250_c instanceof EntityPlayer) {
            Trident.LIGHTNING_BOLTS.clear();
            Trident.LIGHTNING_BOLTS.put(lightning, (EntityPlayer)this.field_70250_c);
        }
    }

    public boolean hasEffect() {
        return this.thrownStack.func_77948_v();
    }

    private boolean shouldReturnToThrower() {
        Entity entity = this.getShootingEntity();
        if (entity != null && entity.func_70089_S()) {
            return !(entity instanceof EntityPlayerMP) || !((EntityPlayerMP)entity).func_175149_v();
        }
        return false;
    }

    @Nullable
    public Entity getShootingEntity() {
        return this.field_70250_c != null && this.field_70170_p instanceof WorldServer ? ((WorldServer)this.field_70170_p).func_175733_a(this.field_70250_c.func_110124_au()) : null;
    }

    public static DamageSource causeTridentDamage(Entity source, @Nullable Entity indirectEntity) {
        return new EntityDamageSourceIndirect("trident", source, indirectEntity).func_76349_b();
    }

    public void setNoClip(boolean noClip) {
        this.field_70145_X = noClip;
    }

    public boolean getNoClip() {
        return this.field_70145_X;
    }

    public double func_70242_d() {
        return 8.0;
    }
}

