/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.trident.enchantment;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.trident.enchantment.EnchantmentChanneling;
import net.minecraft.trident.enchantment.EnchantmentImpaling;
import net.minecraft.trident.enchantment.EnchantmentLoyalty;
import net.minecraft.trident.enchantment.EnchantmentRiptide;
import net.minecraft.trident.item.ITrident;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="trident")
public class TridentEnchantments {
    public static final EnumEnchantmentType TRIDENT = EnumHelper.addEnchantmentType((String)"TRIDENT", item -> item instanceof ITrident && ((ITrident)item).canApplyTridentEnchantment());
    public static final List<Enchantment> ENCHANTMENTS = Lists.newArrayList();
    public static final Enchantment LOYALTY = TridentEnchantments.register("loyalty", new EnchantmentLoyalty(Enchantment.Rarity.UNCOMMON, EntityEquipmentSlot.MAINHAND));
    public static final Enchantment IMPALING = TridentEnchantments.register("impaling", new EnchantmentImpaling(Enchantment.Rarity.RARE, EntityEquipmentSlot.MAINHAND));
    public static final Enchantment RIPTIDE = TridentEnchantments.register("riptide", new EnchantmentRiptide(Enchantment.Rarity.RARE, EntityEquipmentSlot.MAINHAND));
    public static final Enchantment CHANNELING = TridentEnchantments.register("channeling", new EnchantmentChanneling(Enchantment.Rarity.VERY_RARE, EntityEquipmentSlot.MAINHAND));

    @SubscribeEvent
    public static void onRegisterEnchantment(RegistryEvent.Register<Enchantment> event) {
        ENCHANTMENTS.forEach(e -> event.getRegistry().register((IForgeRegistryEntry)e));
    }

    public static Enchantment register(String key, Enchantment enchantment) {
        enchantment.func_77322_b("minecraft." + key);
        enchantment.setRegistryName("trident", key);
        ENCHANTMENTS.add(enchantment);
        return enchantment;
    }

    public static int getLoyaltyModifier(ItemStack stack) {
        return EnchantmentHelper.func_77506_a((Enchantment)LOYALTY, (ItemStack)stack);
    }

    public static int getImpalingModifier(EntityLivingBase player) {
        return EnchantmentHelper.func_185284_a((Enchantment)IMPALING, (EntityLivingBase)player);
    }

    public static int getImpalingModifier(ItemStack stack) {
        return EnchantmentHelper.func_77506_a((Enchantment)IMPALING, (ItemStack)stack);
    }

    public static int getRiptideModifier(ItemStack stack) {
        int level = EnchantmentHelper.func_77506_a((Enchantment)RIPTIDE, (ItemStack)stack);
        if (level == 0 && Loader.isModLoaded((String)"oe")) {
            Enchantment riptide = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(new ResourceLocation("oe", "riptide"));
            level = EnchantmentHelper.func_77506_a((Enchantment)riptide, (ItemStack)stack);
        }
        return level;
    }

    public static boolean hasChanneling(ItemStack stack) {
        return EnchantmentHelper.func_77506_a((Enchantment)CHANNELING, (ItemStack)stack) > 0;
    }
}

