/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.trident.crafting;

import javax.annotation.Nonnull;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.trident.Trident;
import net.minecraft.trident.config.TridentConfig;
import net.minecraft.trident.crafting.RecipeTridentItem;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.registries.GameData;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class TridentRecipes {
    public static void init() {
        String name = "trident";
        ItemStack trident = new ItemStack(Trident.TRIDENT);
        if (TridentConfig.TRIDENT_RECIPE) {
            TridentRecipes.addShapedOreRecipe(new ResourceLocation("trident", "trident"), trident, " QQ", " PQ", "P  ", Character.valueOf('Q'), "gemQuartz", Character.valueOf('P'), Items.field_179562_cC);
        }
        if (OreDictionary.getOres((String)"trident").size() > 1) {
            TridentRecipes.register(new RecipeTridentItem().setRegistryName(new ResourceLocation("trident", "convert")));
        }
    }

    private static <K extends IForgeRegistryEntry<K>> K register(K object) {
        return (K)GameData.register_impl(object);
    }

    public static void addShapedOreRecipe(ResourceLocation name, ResourceLocation group, @Nonnull ItemStack result, Object ... params) {
        TridentRecipes.register(new ShapedOreRecipe(group, result, params).setRegistryName(name));
    }

    public static void addShapedOreRecipe(ResourceLocation name, @Nonnull ItemStack result, Object ... params) {
        TridentRecipes.addShapedOreRecipe(name, null, result, params);
    }
}

