/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.trident.crafting;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.trident.Trident;
import net.minecraft.trident.enchantment.TridentEnchantments;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class RecipeTridentItem
extends IForgeRegistryEntry.Impl<IRecipe>
implements IRecipe {
    public boolean func_77569_a(InventoryCrafting inventory, World world) {
        List items = OreDictionary.getOres((String)"trident").stream().map(ItemStack::func_77973_b).collect(Collectors.toList());
        ArrayList crafting = Lists.newArrayList();
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack stack = inventory.func_70301_a(i);
            if (stack.func_190926_b()) continue;
            crafting.add(stack.func_77973_b());
        }
        return crafting.size() == 1 && crafting.stream().allMatch(item -> items.contains(item));
    }

    public ItemStack func_77572_b(InventoryCrafting inventory) {
        ItemStack trident = new ItemStack(Trident.TRIDENT);
        int index = -1;
        List items = OreDictionary.getOres((String)"trident").stream().map(ItemStack::func_77973_b).collect(Collectors.toList());
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack stack = inventory.func_70301_a(i);
            if (!items.contains(stack.func_77973_b())) continue;
            index = i;
            break;
        }
        if (index != -1) {
            ItemStack crafting = inventory.func_70301_a(index).func_77946_l();
            if (crafting.func_77952_i() != crafting.func_77958_k()) {
                int damage = crafting.func_77952_i();
                trident.func_77964_b(damage);
            }
            if (crafting.func_77942_o()) {
                NBTTagCompound tag = crafting.func_77978_p();
                Map<Enchantment, Integer> enchantments = this.getEnchantments(crafting);
                trident.func_77982_d(tag);
                EnchantmentHelper.func_82782_a(enchantments, (ItemStack)trident);
            }
        }
        return trident;
    }

    public boolean func_194133_a(int width, int height) {
        return true;
    }

    public ItemStack func_77571_b() {
        return ItemStack.field_190927_a;
    }

    public boolean func_192399_d() {
        return true;
    }

    private Map<Enchantment, Integer> getEnchantments(ItemStack stack) {
        Map enchantments = EnchantmentHelper.func_82781_a((ItemStack)stack);
        Map maps = EnchantmentHelper.func_82781_a((ItemStack)stack);
        if (Loader.isModLoaded((String)"futuremc")) {
            Enchantment loyalty = RecipeTridentItem.getEnchantment("loyalty");
            Enchantment impaling = RecipeTridentItem.getEnchantment("impaling");
            Enchantment riptide = RecipeTridentItem.getEnchantment("riptide");
            Enchantment channeling = RecipeTridentItem.getEnchantment("channeling");
            for (Enchantment enchantment : enchantments.keySet()) {
                int level = (Integer)enchantments.get(enchantment);
                boolean flag = false;
                if (enchantment == loyalty) {
                    maps.put(TridentEnchantments.LOYALTY, level);
                    flag = true;
                } else if (enchantment == impaling) {
                    maps.put(TridentEnchantments.IMPALING, level);
                    flag = true;
                } else if (enchantment == riptide) {
                    maps.put(TridentEnchantments.RIPTIDE, level);
                    flag = true;
                } else if (enchantment == channeling) {
                    maps.put(TridentEnchantments.CHANNELING, level);
                    flag = true;
                }
                if (!flag) continue;
                maps.remove(enchantment);
            }
        }
        return maps;
    }

    private static Enchantment getEnchantment(String name) {
        return (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(new ResourceLocation("futuremc", name));
    }
}

