/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.trident.compat.oe;

import com.sirsquidly.oe.entity.EntityDrowned;
import com.sirsquidly.oe.entity.EntityPickled;
import com.sirsquidly.oe.entity.EntityTrident;
import com.sirsquidly.oe.init.OEItems;
import java.util.List;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.client.renderer.entity.layers.LayerHeldItem;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.entity.EntityLiving;
import net.minecraft.item.Item;
import net.minecraft.trident.compat.oe.ItemOeTrident;
import net.minecraft.trident.compat.oe.RenderOeDrowned;
import net.minecraft.trident.compat.oe.RenderOePickled;
import net.minecraft.trident.compat.oe.RenderOeTrident;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Mod.EventBusSubscriber(modid="trident")
public class OceanicExpanse {
    public static final String MODID = "oe";
    public static final ResourceLocation GUI = new ResourceLocation("oe", "oe_trident");
    public static final ResourceLocation HAND = new ResourceLocation("oe", "oe_trident_in_hand");
    public static final ModelResourceLocation MODEL = new ModelResourceLocation(GUI, "inventory");
    public static final ModelResourceLocation HAND_MODEL = new ModelResourceLocation(HAND, "inventory");

    @Optional.Method(modid="oe")
    public static void init() {
        OEItems.TRIDENT_ORIG = new ItemOeTrident();
    }

    @Optional.Method(modid="oe")
    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public static void onModelRegistry(ModelRegistryEvent event) {
        Item trident = OEItems.TRIDENT_ORIG;
        ModelLoader.registerItemVariants((Item)trident, (ResourceLocation[])new ResourceLocation[]{trident.getRegistryName(), GUI});
        ModelLoader.registerItemVariants((Item)trident, (ResourceLocation[])new ResourceLocation[]{trident.getRegistryName(), HAND});
        RenderingRegistry.registerEntityRenderingHandler(EntityTrident.class, RenderOeTrident::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityDrowned.class, RenderOeDrowned::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityPickled.class, RenderOePickled::new);
    }

    @SideOnly(value=Side.CLIENT)
    public static <E extends EntityLiving> void addVanillaLayerHeldItem(RenderLiving<?> render, List<LayerRenderer<E>> layers) {
        for (LayerRenderer<E> layer : layers) {
            if (!(layer instanceof LayerHeldItem)) continue;
            layers.remove(layer);
            break;
        }
        render.func_177094_a((LayerRenderer)new LayerHeldItem(render));
    }
}

