/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.trident.compat.oe;

import com.sirsquidly.oe.entity.EntityTrident;
import com.sirsquidly.oe.items.ItemTrident;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemStack;
import net.minecraft.trident.Trident;
import net.minecraft.trident.compat.oe.OceanicExpanse;
import net.minecraft.trident.compat.oe.RenderItemOeTrident;
import net.minecraft.trident.enchantment.TridentEnchantments;
import net.minecraft.trident.item.ITrident;
import net.minecraft.trident.sound.TridentSounds;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemOeTrident
extends ItemTrident
implements ITrident {
    public ItemOeTrident() {
        this.func_185043_a(new ResourceLocation("throwing"), (stack, world, entity) -> entity != null && entity.func_184587_cr() && entity.func_184607_cu() == stack ? 2.0f : 0.0f);
    }

    public boolean canDestroyBlockInCreative(World world, BlockPos pos, ItemStack stack, EntityPlayer player) {
        return !player.func_184812_l_();
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return Trident.SPEAR;
    }

    public void func_77615_a(ItemStack stack, World world, EntityLivingBase living, int timeLeft) {
        if (living instanceof EntityPlayer) {
            int riptide;
            EntityPlayer player = (EntityPlayer)living;
            int time = this.getItem().func_77626_a(stack) - timeLeft;
            if (time >= 10 && ((riptide = TridentEnchantments.getRiptideModifier(stack)) <= 0 || this.isInWaterOrRain(player))) {
                if (!world.field_72995_K) {
                    stack.func_77972_a(1, (EntityLivingBase)player);
                    if (riptide == 0) {
                        EntityTrident trident = new EntityTrident(world, (EntityLivingBase)player);
                        trident.setItem(stack);
                        trident.func_70243_d(true);
                        trident.func_184547_a((Entity)player, player.field_70125_A, player.field_70177_z, 0.0f, 2.5f + (float)riptide * 0.5f, 1.0f);
                        if (player.func_184812_l_()) {
                            trident.field_70251_a = EntityArrow.PickupStatus.CREATIVE_ONLY;
                        }
                        world.func_72838_d((Entity)trident);
                        world.func_184133_a(null, trident.func_180425_c(), TridentSounds.ITEM_TRIDENT_THROW, SoundCategory.PLAYERS, 1.0f, 1.0f);
                        if (!player.func_184812_l_()) {
                            player.field_71071_by.func_184437_d(stack);
                        }
                    }
                }
                if (riptide > 0) {
                    float yaw = player.field_70177_z;
                    float pitch = player.field_70125_A;
                    float motionX = -MathHelper.func_76126_a((float)(yaw * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(pitch * ((float)Math.PI / 180)));
                    float motionY = -MathHelper.func_76126_a((float)(pitch * ((float)Math.PI / 180)));
                    float motionZ = MathHelper.func_76134_b((float)(yaw * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(pitch * ((float)Math.PI / 180)));
                    float magnitude = MathHelper.func_76129_c((float)(motionX * motionX + motionY * motionY + motionZ * motionZ));
                    float power = 3.0f * ((1.0f + (float)riptide) / 4.0f);
                    player.func_70024_g((double)(motionX *= power / magnitude), (double)(motionY *= power / magnitude), (double)(motionZ *= power / magnitude));
                    this.startSpinAttack(player, 20);
                    if (player.field_70122_E) {
                        float riptideSpeed = 1.1999999f;
                        player.func_70091_d(MoverType.SELF, 0.0, (double)riptideSpeed, 0.0);
                    }
                    SoundEvent sound = riptide >= 3 ? TridentSounds.ITEM_TRIDENT_RIPTIDE_3 : (riptide == 2 ? TridentSounds.ITEM_TRIDENT_RIPTIDE_2 : TridentSounds.ITEM_TRIDENT_RIPTIDE_1);
                    world.func_184133_a(null, player.func_180425_c(), sound, SoundCategory.PLAYERS, 1.0f, 1.0f);
                }
            }
        }
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        return ITrident.super.onItemRightClick(world, player, hand);
    }

    @Override
    public boolean canApplyTridentEnchantment() {
        return false;
    }

    @Override
    public ModelResourceLocation getModel() {
        return OceanicExpanse.MODEL;
    }

    @Override
    public ModelResourceLocation getHandModel() {
        return OceanicExpanse.HAND_MODEL;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void render(ItemStack stack, ItemCameraTransforms.TransformType type) {
        RenderItemOeTrident.render(stack, type);
    }
}

