/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.trident.capabilities;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.trident.capabilities.CapabilityHandler;
import net.minecraft.trident.capabilities.ISpinAttackDuration;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;

public class CapabilityTrident {

    public static class ProvidePlayer
    implements ICapabilitySerializable<NBTTagCompound>,
    ICapabilityProvider {
        private ISpinAttackDuration trident = new Implementation();
        private Capability.IStorage<ISpinAttackDuration> storage = CapabilityHandler.capability.getStorage();

        public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
            return CapabilityHandler.capability.equals(capability);
        }

        @Nullable
        public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
            if (CapabilityHandler.capability.equals(capability)) {
                return (T)this.trident;
            }
            return null;
        }

        public NBTTagCompound serializeNBT() {
            return (NBTTagCompound)this.storage.writeNBT(CapabilityHandler.capability, (Object)this.trident, null);
        }

        public void deserializeNBT(NBTTagCompound nbt) {
            this.storage.readNBT(CapabilityHandler.capability, (Object)this.trident, null, (NBTBase)nbt);
        }
    }

    public static class Implementation
    implements ISpinAttackDuration {
        Integer spinAttackDuration = 0;
        Boolean spinAttack = false;

        @Override
        public int getSpinAttackDuration() {
            return this.spinAttackDuration;
        }

        @Override
        public void setSpinAttackDuration(int time) {
            this.spinAttackDuration = time;
        }

        @Override
        public boolean getSpinAttack() {
            return this.spinAttack;
        }

        @Override
        public void setSpinAttack(boolean spinAttack) {
            this.spinAttack = spinAttack;
        }
    }

    public static class Storage
    implements Capability.IStorage<ISpinAttackDuration> {
        @Nullable
        public NBTBase writeNBT(Capability<ISpinAttackDuration> capability, ISpinAttackDuration instance, EnumFacing side) {
            NBTTagCompound compound = new NBTTagCompound();
            compound.func_74768_a("duration", instance.getSpinAttackDuration());
            compound.func_74757_a("spin_attack", instance.getSpinAttack());
            return compound;
        }

        public void readNBT(Capability<ISpinAttackDuration> capability, ISpinAttackDuration instance, EnumFacing side, NBTBase nbt) {
            NBTTagCompound compound = (NBTTagCompound)nbt;
            instance.setSpinAttackDuration(compound.func_74762_e("duration"));
            instance.setSpinAttack(compound.func_74767_n("spin_attack"));
        }
    }
}

