/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.trident;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.advancements.ICriterionTrigger;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.trident.advancements.LightningTrigger;
import net.minecraft.trident.capabilities.CapabilityHandler;
import net.minecraft.trident.capabilities.CapabilityTrident;
import net.minecraft.trident.capabilities.ISpinAttackDuration;
import net.minecraft.trident.common.CommonProxy;
import net.minecraft.trident.config.TridentConfig;
import net.minecraft.trident.enchantment.TridentEnchantments;
import net.minecraft.trident.entity.EntityTrident;
import net.minecraft.trident.item.ITrident;
import net.minecraft.trident.item.ItemTrident;
import net.minecraft.trident.network.PacketSpinAttack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.EntityEntryBuilder;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="trident", name="Trident Mod", version="1.0.5", guiFactory="net.minecraft.trident.config.TridentConfigFactory", dependencies="before:modularwarfare;after:oe", acceptedMinecraftVersions="[1.12.2]")
public class Trident {
    public static final String MODID = "trident";
    public static final String NAME = "Trident Mod";
    public static final String VERSION = "1.0.5";
    public static final Logger LOGGER = LogManager.getLogger((String)"trident");
    public static final SimpleNetworkWrapper NETWORK = NetworkRegistry.INSTANCE.newSimpleChannel("trident");
    @SidedProxy(clientSide="net.minecraft.trident.client.ClientProxy", serverSide="net.minecraft.trident.common.CommonProxy")
    public static CommonProxy proxy;
    public static final Item TRIDENT;
    public static final ResourceLocation GUI;
    public static final ResourceLocation HAND;
    public static final ModelResourceLocation MODEL;
    public static final ModelResourceLocation HAND_MODEL;
    public static final EnumAction SPEAR;
    public static final LightningTrigger LIGHTNING_TRIGGER;
    public static final Map<EntityLightningBolt, EntityPlayer> LIGHTNING_BOLTS;
    public static Predicate<EntityPlayer> riptide;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register(Trident.class);
        MinecraftForge.EVENT_BUS.register((Object)this);
        CapabilityHandler.setupCapabilities();
        NETWORK.registerMessage(PacketSpinAttack.Handler.class, PacketSpinAttack.class, 0, Side.CLIENT);
        proxy.preInit(event);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        CreativeTabs combat = CreativeTabs.field_78037_j;
        ArrayList types = Lists.newArrayList((Object[])combat.func_111225_m());
        types.add(TridentEnchantments.TRIDENT);
        combat.func_111229_a(types.toArray(new EnumEnchantmentType[0]));
        proxy.init(event);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        proxy.postInit(event);
    }

    @SubscribeEvent
    public static void onRegisterItems(RegistryEvent.Register<Item> event) {
        event.getRegistry().register((IForgeRegistryEntry)TRIDENT);
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public static void onModelRegistry(ModelRegistryEvent event) {
        Item trident = TRIDENT;
        ModelLoader.registerItemVariants((Item)trident, (ResourceLocation[])new ResourceLocation[]{trident.getRegistryName(), HAND});
        ModelResourceLocation model = new ModelResourceLocation(trident.getRegistryName(), "inventory");
        ModelLoader.setCustomModelResourceLocation((Item)trident, (int)0, (ModelResourceLocation)model);
    }

    @SubscribeEvent
    public static void onRegisterEntities(RegistryEvent.Register<EntityEntry> event) {
        event.getRegistry().register((IForgeRegistryEntry)EntityEntryBuilder.create().entity(EntityTrident.class).id(new ResourceLocation(MODID, MODID), 0).name("minecraft.trident").tracker(32, 1, true).build());
    }

    @SubscribeEvent
    public void onAttachCapabilitiesEntity(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof EntityPlayer) {
            CapabilityTrident.ProvidePlayer provider = new CapabilityTrident.ProvidePlayer();
            event.addCapability(new ResourceLocation(MODID, MODID), (ICapabilityProvider)provider);
        }
    }

    @SubscribeEvent
    public void onPlayerClone(PlayerEvent.Clone event) {
        Capability<ISpinAttackDuration> capability = CapabilityHandler.capability;
        Capability.IStorage storage = capability.getStorage();
        if (event.getOriginal().hasCapability(capability, null) && event.getEntityPlayer().hasCapability(capability, null)) {
            NBTBase nbt = storage.writeNBT(capability, event.getOriginal().getCapability(capability, null), null);
            storage.readNBT(capability, event.getEntityPlayer().getCapability(capability, null), null, nbt);
        }
    }

    @SubscribeEvent
    public void onTridentDamage(LivingHurtEvent event) {
        int level;
        EntityLivingBase entity = event.getEntityLiving();
        if (!(event.getSource().func_76364_f() instanceof EntityLivingBase)) {
            return;
        }
        EntityLivingBase attacker = (EntityLivingBase)event.getSource().func_76364_f();
        if (entity == null || attacker == null || !entity.func_70026_G()) {
            return;
        }
        ItemStack stack = attacker.func_184614_ca();
        if (stack != null && !stack.func_190926_b() && stack.func_77973_b() instanceof ITrident && (level = TridentEnchantments.getImpalingModifier(attacker)) > 0) {
            event.setAmount(event.getAmount() + (float)level * 2.5f);
        }
    }

    @SubscribeEvent
    public void onZombieDrop(LivingDropsEvent event) {
        EntityLivingBase entity = event.getEntityLiving();
        if (TridentConfig.ZOMBIE_DROP && !entity.field_70170_p.field_72995_K && entity.func_70026_G() && entity instanceof EntityZombie) {
            Random random = entity.func_70681_au();
            ItemStack stack = null;
            if (entity.func_184614_ca().func_77973_b() == TRIDENT) {
                stack = entity.func_184614_ca().func_77946_l();
            } else if (entity.func_184614_ca().func_190926_b() && random.nextInt(101) <= TridentConfig.TRIDENT_DROP) {
                stack = new ItemStack(TRIDENT);
            }
            if (stack != null) {
                stack.func_77964_b(random.nextInt(stack.func_77958_k() + 1));
                event.getDrops().add(entity.func_70099_a(stack, 0.0f));
            }
        }
    }

    @SubscribeEvent
    public void onZombieSpawn(LivingSpawnEvent event) {
        int i;
        Random random;
        boolean flag;
        World world = event.getWorld();
        EntityLivingBase entity = event.getEntityLiving();
        if ((TridentConfig.TRIDENT_ZOMBIE && !entity.field_70170_p.field_72995_K && world.func_72911_I() || world.func_72896_J() && entity.func_70026_G()) && entity instanceof EntityZombie && (flag = Objects.equals(EntityList.func_191301_a((Entity)entity), new ResourceLocation("zombie"))) && entity.func_184614_ca().func_190926_b() && (double)(random = entity.func_70681_au()).nextFloat() < 0.005 && (i = random.nextInt(16)) < 10) {
            entity.func_184611_a(EnumHand.MAIN_HAND, new ItemStack(TRIDENT));
        }
    }

    public static Predicate<EntityPlayer> getRiptide() {
        return riptide;
    }

    static {
        GUI = new ResourceLocation(MODID, MODID);
        HAND = new ResourceLocation(MODID, "trident_in_hand");
        MODEL = new ModelResourceLocation(GUI, "inventory");
        HAND_MODEL = new ModelResourceLocation(HAND, "inventory");
        SPEAR = EnumHelper.addAction((String)"SPEAR");
        LIGHTNING_TRIGGER = (LightningTrigger)CriteriaTriggers.func_192118_a((ICriterionTrigger)new LightningTrigger());
        LIGHTNING_BOLTS = Maps.newHashMap();
        riptide = player -> false;
        TRIDENT = ((Item)new ItemTrident().setRegistryName(MODID, MODID)).func_77655_b("minecraft.trident");
    }
}

