/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.simplelogic.gates.render;

import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.resources.IResource;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.fml.common.ProgressManager;
import pl.asie.charset.lib.utils.RenderUtils;

public class GateRenderDefinitions {
    public static final GateRenderDefinitions INSTANCE = new GateRenderDefinitions();
    private static final Gson GSON = new GsonBuilder().create();
    public BaseDefinition base;
    private final Map<ResourceLocation, Definition> definitionMap = new HashMap<ResourceLocation, Definition>();

    public Definition getGateDefinition(ResourceLocation type) {
        return this.definitionMap.get(type);
    }

    public void load(String baseLoc, Map<ResourceLocation, ResourceLocation> definitions) {
        Throwable throwable;
        Throwable throwable2;
        ProgressManager.ProgressBar bar = ProgressManager.push((String)"SimpleLogic gate models", (int)(definitions.size() + 1));
        bar.step("base");
        try (IResource resource = Minecraft.func_71410_x().func_110442_L().func_110536_a(new ResourceLocation(baseLoc));){
            throwable2 = null;
            try (InputStream stream = resource.func_110527_b();){
                throwable = null;
                try (InputStreamReader reader = new InputStreamReader(stream);){
                    this.base = (BaseDefinition)GSON.fromJson((Reader)reader, BaseDefinition.class);
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
            }
            catch (Throwable reader) {
                throwable2 = reader;
                throw reader;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.definitionMap.clear();
        if (this.base != null) {
            this.base.init();
        }
        for (ResourceLocation s : definitions.keySet()) {
            bar.step(s.toString());
            if (this.base == null) continue;
            try {
                IResource resource = Minecraft.func_71410_x().func_110442_L().func_110536_a(definitions.get(s));
                throwable2 = null;
                try {
                    InputStream stream = resource.func_110527_b();
                    throwable = null;
                    try {
                        InputStreamReader reader = new InputStreamReader(stream);
                        Throwable throwable4 = null;
                        try {
                            Definition def = (Definition)GSON.fromJson((Reader)reader, Definition.class);
                            def.init();
                            def.merge(this.base);
                            def.postInit();
                            this.definitionMap.put(s, def);
                        }
                        catch (Throwable throwable5) {
                            throwable4 = throwable5;
                            throw throwable5;
                        }
                        finally {
                            if (reader == null) continue;
                            if (throwable4 != null) {
                                try {
                                    reader.close();
                                }
                                catch (Throwable throwable6) {
                                    throwable4.addSuppressed(throwable6);
                                }
                                continue;
                            }
                            reader.close();
                        }
                    }
                    catch (Throwable throwable7) {
                        throwable = throwable7;
                        throw throwable7;
                    }
                    finally {
                        if (stream == null) continue;
                        if (throwable != null) {
                            try {
                                stream.close();
                            }
                            catch (Throwable throwable8) {
                                throwable.addSuppressed(throwable8);
                            }
                            continue;
                        }
                        stream.close();
                    }
                }
                catch (Throwable throwable9) {
                    throwable2 = throwable9;
                    throw throwable9;
                }
                finally {
                    if (resource == null) continue;
                    if (throwable2 != null) {
                        try {
                            resource.close();
                        }
                        catch (Throwable throwable10) {
                            throwable2.addSuppressed(throwable10);
                        }
                        continue;
                    }
                    resource.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        ProgressManager.pop((ProgressManager.ProgressBar)bar);
    }

    public class Torch {
        public final float[] pos = new float[2];
        public String color_on;
        public String color_off;
        public String model_on;
        public String model_off;
        public String model_disabled;
        public String inverter;
    }

    public class Layer {
        public String type;
        public String texture;
        public String textureBase;
        public String color_mask;
        public Map<String, String> textures;
        public int height = 0;
    }

    public class Definition {
        public List<Layer> layers = new ArrayList<Layer>();
        public List<Torch> torches = new ArrayList<Torch>();
        private Map<String, String> models;
        private Map<String, IModel> modelObjs;
        private Map<String, String> textures;

        public void init() {
            this.modelObjs = new HashMap<String, IModel>();
            if (this.models == null) {
                this.models = new HashMap<String, String>();
            }
            if (this.textures == null) {
                this.textures = new HashMap<String, String>();
            }
        }

        public void postInit() {
            for (Layer layer : this.layers) {
                if (layer.texture == null && layer.color_mask != null) {
                    layer.texture = this.textures.get("top");
                }
                layer.textureBase = layer.texture;
            }
        }

        public IModel getModel(String name) {
            if (this.modelObjs.containsKey(name)) {
                return this.modelObjs.get(name);
            }
            IModel model = RenderUtils.getModel((ResourceLocation)new ResourceLocation(this.models.get(name)));
            if (model != null) {
                model = model.retexture(ImmutableMap.copyOf(this.textures));
                this.modelObjs.put(name, model);
            }
            return model;
        }

        public List<IModel> getAllModels() {
            ArrayList<IModel> modelList = new ArrayList<IModel>();
            for (String s : this.models.keySet()) {
                IModel model = this.getModel(s);
                if (model == null) continue;
                modelList.add(model);
            }
            return modelList;
        }

        public void merge(BaseDefinition baseDef) {
            for (String s : baseDef.models.keySet()) {
                if (this.models.containsKey(s)) continue;
                this.models.put(s, (String)baseDef.models.get(s));
            }
            for (String s : baseDef.textures.keySet()) {
                if (this.textures.containsKey(s)) continue;
                this.textures.put(s, (String)baseDef.textures.get(s));
            }
        }
    }

    public class BaseDefinition {
        public Map<String, Integer> colorMul;
        private Map<String, String> colors = new HashMap<String, String>();
        private Map<String, String> models;
        private Map<String, String> textures;

        public void init() {
            if (this.models == null) {
                this.models = new HashMap<String, String>();
            }
            if (this.textures == null) {
                this.textures = new HashMap<String, String>();
            }
            this.colorMul = new HashMap<String, Integer>();
            for (String s : this.colors.keySet()) {
                int c = Integer.parseInt(this.colors.get(s), 16);
                this.colorMul.put(s, 0xFF000000 | c & 0xFF00 | (c & 0xFF0000) >> 16 | (c & 0xFF) << 16);
            }
        }

        public ResourceLocation getTexture(String name) {
            return this.textures.containsKey(name) ? new ResourceLocation(this.textures.get(name)) : TextureMap.field_174945_f;
        }
    }
}

