/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.simplelogic.gates.logic;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import pl.asie.charset.lib.notify.Notice;
import pl.asie.charset.lib.notify.component.NotificationComponent;
import pl.asie.charset.lib.notify.component.NotificationComponentString;
import pl.asie.simplelogic.gates.SimpleLogicGates;
import pl.asie.simplelogic.gates.logic.GateConnection;
import pl.asie.simplelogic.gates.logic.GateLogic;
import pl.asie.simplelogic.gates.logic.GateRenderState;
import pl.asie.simplelogic.gates.logic.IArrowGateLogic;
import pl.asie.simplelogic.gates.logic.IGateContainer;
import pl.asie.simplelogic.gates.logic.IGateTickable;

public class GateLogicTimer
extends GateLogic
implements IArrowGateLogic,
IGateTickable {
    private int ticksTotal = 20;
    private int ticks;

    @Override
    public GateConnection getType(EnumFacing side) {
        switch (side) {
            case EAST: 
            case WEST: {
                return GateConnection.OUTPUT;
            }
            case SOUTH: {
                return GateConnection.INPUT;
            }
        }
        return GateConnection.OUTPUT;
    }

    @Override
    public boolean onRightClick(IGateContainer gate, EntityPlayer playerIn, Vec3d vec, EnumHand hand) {
        if (playerIn.func_70093_af()) {
            gate.openGUI(playerIn);
            return true;
        }
        String sec = this.ticksTotal % 20 != 0 ? ((this.ticksTotal & 1) != 0 ? String.format("%d.%02d", this.ticksTotal / 20 % 60, this.ticksTotal % 20 * 5) : String.format("%d.%d", this.ticksTotal / 20 % 60, this.ticksTotal % 20 / 2)) : String.format("%d", this.ticksTotal / 20 % 60);
        if (this.ticksTotal >= 1200) {
            String min = String.format("%d", this.ticksTotal / 1200 % 60);
            if (this.ticksTotal % 1200 == 0) {
                new Notice((Object)gate, (NotificationComponent)NotificationComponentString.translated((String)"notice.simplelogic.gate.timer.minutes", (NotificationComponent[])new NotificationComponent[]{NotificationComponentString.raw((String)min, (NotificationComponent[])new NotificationComponent[0])})).sendTo(playerIn);
            } else {
                new Notice((Object)gate, (NotificationComponent)NotificationComponentString.translated((String)"notice.simplelogic.gate.timer.minutes_seconds", (NotificationComponent[])new NotificationComponent[]{NotificationComponentString.raw((String)min, (NotificationComponent[])new NotificationComponent[0]), NotificationComponentString.raw((String)sec, (NotificationComponent[])new NotificationComponent[0])})).sendTo(playerIn);
            }
        } else {
            new Notice((Object)gate, (NotificationComponent)NotificationComponentString.translated((String)"notice.simplelogic.gate.timer.seconds", (NotificationComponent[])new NotificationComponent[]{NotificationComponentString.raw((String)sec, (NotificationComponent[])new NotificationComponent[0])})).sendTo(playerIn);
        }
        return true;
    }

    public int clampTicksTotal(int tt) {
        return MathHelper.func_76125_a((int)tt, (int)SimpleLogicGates.minTimerTickTime, (int)24000);
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound tag, boolean isClient) {
        super.writeToNBT(tag, isClient);
        tag.func_74768_a("rt", this.ticks);
        tag.func_74768_a("rtt", this.ticksTotal);
        return tag;
    }

    @Override
    public boolean readFromNBT(NBTTagCompound tag, boolean isClient) {
        int tDiff;
        boolean oldRead = super.readFromNBT(tag, isClient);
        int oldT = this.ticks;
        int oldTT = this.ticksTotal;
        this.ticks = tag.func_74762_e("rt");
        if (isClient && !this.isLocked() && ((tDiff = Math.abs(this.ticks - oldT)) == 1 || tDiff == this.ticksTotal - 1)) {
            this.ticks = oldT;
        }
        this.ticksTotal = !tag.func_74764_b("rtt") ? this.clampTicksTotal(20) : this.clampTicksTotal(tag.func_74762_e("rtt"));
        if (this.ticks >= this.ticksTotal || this.ticks < 0) {
            this.ticks = 0;
        }
        return oldRead || oldT != this.ticks || oldTT != this.ticksTotal;
    }

    private boolean isLocked() {
        return this.getInputValueInside(EnumFacing.SOUTH) != 0;
    }

    private boolean isPowered() {
        return this.ticks < 2;
    }

    @Override
    public boolean canInvertSide(EnumFacing side) {
        return true;
    }

    @Override
    public boolean canBlockSide(EnumFacing side) {
        return true;
    }

    @Override
    public GateRenderState getLayerState(int id) {
        switch (id) {
            case 0: {
                return GateRenderState.inputOrDisabled(this, EnumFacing.SOUTH, this.getInputValueInside(EnumFacing.SOUTH));
            }
            case 1: {
                return !this.isSideOpen(EnumFacing.WEST) ? GateRenderState.DISABLED : GateRenderState.bool(this.isPowered() && !this.isLocked());
            }
            case 2: {
                return !this.isSideOpen(EnumFacing.NORTH) ? GateRenderState.DISABLED : GateRenderState.bool(this.isPowered() && !this.isLocked());
            }
            case 3: {
                return !this.isSideOpen(EnumFacing.EAST) ? GateRenderState.DISABLED : GateRenderState.bool(this.isPowered() && !this.isLocked());
            }
        }
        return GateRenderState.bool(this.isPowered());
    }

    @Override
    public GateRenderState getTorchState(int id) {
        switch (id) {
            default: {
                return GateRenderState.bool(this.isPowered() && !this.isLocked());
            }
            case 1: 
        }
        return GateRenderState.ON;
    }

    @Override
    protected byte calculateOutputInside(EnumFacing side) {
        return (byte)(this.isPowered() && !this.isLocked() ? 15 : 0);
    }

    @Override
    public float getArrowPosition() {
        return this.isLocked() ? 0.0f : ((float)this.ticks - 1.0f) / (float)this.ticksTotal;
    }

    @Override
    public float getArrowRotationDelta() {
        if (this.isLocked()) {
            return 0.0f;
        }
        return 1.0f / (float)this.ticksTotal;
    }

    @Override
    public void update(IGateContainer gate) {
        int oldTicks = this.ticks;
        this.ticks = this.isLocked() ? 0 : (this.ticks + 1) % this.ticksTotal;
        if (oldTicks != this.ticks && this.ticks < 3) {
            if (!gate.getGateWorld().field_72995_K) {
                if (this.updateOutputs(gate)) {
                    gate.markGateChanged(true);
                }
            } else if ((this.ticks == 0 || this.ticks == 2) && gate.getGateWorld().field_72995_K) {
                gate.markGateChanged(true);
            }
        }
    }

    public int getTicksTotal() {
        return this.ticksTotal;
    }

    public void setTicksTotal(IGateContainer gate, int ch) {
        int newTicksTotal = this.clampTicksTotal(ch);
        if (newTicksTotal != this.ticksTotal) {
            this.ticksTotal = newTicksTotal;
            gate.markGateChanged(true);
        }
    }
}

