/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.simplelogic.gates.logic;

import java.util.Objects;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.Vec3d;
import pl.asie.charset.lib.notify.component.NotificationComponent;
import pl.asie.charset.lib.notify.component.NotificationComponentString;
import pl.asie.simplelogic.gates.SimpleLogicGates;
import pl.asie.simplelogic.gates.logic.GateConnection;
import pl.asie.simplelogic.gates.logic.GateLogic;
import pl.asie.simplelogic.gates.logic.GateRenderState;
import pl.asie.simplelogic.gates.logic.IGateContainer;

public class GateLogicRepeater
extends GateLogic {
    private static final int[] signalValues = new int[]{1, 2, 3, 4};
    private byte ticks = 0;
    private byte repeatedSignal;
    private byte valueMode = 0;

    @Override
    public GateConnection getType(EnumFacing dir) {
        switch (dir) {
            case NORTH: {
                return GateConnection.OUTPUT;
            }
            case SOUTH: {
                return GateConnection.INPUT;
            }
            case WEST: 
            case EAST: {
                return GateConnection.INPUT_REPEATER;
            }
        }
        return GateConnection.NONE;
    }

    @Override
    public boolean canBlockSide(EnumFacing side) {
        return false;
    }

    @Override
    public boolean canInvertSide(EnumFacing side) {
        return false;
    }

    @Override
    public boolean onRightClick(IGateContainer gate, EntityPlayer playerIn, Vec3d vec, EnumHand hand) {
        if (!playerIn.func_70093_af()) {
            this.valueMode = (byte)((this.valueMode + 1) % signalValues.length);
            gate.markGateChanged(true);
        }
        gate.createNotice((NotificationComponent)NotificationComponentString.translated((String)"notice.simplelogic.gate.repeater.ticks", (NotificationComponent[])new NotificationComponent[]{NotificationComponentString.raw((String)Integer.toString(signalValues[this.valueMode]), (NotificationComponent[])new NotificationComponent[0])})).sendTo(playerIn);
        return true;
    }

    public boolean isRepeaterLocked() {
        return this.getInputValueInside(EnumFacing.WEST) > 0 || this.getInputValueInside(EnumFacing.EAST) > 0;
    }

    @Override
    public boolean shouldTick() {
        return !this.isRepeaterLocked();
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound tag, boolean isClient) {
        tag = super.writeToNBT(tag, isClient);
        tag.func_74774_a("rtk", this.ticks);
        tag.func_74774_a("rrs", this.repeatedSignal);
        tag.func_74774_a("rvm", this.valueMode);
        return tag;
    }

    @Override
    public boolean readFromNBT(NBTTagCompound tag, boolean isClient) {
        byte oldValueMode = this.valueMode;
        this.ticks = tag.func_74771_c("rtk");
        this.repeatedSignal = tag.func_74771_c("rrs");
        this.valueMode = tag.func_74771_c("rvm");
        return super.readFromNBT(tag, isClient) || oldValueMode != this.valueMode;
    }

    @Override
    public GateRenderState getLayerState(int id) {
        return GateRenderState.input(this.getOutputValueInside(EnumFacing.NORTH));
    }

    @Override
    public GateRenderState getTorchState(int id) {
        if (id == 0) {
            return GateRenderState.input(this.getOutputValueInside(EnumFacing.NORTH));
        }
        if (id == this.valueMode + 1) {
            return this.isRepeaterLocked() ? GateRenderState.DISABLED : GateRenderState.input(this.getOutputValueInside(EnumFacing.NORTH));
        }
        return GateRenderState.NO_RENDER;
    }

    private byte getInputSignal() {
        return this.getInputValueInside(EnumFacing.SOUTH);
    }

    @Override
    public void onChanged(IGateContainer gate) {
        if (!gate.getGateWorld().field_72995_K) {
            gate.markGateChanged(false);
        }
        if (this.isRepeaterLocked() || this.repeatedSignal != 0 && this.ticks < 1) {
            return;
        }
        if (this.getInputSignal() != this.repeatedSignal) {
            this.repeatedSignal = this.getInputSignal();
            this.ticks = 0;
            gate.scheduleTick(signalValues[this.valueMode] * SimpleLogicGates.redstoneTickLength);
        }
    }

    @Override
    public boolean tick(IGateContainer gate) {
        if (this.ticks == 1) {
            if (this.repeatedSignal != this.getInputSignal()) {
                this.repeatedSignal = this.getInputSignal();
                return true;
            }
            return false;
        }
        this.ticks = (byte)(this.ticks + 1);
        gate.scheduleTick(signalValues[this.valueMode] * SimpleLogicGates.redstoneTickLength);
        return true;
    }

    @Override
    protected byte calculateOutputInside(EnumFacing side) {
        if (side == EnumFacing.NORTH) {
            if (this.repeatedSignal != 0) {
                return 15;
            }
            return 0;
        }
        return 0;
    }

    @Override
    public boolean renderEquals(GateLogic other) {
        if (!super.renderEquals(other) || !(other instanceof GateLogicRepeater)) {
            return false;
        }
        return ((GateLogicRepeater)other).valueMode == this.valueMode;
    }

    @Override
    public int renderHashCode(int hash) {
        return Objects.hash(super.renderHashCode(hash), this.valueMode);
    }
}

