/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.simplelogic.gates.logic;

public enum GateConnection {
    NONE(false, false, false, false, false),
    INPUT(true, false, true, false, false),
    OUTPUT(false, true, true, false, false),
    INPUT_OUTPUT(true, true, true, false, false),
    INPUT_ANALOG(true, false, true, true, false),
    INPUT_COMPARATOR(true, false, true, true, false),
    INPUT_REPEATER(true, false, false, false, false),
    OUTPUT_ANALOG(false, true, true, true, false),
    INPUT_BUNDLED(true, false, false, false, true),
    OUTPUT_BUNDLED(false, true, false, false, true),
    INPUT_OUTPUT_BUNDLED(true, true, false, false, true);

    private final boolean input;
    private final boolean output;
    private final boolean redstone;
    private final boolean analogRedstone;
    private final boolean bundled;

    private GateConnection(boolean input, boolean output, boolean redstone, boolean analogRedstone, boolean bundled) {
        this.input = input;
        this.output = output;
        this.redstone = redstone;
        this.analogRedstone = analogRedstone;
        this.bundled = bundled;
    }

    public boolean isComparator() {
        return this == INPUT_COMPARATOR;
    }

    public boolean isInput() {
        return this.input;
    }

    public boolean isOutput() {
        return this.output;
    }

    public boolean isRedstone() {
        return this.redstone;
    }

    public boolean isDigital() {
        return this.redstone && !this.analogRedstone;
    }

    public boolean isAnalog() {
        return this.analogRedstone;
    }

    public boolean isBundled() {
        return this.bundled;
    }
}

