/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.simplelogic.gates.gui;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import org.lwjgl.opengl.GL11;
import pl.asie.charset.lib.inventory.ContainerBase;
import pl.asie.charset.lib.inventory.GuiContainerCharset;
import pl.asie.charset.lib.network.Packet;
import pl.asie.simplelogic.gates.SimpleLogicGates;
import pl.asie.simplelogic.gates.gui.ContainerGate;
import pl.asie.simplelogic.gates.logic.GateLogicBundledTransposer;
import pl.asie.simplelogic.gates.network.PacketTransposerConnection;

public class GuiTransposer
extends GuiContainerCharset<ContainerGate> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("simplelogic:textures/gui/transposer.png");
    private final List<TinyButton> buttonList = new ArrayList<TinyButton>(32);
    private TinyButton pressedButton;
    private TinyButton pressedButtonSecond;
    private int presses;

    public GuiTransposer(ContainerGate container) {
        super((ContainerBase)container, 167, 76);
        for (int i = 0; i <= 16; ++i) {
            this.buttonList.add(new TinyButton(i == 16 ? 85 : 76, 7 + i * 9, 8, i, true));
            this.buttonList.add(new TinyButton(i == 16 ? 85 : 76, 7 + i * 9, 59, i, false));
        }
    }

    protected void drawLine(int x1, int y1, int x2, int y2, int color1, int color2) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder builder = tessellator.func_178180_c();
        GlStateManager.func_179147_l();
        GlStateManager.func_179090_x();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GL11.glLineWidth((float)2.0f);
        builder.func_181668_a(1, DefaultVertexFormats.field_181706_f);
        float x = x1;
        float y = y1;
        float xd = (float)(x2 - x1) / 8.0f;
        float yd = (float)(y2 - y1) / 8.0f;
        int step = 0;
        while (step < 9) {
            int col;
            int n = col = (step & 1) == 0 ? color1 : color2;
            if (col != 0) {
                builder.func_181662_b((double)x, (double)y, 0.0).func_181669_b(col >> 16 & 0xFF, col >> 8 & 0xFF, col & 0xFF, col >> 24 & 0xFF).func_181675_d();
                if (step < 8) {
                    builder.func_181662_b((double)(x + xd), (double)(y + yd), 0.0).func_181669_b(col >> 16 & 0xFF, col >> 8 & 0xFF, col & 0xFF, col >> 24 & 0xFF).func_181675_d();
                }
            }
            ++step;
            x += xd;
            y += yd;
        }
        tessellator.func_78381_a();
        GlStateManager.func_179098_w();
        GlStateManager.func_179084_k();
    }

    protected void func_146976_a(float partial, int mouseX, int mouseY) {
        super.func_146976_a(partial, mouseX, mouseY);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(TEXTURE);
        this.func_73729_b(this.xBase, this.yBase, 0, 0, this.field_146999_f, this.field_147000_g);
        GateLogicBundledTransposer logic = (GateLogicBundledTransposer)((ContainerGate)this.container).gate.logic;
        for (int from = 0; from < 16; ++from) {
            int v = logic.transpositionMap[from];
            int i = 0;
            while (v != 0) {
                if ((v & 1) != 0) {
                    int c1 = EnumDyeColor.func_176764_b((int)from).func_193350_e() | 0xDF000000;
                    int c2 = EnumDyeColor.func_176764_b((int)i).func_193350_e() | 0xDF000000;
                    this.drawLine(this.xBase + 12 + i * 9, this.yBase + 17, this.xBase + 12 + from * 9, this.yBase + 58, c1, c2);
                }
                v >>= 1;
                ++i;
            }
        }
        if (this.pressedButton != null && this.pressedButtonSecond == null) {
            int col = this.pressedButton.color;
            if (col == 16) {
                for (int i = 0; i < 16; ++i) {
                    int c1 = EnumDyeColor.func_176764_b((int)i).func_193350_e() | 0xFF000000;
                    int c2 = GuiScreen.func_146272_n() ? 0 : c1;
                    this.drawLine(this.xBase + 12 + i * 9, this.yBase + this.pressedButton.y + (!this.pressedButton.bottomRow ? 0 : 9), mouseX, mouseY, c1, c2);
                }
            } else {
                int c1 = EnumDyeColor.func_176764_b((int)col).func_193350_e() | 0xFF000000;
                int c2 = GuiScreen.func_146272_n() ? 0 : c1;
                this.drawLine(this.xBase + this.pressedButton.x + 5, this.yBase + this.pressedButton.y + (!this.pressedButton.bottomRow ? 0 : 9), mouseX, mouseY, c1, c2);
            }
        }
        int mxb = mouseX - this.xBase;
        int myb = mouseY - this.yBase;
        for (TinyButton tb : this.buttonList) {
            int texX;
            int n = tb.pressed ? 18 : (texX = mxb >= tb.x && mxb < tb.x + tb.w && myb >= tb.y && myb < tb.y + tb.h ? 9 : 0);
            if (texX == 9 && this.pressedButton != null && this.pressedButton.bottomRow == tb.bottomRow) {
                texX = 0;
            }
            GuiTransposer.func_73734_a((int)(this.xBase + tb.x), (int)(this.yBase + tb.y), (int)(this.xBase + tb.x + 9), (int)(this.yBase + tb.y + 9), (int)(EnumDyeColor.func_176764_b((int)tb.color).func_193350_e() | 0xFF000000));
            this.func_73729_b(this.xBase + tb.x, this.yBase + tb.y, texX, tb.texY, 9, 9);
        }
    }

    public void func_73864_a(int x, int y, int mb) throws IOException {
        super.func_73864_a(x, y, mb);
        if (mb == 0 && this.presses < 2) {
            for (TinyButton button : this.buttonList) {
                int bx = this.xBase + button.x;
                int by = this.yBase + button.y;
                if (x < bx || x >= bx + button.w || y < by || y >= by + button.h) continue;
                button.pressed = true;
                if (this.pressedButton == null) {
                    this.pressedButton = button;
                    continue;
                }
                if (this.pressedButtonSecond != null) continue;
                this.pressedButtonSecond = button;
            }
            if (this.presses == 1 || this.presses == 0 && this.pressedButton != null) {
                ++this.presses;
            }
        }
    }

    private void clearPresses() {
        if (this.pressedButton != null) {
            this.pressedButton.pressed = false;
        }
        if (this.pressedButtonSecond != null) {
            this.pressedButtonSecond.pressed = false;
        }
        this.pressedButtonSecond = null;
        this.pressedButton = null;
        this.presses = 0;
    }

    private void sendPackets(int from, int to, boolean remove) {
        if (from == 16) {
            from = -1;
        }
        if (to == 16) {
            to = -1;
        }
        if (from != -1 && to != -1) {
            SimpleLogicGates.packet.sendToServer((Packet)new PacketTransposerConnection(((ContainerGate)this.container).gate, from, to, remove));
        } else if (from != -1) {
            for (int t = 0; t < 16; ++t) {
                SimpleLogicGates.packet.sendToServer((Packet)new PacketTransposerConnection(((ContainerGate)this.container).gate, from, t, remove));
            }
        } else if (to != -1) {
            for (int t = 0; t < 16; ++t) {
                SimpleLogicGates.packet.sendToServer((Packet)new PacketTransposerConnection(((ContainerGate)this.container).gate, t, to, remove));
            }
        } else if (remove) {
            for (int t = 0; t < 256; ++t) {
                SimpleLogicGates.packet.sendToServer((Packet)new PacketTransposerConnection(((ContainerGate)this.container).gate, t & 0xF, t >> 4, remove));
            }
        } else {
            for (int t = 0; t < 16; ++t) {
                SimpleLogicGates.packet.sendToServer((Packet)new PacketTransposerConnection(((ContainerGate)this.container).gate, t, t, remove));
            }
        }
    }

    public void func_146286_b(int x, int y, int which) {
        super.func_146286_b(x, y, which);
        if (which >= 0) {
            if (this.presses == 1 && this.pressedButton != null || this.presses == 2 && this.pressedButtonSecond != null) {
                this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
            }
            if (this.pressedButton != null && this.pressedButtonSecond != null && this.pressedButton.bottomRow == this.pressedButtonSecond.bottomRow) {
                this.clearPresses();
                return;
            }
            int from = -1;
            int to = -1;
            if (this.pressedButton != null) {
                if (this.pressedButton.bottomRow) {
                    to = this.pressedButton.color;
                    from = this.pressedButtonSecond != null ? this.pressedButtonSecond.color : -1;
                } else {
                    from = this.pressedButton.color;
                    int n = to = this.pressedButtonSecond != null ? this.pressedButtonSecond.color : -1;
                }
            }
            if (GuiScreen.func_146272_n()) {
                if (from != -1 || to != -1) {
                    this.sendPackets(from, to, true);
                }
                this.clearPresses();
            } else if (this.presses >= 2) {
                if (from >= 0 && to >= 0) {
                    this.sendPackets(from, to, false);
                }
                this.clearPresses();
            }
        }
    }

    public static class TinyButton {
        private final int texY;
        private final int x;
        private final int y;
        private final int w;
        private final int h;
        private final int color;
        private final boolean bottomRow;
        private boolean pressed;

        public TinyButton(int texY, int x, int y, int color, boolean bottomRow) {
            this.texY = texY;
            this.x = x;
            this.y = y;
            this.w = 9;
            this.h = 9;
            this.color = color;
            this.bottomRow = bottomRow;
        }
    }
}

