/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.simplelogic.gates;

import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.util.HashMap;
import java.util.HashSet;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pl.asie.charset.lib.render.ArrowHighlightHandler;
import pl.asie.charset.lib.render.sprite.PixelOperationSprite;
import pl.asie.charset.lib.utils.RegistryUtils;
import pl.asie.charset.lib.utils.RenderUtils;
import pl.asie.simplelogic.gates.PartGate;
import pl.asie.simplelogic.gates.ProxyCommon;
import pl.asie.simplelogic.gates.SimpleLogicGates;
import pl.asie.simplelogic.gates.SimpleLogicGatesClient;
import pl.asie.simplelogic.gates.addon.GateRegisterClientEvent;
import pl.asie.simplelogic.gates.gui.GuiTimer;
import pl.asie.simplelogic.gates.gui.GuiTransposer;
import pl.asie.simplelogic.gates.logic.GateLogicBundledTransposer;
import pl.asie.simplelogic.gates.logic.GateLogicTimer;
import pl.asie.simplelogic.gates.render.FastTESRGate;
import pl.asie.simplelogic.gates.render.GateCustomRendererArrow;
import pl.asie.simplelogic.gates.render.GateCustomRendererTransposer;
import pl.asie.simplelogic.gates.render.GateRenderDefinitions;
import pl.asie.simplelogic.gates.render.RendererGate;

public class ProxyClient
extends ProxyCommon {
    @Override
    public void init() {
        super.init();
        ArrowHighlightHandler.register((world, orientation, stack, trace) -> world.isSideSolid(trace.func_178782_a(), trace.field_178784_b), (player, trace, stack) -> {
            PartGate gate = new PartGate();
            gate.onPlacedBy((EntityLivingBase)player, trace.field_178784_b, stack, (float)(trace.field_72307_f.field_72450_a - (double)trace.func_178782_a().func_177958_n()), (float)(trace.field_72307_f.field_72448_b - (double)trace.func_178782_a().func_177956_o()), (float)(trace.field_72307_f.field_72449_c - (double)trace.func_178782_a().func_177952_p()));
            return gate.getOrientation();
        }, (Item[])new Item[]{SimpleLogicGates.itemGate});
        SimpleLogicGatesClient.INSTANCE.registerRenderer(new GateCustomRendererTransposer());
        SimpleLogicGatesClient.INSTANCE.registerRenderer(new GateCustomRendererArrow(){

            @Override
            public Class<GateLogicTimer> getLogicClass() {
                return GateLogicTimer.class;
            }
        });
        SimpleLogicGatesClient.INSTANCE.registerGui(GateLogicTimer.class, GuiTimer::new);
        SimpleLogicGatesClient.INSTANCE.registerGui(GateLogicBundledTransposer.class, GuiTransposer::new);
        ClientRegistry.bindTileEntitySpecialRenderer(PartGate.class, (TileEntitySpecialRenderer)new FastTESRGate());
        MinecraftForge.EVENT_BUS.post((Event)new GateRegisterClientEvent());
    }

    @Override
    public void openGui(PartGate gate, EntityPlayer playerIn) {
        SimpleLogicGatesClient.INSTANCE.openGui(gate);
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onModelRegister(ModelRegistryEvent event) {
        RegistryUtils.registerModel((Item)SimpleLogicGates.itemGate, (int)0, (String)"charset:logic_gate");
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onPostBake(ModelBakeEvent event) {
        event.getModelRegistry().func_82595_a((Object)new ModelResourceLocation("charset:logic_gate", "normal"), (Object)RendererGate.INSTANCE);
        event.getModelRegistry().func_82595_a((Object)new ModelResourceLocation("charset:logic_gate", "inventory"), (Object)RendererGate.INSTANCE);
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onTextureStitch(TextureStitchEvent.Pre event) {
        GateCustomRendererTransposer.WHITE = event.getMap().func_174942_a(new ResourceLocation("charset", "misc/white"));
        GateCustomRendererTransposer.STRIPES = event.getMap().func_174942_a(new ResourceLocation("simplelogic", "blocks/stripes"));
        GateCustomRendererTransposer.rayModels = null;
        SimpleLogicGates.sendAddonEventIfNotSent();
        GateCustomRendererArrow.arrowModel = RenderUtils.getModelWithTextures((ResourceLocation)new ResourceLocation("simplelogic:block/gate_arrow"), (TextureMap)event.getMap());
        GateRenderDefinitions.INSTANCE.load("simplelogic:gatedefs/base.json", SimpleLogicGates.logicDefinitions);
        ResourceLocation top_underlay = GateRenderDefinitions.INSTANCE.base.getTexture("top_underlay");
        event.getMap().func_174942_a(top_underlay);
        for (ResourceLocation rs : SimpleLogicGates.logicClasses.keySet()) {
            HashSet<ResourceLocation> textures = new HashSet<ResourceLocation>();
            HashMap<String, TIntObjectMap> colorMasks = new HashMap<String, TIntObjectMap>();
            GateRenderDefinitions.Definition def = GateRenderDefinitions.INSTANCE.getGateDefinition(rs);
            int i = 0;
            for (GateRenderDefinitions.Layer layer : def.layers) {
                if (layer.color_mask != null) {
                    layer.texture = rs.func_110624_b() + ":blocks/" + rs.func_110623_a() + "/layer_" + i;
                    colorMasks.computeIfAbsent(layer.textureBase, k -> new TIntObjectHashMap()).put(Integer.parseInt(layer.color_mask, 16), (Object)layer.texture);
                }
                ++i;
            }
            for (IModel model : def.getAllModels()) {
                textures.addAll(RenderUtils.getAllTextures((IModel)model));
            }
            for (GateRenderDefinitions.Layer layer : def.layers) {
                if (layer.texture == null) continue;
                textures.add(new ResourceLocation(layer.texture));
            }
            for (String baseTexture : colorMasks.keySet()) {
                TIntObjectMap resultingTextures = (TIntObjectMap)colorMasks.get(baseTexture);
                resultingTextures.forEachEntry((color, resultingTexture) -> {
                    event.getMap().setTextureEntry((TextureAtlasSprite)new PixelOperationSprite(resultingTexture, new ResourceLocation(baseTexture), PixelOperationSprite.forEach((x, y, value) -> (value & 0xFFFFFF) == color && (value & 0xFF000000) != 0 ? -1 : 0), new ResourceLocation[0]).forceReadFromFile(true));
                    textures.remove(new ResourceLocation(resultingTexture));
                    return true;
                });
                event.getMap().setTextureEntry((TextureAtlasSprite)new PixelOperationSprite(baseTexture, new ResourceLocation(baseTexture), (pixels, width, getter) -> {
                    TextureAtlasSprite topUnderlay = (TextureAtlasSprite)getter.apply(top_underlay);
                    int height = pixels.length / width;
                    for (int iy = 0; iy < height; ++iy) {
                        for (int ix = 0; ix < width; ++ix) {
                            int iU;
                            int iUy;
                            int iUx;
                            int ip = iy * width + ix;
                            int value = pixels[ip];
                            if (resultingTextures.containsKey(value & 0xFFFFFF) && (value & 0xFF000000) != 0) {
                                pixels[ip] = 0;
                                continue;
                            }
                            if ((value & 0xFF000000) == -16777216) {
                                pixels[ip] = value;
                                continue;
                            }
                            if ((value & 0xFF000000) != 0) {
                                iUx = ix * topUnderlay.func_94211_a() / width;
                                iUy = iy * topUnderlay.func_94216_b() / height;
                                iU = iUy * topUnderlay.func_94211_a() + iUx;
                                int col1 = topUnderlay.func_147965_a(0)[0][iU];
                                int col2 = value;
                                int r1 = col1 >> 16 & 0xFF;
                                int g1 = col1 >> 8 & 0xFF;
                                int b1 = col1 & 0xFF;
                                int a2 = col2 >> 24 & 0xFF;
                                int r2 = col2 >> 16 & 0xFF;
                                int g2 = col2 >> 8 & 0xFF;
                                int b2 = col2 & 0xFF;
                                int r = MathHelper.func_76125_a((int)(r1 + Math.round((float)((r2 - r1) * a2) / 255.0f)), (int)0, (int)255);
                                int g = MathHelper.func_76125_a((int)(g1 + Math.round((float)((g2 - g1) * a2) / 255.0f)), (int)0, (int)255);
                                int b = MathHelper.func_76125_a((int)(b1 + Math.round((float)((b2 - b1) * a2) / 255.0f)), (int)0, (int)255);
                                pixels[ip] = 0xFF000000 | r << 16 | g << 8 | b;
                                continue;
                            }
                            iUx = ix * topUnderlay.func_94211_a() / width;
                            iUy = iy * topUnderlay.func_94216_b() / height;
                            iU = iUy * topUnderlay.func_94211_a() + iUx;
                            pixels[ip] = topUnderlay.func_147965_a(0)[0][iU];
                        }
                    }
                }, new ResourceLocation[]{top_underlay}).useLargestSize(true));
                textures.remove(new ResourceLocation(baseTexture));
            }
            for (ResourceLocation location : textures) {
                event.getMap().func_174942_a(location);
            }
        }
    }
}

