/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.simplelogic.gates;

import java.util.Optional;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Loader;
import pl.asie.charset.lib.item.ItemBlockBase;
import pl.asie.simplelogic.gates.PartGate;
import pl.asie.simplelogic.gates.SimpleLogicGates;
import pl.asie.simplelogic.gates.logic.GateLogic;

public class ItemGate
extends ItemBlockBase {
    public ItemGate(Block block) {
        super(block);
        this.func_77627_a(true);
    }

    public static ItemStack getStack(PartGate gate) {
        return ItemGate.getStack(gate, false);
    }

    public static ItemStack getStack(PartGate gate, boolean silky) {
        if (!SimpleLogicGates.logicClasses.containsValue(gate.logic.getClass())) {
            return ItemStack.field_190927_a;
        }
        ItemStack stack = new ItemStack((Item)SimpleLogicGates.itemGate);
        stack.func_77982_d(new NBTTagCompound());
        gate.writeItemNBT(stack.func_77978_p(), silky);
        return stack;
    }

    public static Optional<PartGate> getPartGate(ItemStack stack) {
        if (stack.func_77942_o() && stack.func_77978_p().func_150297_b("logic", 8)) {
            Optional<PartGate> gate = ItemGate.getPartGate(new ResourceLocation(stack.func_77978_p().func_74779_i("logic")));
            gate.ifPresent(a -> a.loadFromStack(stack));
            return gate;
        }
        return Optional.empty();
    }

    public String getCreatorModId(ItemStack stack) {
        String s;
        if (stack.func_77942_o() && stack.func_77978_p().func_150297_b("logic", 8) && Loader.isModLoaded((String)(s = new ResourceLocation(stack.func_77978_p().func_74779_i("logic")).func_110624_b()))) {
            return s;
        }
        return super.getCreatorModId(stack);
    }

    public String func_77653_i(ItemStack stack) {
        Optional<PartGate> gate = ItemGate.getPartGate(stack);
        if (!gate.isPresent()) {
            return "[UNKNOWN GATE]";
        }
        ResourceLocation loc = (ResourceLocation)SimpleLogicGates.logicClasses.inverse().get(gate.get().logic.getClass());
        if (loc == null) {
            return "[UNKNOWN GATE]";
        }
        String name = SimpleLogicGates.logicUns.get(loc);
        if (name == null) {
            return "[UNKNOWN GATE]";
        }
        if (gate.get().logic.isSideInverted(EnumFacing.NORTH) && I18n.func_94522_b((String)(name + ".i.name"))) {
            name = name + ".i";
        }
        return I18n.func_74838_a((String)(name + ".name"));
    }

    public boolean placeBlockAt(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, IBlockState newState) {
        if (!world.isSideSolid(pos.func_177972_a(side.func_176734_d()), side)) {
            return false;
        }
        return super.placeBlockAt(stack, player, world, pos, side, hitX, hitY, hitZ, newState);
    }

    public static Optional<GateLogic> getGateLogic(GateLogic prevLogic, ResourceLocation rs) {
        try {
            Class c = (Class)SimpleLogicGates.logicClasses.get((Object)rs);
            if (c != null && (prevLogic == null || prevLogic.getClass() != c)) {
                return Optional.of(c.newInstance());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return Optional.of(prevLogic);
    }

    public static Optional<GateLogic> getGateLogic(ResourceLocation rs) {
        try {
            Class c = (Class)SimpleLogicGates.logicClasses.get((Object)rs);
            if (c != null) {
                return Optional.of(c.newInstance());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return Optional.empty();
    }

    public static Optional<PartGate> getPartGate(ResourceLocation rs) {
        try {
            Class c = (Class)SimpleLogicGates.logicClasses.get((Object)rs);
            if (c != null) {
                return Optional.of(new PartGate((GateLogic)c.newInstance()));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return Optional.empty();
    }
}

