/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.entity.witch;

import fathertoast.specialmobs.bestiary.BestiaryInfo;
import fathertoast.specialmobs.entity.SpecialMobData;
import fathertoast.specialmobs.entity.spider.EntityBabySpider;
import fathertoast.specialmobs.entity.spider.Entity_SpecialSpider;
import fathertoast.specialmobs.entity.witch.Entity_SpecialWitch;
import fathertoast.specialmobs.loot.LootTableBuilder;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.PotionTypes;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemMonsterPlacer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class EntityWildsWitch
extends Entity_SpecialWitch {
    private static final String TAG_SPIDER_MOUNTS = "SpiderMountCount";
    private static final String TAG_SWARM_COUNT = "SpiderSwarmCount";
    private static final String TAG_SWARM_SIZE = "SpiderSwarmSize";
    private static final ResourceLocation[] TEXTURES = new ResourceLocation[]{new ResourceLocation(EntityWildsWitch.GET_TEXTURE_PATH("wilds"))};
    public static ResourceLocation LOOT_TABLE;
    private int spiderMounts;
    private int spiderSwarms;
    private int spiderSwarmSize;

    public static BestiaryInfo GET_BESTIARY_INFO() {
        BestiaryInfo info = new BestiaryInfo(11013646);
        info.weightExceptions = BestiaryInfo.DEFAULT_THEME_FOREST;
        return info;
    }

    public static void BUILD_LOOT_TABLE(LootTableBuilder loot) {
        EntityWildsWitch.ADD_BASE_LOOT(loot);
        ResourceLocation name = EntityList.func_191306_a(EntitySpider.class);
        ItemStack spawnEgg = new ItemStack(Items.field_151063_bx);
        ItemMonsterPlacer.func_185078_a((ItemStack)spawnEgg, (ResourceLocation)name);
        loot.addUncommonDrop("uncommon", "Spawn egg", spawnEgg);
    }

    public EntityWildsWitch(World world) {
        super(world);
        this.getSpecialData().setImmuneToWebs(true);
        this.getSpecialData().addPotionImmunity(MobEffects.field_76436_u);
    }

    @Override
    public ResourceLocation[] getDefaultTextures() {
        return TEXTURES;
    }

    protected ResourceLocation func_184647_J() {
        return LOOT_TABLE;
    }

    @Override
    protected void adjustTypeAttributes() {
        this.spiderMounts = 1 + this.field_70146_Z.nextInt(3);
        this.spiderSwarms = 2 + this.field_70146_Z.nextInt(3);
        this.spiderSwarmSize = 3;
        ++this.field_70728_aV;
        this.getSpecialData().multAttribute(SharedMonsterAttributes.field_111263_d, 0.7);
    }

    @Override
    public void func_70636_d() {
        if (this.func_184187_bx() instanceof EntityLiving && this.func_70638_az() != null && this.field_70146_Z.nextInt(10) == 0) {
            ((EntityLiving)this.func_184187_bx()).func_70624_b(this.func_70638_az());
        }
        super.func_70636_d();
    }

    @Override
    protected ItemStack pickThrownPotionByType(ItemStack potion, EntityLivingBase target, float distanceFactor, float distance) {
        if (this.spiderSwarms > 0 && this.field_70146_Z.nextInt(4) == 0) {
            --this.spiderSwarms;
            BlockPos pos = new BlockPos((Entity)this);
            for (int i = 0; i < this.spiderSwarmSize; ++i) {
                EntityBabySpider baby = new EntityBabySpider(this.field_70170_p);
                baby.func_82149_j((Entity)this);
                baby.func_70624_b(this.func_70638_az());
                baby.func_180482_a(this.field_70170_p.func_175649_E(pos), null);
                baby.field_70159_w = (this.field_70146_Z.nextDouble() - 0.5) * 0.3;
                baby.field_70181_x = this.field_70146_Z.nextDouble() * 0.5;
                baby.field_70179_y = (this.field_70146_Z.nextDouble() - 0.5) * 0.3;
                this.field_70170_p.func_72838_d((Entity)baby);
            }
            this.func_70656_aK();
            this.func_184185_a(SoundEvents.field_187511_aA, 1.0f, 2.0f / (this.field_70146_Z.nextFloat() * 0.4f + 0.8f));
            potion = ItemStack.field_190927_a;
        } else if (!target.func_70644_a(MobEffects.field_76436_u)) {
            potion = this.makeSplashPotion(PotionTypes.field_185219_B);
        } else {
            PotionType currentType = PotionUtils.func_185191_c((ItemStack)potion);
            if (currentType == PotionTypes.field_185252_x || currentType == PotionTypes.field_185253_y) {
                potion = this.makeSplashPotion(PotionTypes.field_185219_B);
            }
        }
        return potion;
    }

    @Override
    public void tryDrinkPotion() {
        if (this.potionThrowTimer <= 0) {
            EntityLivingBase mount = this.func_184187_bx() instanceof EntityLivingBase ? (EntityLivingBase)this.func_184187_bx() : null;
            if (mount != null && this.field_70146_Z.nextFloat() < 0.15f && (mount.func_70027_ad() || mount.func_189748_bU() != null && mount.func_189748_bU().func_76347_k()) && !mount.func_70644_a(MobEffects.field_76426_n)) {
                this.usePotion(this.makeSplashPotion(PotionTypes.field_185241_m));
            } else if (this.field_70146_Z.nextFloat() < 0.15f && (this.func_70027_ad() || this.func_189748_bU() != null && this.func_189748_bU().func_76347_k()) && !this.func_70644_a(MobEffects.field_76426_n)) {
                this.usePotion(this.makePotion(PotionTypes.field_185241_m));
            } else if (mount != null && this.field_70146_Z.nextFloat() < 0.15f && mount.func_70055_a(Material.field_151586_h) && !mount.func_70644_a(MobEffects.field_76427_o)) {
                this.usePotion(this.makeSplashPotion(PotionTypes.field_185248_t));
            } else if (this.field_70146_Z.nextFloat() < 0.15f && this.func_70055_a(Material.field_151586_h) && !this.func_70644_a(MobEffects.field_76427_o)) {
                this.usePotion(this.makePotion(PotionTypes.field_185248_t));
            } else if (mount != null && !mount.func_70662_br() && this.field_70146_Z.nextFloat() < 0.05f && mount.func_110143_aJ() < mount.func_110138_aP()) {
                this.usePotion(this.makeSplashPotion(PotionTypes.field_185250_v));
            } else if (this.field_70146_Z.nextFloat() < 0.05f && this.func_110143_aJ() < this.func_110138_aP()) {
                this.usePotion(this.makePotion(PotionTypes.field_185250_v));
            } else if (this.field_70146_Z.nextFloat() < 0.5f && this.func_70638_az() != null && !this.func_70644_a(MobEffects.field_76424_c) && this.func_70638_az().func_70068_e((Entity)this) > 121.0) {
                this.usePotion(this.makeSplashPotion(PotionTypes.field_185243_o));
            } else {
                this.tryDrinkPotionByType();
            }
        }
    }

    @Override
    protected void tryDrinkPotionByType() {
        if (this.spiderMounts > 0 && this.field_70146_Z.nextFloat() < 0.15f && this.func_184187_bx() == null && this.func_70638_az() != null && this.func_70638_az().func_70068_e((Entity)this) > 100.0) {
            Entity_SpecialSpider mount = new Entity_SpecialSpider(this.field_70170_p);
            mount.func_82149_j((Entity)this);
            if (this.field_70170_p.func_184143_b(mount.func_174813_aQ())) {
                return;
            }
            --this.spiderMounts;
            this.potionThrowTimer = 40;
            mount.func_70624_b(this.func_70638_az());
            mount.func_180482_a(this.field_70170_p.func_175649_E(new BlockPos((Entity)this)), null);
            this.field_70170_p.func_72838_d((Entity)mount);
            this.func_70656_aK();
            this.func_184185_a(SoundEvents.field_187606_E, 1.0f, 2.0f / (this.field_70146_Z.nextFloat() * 0.4f + 0.8f));
            this.func_184205_a((Entity)mount, true);
        }
    }

    @Override
    public void func_70014_b(NBTTagCompound tag) {
        super.func_70014_b(tag);
        NBTTagCompound saveTag = SpecialMobData.getSaveLocation(tag);
        saveTag.func_74774_a(TAG_SPIDER_MOUNTS, (byte)this.spiderMounts);
        saveTag.func_74774_a(TAG_SWARM_COUNT, (byte)this.spiderSwarms);
        saveTag.func_74774_a(TAG_SWARM_SIZE, (byte)this.spiderSwarmSize);
    }

    @Override
    public void func_70037_a(NBTTagCompound tag) {
        super.func_70037_a(tag);
        NBTTagCompound saveTag = SpecialMobData.getSaveLocation(tag);
        if (saveTag.func_150297_b(TAG_SPIDER_MOUNTS, 99)) {
            this.spiderMounts = saveTag.func_74771_c(TAG_SPIDER_MOUNTS);
        }
        if (saveTag.func_150297_b(TAG_SWARM_COUNT, 99)) {
            this.spiderSwarms = saveTag.func_74771_c(TAG_SWARM_COUNT);
        }
        if (saveTag.func_150297_b(TAG_SWARM_SIZE, 99)) {
            this.spiderSwarmSize = saveTag.func_74771_c(TAG_SWARM_SIZE);
        }
    }
}

