/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.entity.skeleton;

import com.google.common.base.Optional;
import fathertoast.specialmobs.ai.EntityAINinja;
import fathertoast.specialmobs.ai.INinja;
import fathertoast.specialmobs.bestiary.BestiaryInfo;
import fathertoast.specialmobs.entity.skeleton.Entity_SpecialSkeleton;
import fathertoast.specialmobs.loot.LootTableBuilder;
import net.minecraft.block.BlockSilverfish;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemStack;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;

public class EntityNinjaSkeleton
extends Entity_SpecialSkeleton
implements INinja {
    private static final int AI_PRIORITY_NINJA = 0;
    private static final DataParameter<Boolean> IS_HIDING = EntityDataManager.func_187226_a(EntityNinjaSkeleton.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Optional<IBlockState>> HIDING_BLOCK = EntityDataManager.func_187226_a(EntityNinjaSkeleton.class, (DataSerializer)DataSerializers.field_187197_g);
    private static final ResourceLocation[] TEXTURES = new ResourceLocation[]{new ResourceLocation("textures/entity/skeleton/skeleton.png"), null, new ResourceLocation(EntityNinjaSkeleton.GET_TEXTURE_PATH("ninja_overlay"))};
    public static ResourceLocation LOOT_TABLE;
    private boolean canHide = true;

    public static BestiaryInfo GET_BESTIARY_INFO() {
        BestiaryInfo info = new BestiaryInfo(0x333366);
        return info;
    }

    public static void BUILD_LOOT_TABLE(LootTableBuilder loot) {
        EntityNinjaSkeleton.ADD_BASE_LOOT(loot);
        BlockSilverfish.EnumType[] blockDisguiseTypes = BlockSilverfish.EnumType.values();
        ItemStack[] infestedBlocks = new ItemStack[blockDisguiseTypes.length];
        for (int i = 0; i < infestedBlocks.length; ++i) {
            infestedBlocks[i] = new ItemStack(Blocks.field_150418_aU, 1, blockDisguiseTypes[i].func_176881_a());
        }
        loot.addUncommonDrop("uncommon", "Infested block", infestedBlocks);
    }

    public EntityNinjaSkeleton(World world) {
        super(world);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(IS_HIDING, (Object)Boolean.FALSE);
        this.field_70180_af.func_187214_a(HIDING_BLOCK, (Object)Optional.absent());
    }

    @Override
    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, new EntityAINinja<EntityNinjaSkeleton>(this));
        super.func_184651_r();
    }

    @Override
    public ResourceLocation[] getDefaultTextures() {
        return TEXTURES;
    }

    protected ResourceLocation func_184647_J() {
        return LOOT_TABLE;
    }

    @Override
    protected void adjustTypeAttributes() {
        this.field_70728_aV += 2;
        this.getSpecialData().multAttribute(SharedMonsterAttributes.field_111263_d, 1.2);
    }

    @Override
    protected void initTypeAI() {
        this.setRangedAI(1.0, 10, 9.0f);
    }

    @Override
    protected void func_180481_a(DifficultyInstance difficulty) {
        super.func_180481_a(difficulty);
        if (!(this.func_184614_ca().func_77973_b() instanceof ItemBow) || this.field_70146_Z.nextBoolean()) {
            this.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(Items.field_151040_l));
        }
        this.func_98053_h(true);
    }

    @Override
    public boolean isInDisguise() {
        return (Boolean)this.func_184212_Q().func_187225_a(IS_HIDING);
    }

    @Override
    public void setInDisguise(boolean disguised) {
        if (disguised != this.isInDisguise()) {
            this.func_184212_Q().func_187227_b(IS_HIDING, (Object)disguised);
            if (disguised) {
                this.field_70165_t = Math.floor(this.field_70165_t) + 0.5;
                this.field_70163_u = Math.floor(this.field_70163_u);
                this.field_70161_v = Math.floor(this.field_70161_v) + 0.5;
            }
        }
    }

    @Override
    public IBlockState getDisguiseBlock() {
        if (this.func_70089_S()) {
            return (IBlockState)((Optional)this.func_184212_Q().func_187225_a(HIDING_BLOCK)).orNull();
        }
        return null;
    }

    @Override
    public void setDisguiseBlock(IBlockState block) {
        this.func_184212_Q().func_187227_b(HIDING_BLOCK, (Object)Optional.fromNullable((Object)block));
        this.canHide = false;
        if (block == null) {
            this.func_70656_aK();
        }
    }

    @Override
    public void func_70636_d() {
        if (!this.field_70170_p.field_72995_K) {
            if (this.canHide) {
                EntityAINinja.startHiding(this);
            } else if (this.field_70122_E && (this.func_70638_az() == null || this.func_70638_az() instanceof EntityPlayer && ((EntityPlayer)this.func_70638_az()).field_71075_bZ.field_75098_d) && this.getDisguiseBlock() == null) {
                this.canHide = true;
            }
        }
        super.func_70636_d();
    }

    @Override
    protected void onTypeAttack(Entity target) {
        this.setDisguiseBlock(null);
        if (target instanceof EntityLivingBase) {
            this.func_70624_b((EntityLivingBase)target);
        }
    }

    @Override
    public boolean func_70097_a(DamageSource damageSource, float damage) {
        if (super.func_70097_a(damageSource, damage)) {
            this.setDisguiseBlock(null);
            if (damageSource.func_76346_g() instanceof EntityLivingBase) {
                this.func_70624_b((EntityLivingBase)damageSource.func_76346_g());
            }
            return true;
        }
        return false;
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        if (!this.field_70170_p.field_72995_K && this.getDisguiseBlock() != null) {
            this.setDisguiseBlock(null);
            this.func_70624_b((EntityLivingBase)player);
        }
        return super.func_184645_a(player, hand);
    }

    public void func_70091_d(MoverType type, double x, double y, double z) {
        if (this.isInDisguise() && type != MoverType.PISTON) {
            this.field_70181_x = 0.0;
        } else {
            super.func_70091_d(type, x, y, z);
        }
    }

    @Override
    public void func_70015_d(int time) {
        if (!this.isInDisguise()) {
            super.func_70015_d(time);
        }
    }

    public boolean func_70104_M() {
        return !this.isInDisguise();
    }
}

