/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.entity.silverfish;

import fathertoast.specialmobs.ai.IAngler;
import fathertoast.specialmobs.bestiary.BestiaryInfo;
import fathertoast.specialmobs.entity.SpecialMobData;
import fathertoast.specialmobs.entity.projectile.EntitySpecialFishHook;
import fathertoast.specialmobs.entity.silverfish.Entity_SpecialSilverfish;
import fathertoast.specialmobs.loot.LootEntryItemBuilder;
import fathertoast.specialmobs.loot.LootPoolBuilder;
import fathertoast.specialmobs.loot.LootTableBuilder;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootEntry;

public class EntityFishingSilverfish
extends Entity_SpecialSilverfish
implements IAngler {
    private static final ResourceLocation[] TEXTURES = new ResourceLocation[]{new ResourceLocation(EntityFishingSilverfish.GET_TEXTURE_PATH("fishing"))};
    public static ResourceLocation LOOT_TABLE;
    private int rodTime = 0;
    private EntitySpecialFishHook fishHook = null;

    public static BestiaryInfo GET_BESTIARY_INFO() {
        BestiaryInfo info = new BestiaryInfo(2966004);
        info.weightExceptions = BestiaryInfo.DEFAULT_THEME_FISHING;
        return info;
    }

    public static void BUILD_LOOT_TABLE(LootTableBuilder loot) {
        EntityFishingSilverfish.ADD_BASE_LOOT(loot);
        loot.addPool(new LootPoolBuilder("common").addEntry((LootEntry)new LootEntryItemBuilder("Fish", Items.field_151115_aP).setCount(0, 2).addLootingBonus(0.0f, 1.0f).smeltIfBurning().toLootEntry()).toLootPool());
    }

    public EntityFishingSilverfish(World world) {
        super(world);
        this.func_70105_a(0.4f, 0.8f);
        this.getSpecialData().setBaseScale(1.2f);
        this.getSpecialData().setCanBreatheInWater(true);
        this.getSpecialData().setIgnoreWaterPush(true);
    }

    @Override
    public ResourceLocation[] getDefaultTextures() {
        return TEXTURES;
    }

    protected ResourceLocation func_184647_J() {
        return LOOT_TABLE;
    }

    @Override
    protected void adjustTypeAttributes() {
        this.field_70728_aV += 2;
        this.getSpecialData().addAttribute(SharedMonsterAttributes.field_111267_a, 4.0);
        this.getSpecialData().multAttribute(SharedMonsterAttributes.field_111263_d, 0.9);
    }

    @Override
    protected void initTypeAI() {
        this.getSpecialData().rangedAttackSpread = 10.0f;
        this.getSpecialData().rangedAttackCooldown = 32;
        this.getSpecialData().rangedAttackMaxCooldown = 48;
        this.getSpecialData().rangedAttackMaxRange = 10.0f;
    }

    @Override
    public void func_70636_d() {
        EntityLivingBase target;
        super.func_70636_d();
        if (this.rodTime > 0) {
            --this.rodTime;
        }
        if (!this.field_70170_p.field_72995_K && this.rodTime <= 0 && !this.isLineOut() && (target = this.func_70638_az()) != null) {
            SpecialMobData data = this.getSpecialData();
            float distanceSq = (float)this.func_70068_e((Entity)target);
            if (distanceSq > 16.0f && distanceSq < data.rangedAttackMaxRange * data.rangedAttackMaxRange && this.func_70635_at().func_75522_a((Entity)target)) {
                new EntitySpecialFishHook(this.field_70170_p, (EntityLiving)this, (Entity)target);
                this.field_70170_p.func_72838_d((Entity)this.getFishHook());
                this.func_184185_a(SoundEvents.field_187612_G, 0.5f, 0.4f / (this.field_70146_Z.nextFloat() * 0.4f + 0.8f));
                this.rodTime = this.field_70146_Z.nextInt(Math.max(1, data.rangedAttackMaxCooldown - data.rangedAttackCooldown)) + data.rangedAttackCooldown;
            }
        }
    }

    @Override
    public void setFishHook(EntitySpecialFishHook hook) {
        this.fishHook = hook;
    }

    @Override
    public EntitySpecialFishHook getFishHook() {
        return this.fishHook;
    }

    @Override
    public boolean isLineOut() {
        return false;
    }
}

