/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.entity.ghast;

import fathertoast.specialmobs.ai.EntityAIFlyingAttackMelee;
import fathertoast.specialmobs.ai.EntityAIFlyingLookIdle;
import fathertoast.specialmobs.ai.EntityAIFlyingWander;
import fathertoast.specialmobs.ai.EntityMoveHelperFlying;
import fathertoast.specialmobs.bestiary.BestiaryInfo;
import fathertoast.specialmobs.entity.ISpecialMob;
import fathertoast.specialmobs.entity.MobHelper;
import fathertoast.specialmobs.entity.SpecialMobData;
import fathertoast.specialmobs.loot.LootTableBuilder;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityFlying;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFindEntityNearestPlayer;
import net.minecraft.entity.monster.EntityGhast;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityLargeFireball;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootTableList;

public class Entity_SpecialGhast
extends EntityGhast
implements ISpecialMob,
IRangedAttackMob {
    private static final int AI_PRIORITY_ATTACK = 4;
    private static final DataParameter<Float> SCALE = EntityDataManager.func_187226_a(Entity_SpecialGhast.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final ResourceLocation[] TEXTURES = new ResourceLocation[]{new ResourceLocation("textures/entity/ghast/ghast.png"), null, new ResourceLocation("textures/entity/ghast/ghast_shooting.png")};
    private EntityAIBase currentAttackAI;
    private SpecialMobData specialData;

    public static BestiaryInfo GET_BESTIARY_INFO() {
        BestiaryInfo info = new BestiaryInfo(0xBCBCBC);
        return info;
    }

    static String GET_TEXTURE_PATH(String type) {
        return "specialmobs:textures/entity/ghast/" + type + ".png";
    }

    static void ADD_BASE_LOOT(LootTableBuilder loot) {
        loot.addLootTable("main", "Base loot", LootTableList.field_186380_ae);
    }

    public Entity_SpecialGhast(World world) {
        super(world);
        this.field_70765_h = new EntityMoveHelperFlying((EntityFlying)this);
        this.getSpecialData().setImmuneToFire(true);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(5, new EntityAIFlyingWander<Entity_SpecialGhast>(this));
        this.field_70714_bg.func_75776_a(7, new EntityAIFlyingLookIdle<Entity_SpecialGhast>(this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIFindEntityNearestPlayer((EntityLiving)this));
        SpecialMobData data = this.getSpecialData();
        data.rangedAttackSpread = 0.0f;
        data.rangedAttackCooldown = 20;
        data.rangedAttackMaxCooldown = 60;
        data.rangedAttackMaxRange = 64.0f;
        this.initTypeAI();
        this.setCombatTask();
    }

    protected void initTypeAI() {
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.specialData = new SpecialMobData<Entity_SpecialGhast>(this, SCALE);
    }

    protected void disableRangedAI() {
        this.getSpecialData().rangedAttackMaxRange = 0.0f;
    }

    public void setCombatTask() {
        if (this.field_70170_p != null && !this.field_70170_p.field_72995_K) {
            this.field_70714_bg.func_85156_a(this.currentAttackAI);
            SpecialMobData data = this.getSpecialData();
            this.currentAttackAI = data.rangedAttackMaxRange > 0.0f ? new EntityAIBase(this) : new EntityAIFlyingAttackMelee<Entity_SpecialGhast>(this);
            this.field_70714_bg.func_75776_a(4, this.currentAttackAI);
        }
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e);
        this.applyAttributeAdjustments();
    }

    protected void adjustTypeAttributes() {
    }

    @Override
    public final SpecialMobData getSpecialData() {
        return this.specialData;
    }

    @Override
    public final void applyAttributeAdjustments() {
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(4.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.1);
        float prevMax = this.func_110138_aP();
        this.adjustTypeAttributes();
        this.func_70606_j(this.func_110138_aP() + this.func_110143_aJ() - prevMax);
    }

    @Override
    public final int getExperience() {
        return this.field_70728_aV;
    }

    @Override
    public final void setExperience(int xp) {
        this.field_70728_aV = xp;
    }

    @Override
    public final void setImmuneToFire(boolean immune) {
        this.field_70178_ae = immune;
    }

    @Override
    public ResourceLocation[] getDefaultTextures() {
        return TEXTURES;
    }

    protected void onTypeAttack(Entity target) {
    }

    public void func_82196_d(EntityLivingBase target, float distanceFactor) {
        this.field_70170_p.func_180498_a(null, 1016, new BlockPos((Entity)this), 0);
        Vec3d lookVec = this.func_70676_i(1.0f);
        double dX = target.field_70165_t - (this.field_70165_t + lookVec.field_72450_a * (double)this.field_70130_N);
        double dY = target.func_174813_aQ().field_72338_b + (double)(target.field_70131_O / 2.0f) - (0.5 + this.field_70163_u + (double)(this.field_70131_O / 2.0f));
        double dZ = target.field_70161_v - (this.field_70161_v + lookVec.field_72449_c * (double)this.field_70130_N);
        float accelVariance = MathHelper.func_76129_c((float)MathHelper.func_76133_a((double)this.func_70068_e((Entity)target))) * this.getSpecialData().rangedAttackSpread / 28.0f;
        EntityLargeFireball fireball = new EntityLargeFireball(this.field_70170_p, (EntityLivingBase)this, dX + this.func_70681_au().nextGaussian() * (double)accelVariance, dY, dZ + this.func_70681_au().nextGaussian() * (double)accelVariance);
        fireball.field_92057_e = this.func_175453_cd();
        fireball.field_70165_t = this.field_70165_t + lookVec.field_72450_a * (double)this.field_70130_N;
        fireball.field_70163_u = this.field_70163_u + (double)(this.field_70131_O / 2.0f) + 0.5;
        fireball.field_70161_v = this.field_70161_v + lookVec.field_72449_c * (double)this.field_70130_N;
        this.field_70170_p.func_72838_d((Entity)fireball);
    }

    public void func_184724_a(boolean swingingArms) {
        this.func_175454_a(swingingArms);
    }

    public void func_70636_d() {
        super.func_70636_d();
        this.getSpecialData().onUpdate();
    }

    public boolean func_70652_k(Entity target) {
        if (MobHelper.attackEntityAsMob((EntityLivingBase)this, target)) {
            this.onTypeAttack(target);
            return true;
        }
        return false;
    }

    public float func_70047_e() {
        return super.func_70047_e() * this.getSpecialData().getBaseScaleForPreScaledValues();
    }

    public void func_70014_b(NBTTagCompound tag) {
        super.func_70014_b(tag);
        NBTTagCompound saveTag = SpecialMobData.getSaveLocation(tag);
        this.getSpecialData().writeToNBT(saveTag);
    }

    public void func_70037_a(NBTTagCompound tag) {
        super.func_70037_a(tag);
        NBTTagCompound saveTag = SpecialMobData.getSaveLocation(tag);
        this.getSpecialData().readFromNBT(saveTag);
        this.setCombatTask();
    }

    public void func_70015_d(int time) {
        if (!this.getSpecialData().isImmuneToBurning()) {
            super.func_70015_d(time);
        }
    }

    public boolean func_184652_a(EntityPlayer player) {
        return !this.func_110167_bD() && this.getSpecialData().allowLeashing();
    }

    public void func_70110_aj() {
        if (!this.getSpecialData().isImmuneToWebs()) {
            super.func_70110_aj();
        }
    }

    public void func_180430_e(float distance, float damageMultiplier) {
        super.func_180430_e(distance, damageMultiplier * this.getSpecialData().getFallDamageMultiplier());
    }

    public boolean func_145773_az() {
        return this.getSpecialData().ignorePressurePlates();
    }

    public boolean func_70648_aU() {
        return this.getSpecialData().canBreatheInWater();
    }

    public boolean func_96092_aw() {
        return !this.getSpecialData().ignoreWaterPush();
    }

    public boolean func_70687_e(PotionEffect effect) {
        return this.getSpecialData().isPotionApplicable(effect);
    }
}

