/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.entity.creeper;

import fathertoast.specialmobs.bestiary.BestiaryInfo;
import fathertoast.specialmobs.entity.SpecialMobData;
import fathertoast.specialmobs.entity.creeper.EntityMiniCreeper;
import fathertoast.specialmobs.entity.creeper.Entity_SpecialCreeper;
import fathertoast.specialmobs.loot.LootTableBuilder;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemMonsterPlacer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class EntitySplittingCreeper
extends Entity_SpecialCreeper {
    private static final String TAG_BABIES = "ExtraBabies";
    private static final ResourceLocation[] TEXTURES = new ResourceLocation[]{new ResourceLocation(EntitySplittingCreeper.GET_TEXTURE_PATH("splitting")), new ResourceLocation(EntitySplittingCreeper.GET_TEXTURE_PATH("splitting_eyes"))};
    public static ResourceLocation LOOT_TABLE;
    private int extraBabies;

    public static BestiaryInfo GET_BESTIARY_INFO() {
        BestiaryInfo info = new BestiaryInfo(6266146);
        info.weight = 50;
        return info;
    }

    public static void BUILD_LOOT_TABLE(LootTableBuilder loot) {
        EntitySplittingCreeper.ADD_BASE_LOOT(loot);
        ResourceLocation name = EntityList.func_191306_a(EntityCreeper.class);
        ItemStack spawnEgg = new ItemStack(Items.field_151063_bx);
        ItemMonsterPlacer.func_185078_a((ItemStack)spawnEgg, (ResourceLocation)name);
        loot.addUncommonDrop("uncommon", "Spawn egg", spawnEgg);
    }

    public EntitySplittingCreeper(World world) {
        super(world);
    }

    @Override
    public ResourceLocation[] getDefaultTextures() {
        return TEXTURES;
    }

    protected ResourceLocation func_184647_J() {
        return LOOT_TABLE;
    }

    @Override
    protected void adjustTypeAttributes() {
        this.extraBabies = this.field_70146_Z.nextInt(4);
        this.field_70728_aV += 2;
        this.getSpecialData().addAttribute(SharedMonsterAttributes.field_111267_a, 20.0);
    }

    @Override
    protected void initTypeAI() {
        this.setExplodesWhenShot(true);
    }

    @Override
    public void explodeByType(boolean powered, boolean griefing) {
        float power = (float)this.field_82226_g * (powered ? 2.0f : 1.0f);
        this.field_70170_p.func_72876_a((Entity)this, this.field_70165_t, this.field_70163_u, this.field_70161_v, power - 1.0f, false);
        int babiesToSpawn = this.extraBabies + (int)(power * power) / 2;
        BlockPos pos = new BlockPos((Entity)this);
        for (int i = 0; i < babiesToSpawn; ++i) {
            EntityMiniCreeper baby = new EntityMiniCreeper(this.field_70170_p);
            baby.func_82149_j((Entity)this);
            baby.func_70624_b(this.func_70638_az());
            baby.func_180482_a(this.field_70170_p.func_175649_E(pos), null);
            baby.field_70159_w = (this.field_70146_Z.nextDouble() - 0.5) * (double)power / 3.0;
            baby.field_70181_x = 0.3 + 0.3 * this.field_70146_Z.nextDouble();
            baby.field_70179_y = (this.field_70146_Z.nextDouble() - 0.5) * (double)power / 3.0;
            baby.field_70122_E = false;
            if (powered && Entity_SpecialCreeper.POWERED != null) {
                baby.func_184212_Q().func_187227_b(Entity_SpecialCreeper.POWERED, (Object)true);
            }
            this.field_70170_p.func_72838_d((Entity)baby);
        }
        this.func_184185_a(SoundEvents.field_187511_aA, 1.0f, 2.0f / (this.field_70146_Z.nextFloat() * 0.4f + 0.8f));
    }

    @Override
    public void func_70014_b(NBTTagCompound tag) {
        super.func_70014_b(tag);
        NBTTagCompound saveTag = SpecialMobData.getSaveLocation(tag);
        saveTag.func_74774_a(TAG_BABIES, (byte)this.extraBabies);
    }

    @Override
    public void func_70037_a(NBTTagCompound tag) {
        super.func_70037_a(tag);
        NBTTagCompound saveTag = SpecialMobData.getSaveLocation(tag);
        if (saveTag.func_150297_b(TAG_BABIES, 99)) {
            this.extraBabies = saveTag.func_74771_c(TAG_BABIES);
        }
    }
}

