/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.entity.creeper;

import fathertoast.specialmobs.bestiary.BestiaryInfo;
import fathertoast.specialmobs.entity.creeper.Entity_SpecialCreeper;
import fathertoast.specialmobs.loot.LootTableBuilder;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityFallingBlock;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class EntityGravelCreeper
extends Entity_SpecialCreeper {
    private static final ResourceLocation[] TEXTURES = new ResourceLocation[]{new ResourceLocation(EntityGravelCreeper.GET_TEXTURE_PATH("gravel"))};
    public static ResourceLocation LOOT_TABLE;

    public static BestiaryInfo GET_BESTIARY_INFO() {
        BestiaryInfo info = new BestiaryInfo(9472132);
        return info;
    }

    public static void BUILD_LOOT_TABLE(LootTableBuilder loot) {
        EntityGravelCreeper.ADD_BASE_LOOT(loot);
        loot.addCommonDrop("common", "Gravel", Blocks.field_150351_n);
        loot.addUncommonDrop("uncommon", "Flint", Items.field_151145_ak);
    }

    public EntityGravelCreeper(World world) {
        super(world);
    }

    @Override
    public ResourceLocation[] getDefaultTextures() {
        return TEXTURES;
    }

    protected ResourceLocation func_184647_J() {
        return LOOT_TABLE;
    }

    @Override
    protected void adjustTypeAttributes() {
        ++this.field_70728_aV;
    }

    @Override
    public void explodeByType(boolean powered, boolean griefing) {
        float power = (float)this.field_82226_g / 2.0f * (powered ? 2.0f : 1.0f);
        this.field_70170_p.func_72876_a((Entity)this, this.field_70165_t, this.field_70163_u, this.field_70161_v, power, griefing);
        int count = (int)Math.ceil((power += 4.0f) * power * 3.5f);
        for (int i = 0; i < count; ++i) {
            EntityFallingBlock gravel = new EntityFallingBlock(this.field_70170_p, this.field_70165_t, this.field_70163_u + (double)(this.field_70131_O / 2.0f), this.field_70161_v, Blocks.field_150351_n.func_176223_P());
            gravel.field_145812_b = 1;
            gravel.field_145813_c = false;
            gravel.func_145806_a(true);
            gravel.field_70143_R = 3.0f;
            float speed = (power * 0.7f + this.field_70146_Z.nextFloat() * power) / 20.0f;
            float pitch = this.field_70146_Z.nextFloat() * (float)Math.PI;
            float yaw = this.field_70146_Z.nextFloat() * 2.0f * (float)Math.PI;
            gravel.field_70159_w = MathHelper.func_76134_b((float)yaw) * speed;
            gravel.field_70181_x = MathHelper.func_76126_a((float)pitch) * (power + this.field_70146_Z.nextFloat() * power) / 18.0f;
            gravel.field_70179_y = MathHelper.func_76126_a((float)yaw) * speed;
            this.field_70170_p.func_72838_d((Entity)gravel);
        }
    }

    @Override
    public boolean func_70097_a(DamageSource source, float amount) {
        if (source != null && (DamageSource.field_82729_p.func_76355_l().equals(source.func_76355_l()) || DamageSource.field_82728_o.func_76355_l().equals(source.func_76355_l()))) {
            return true;
        }
        return super.func_70097_a(source, amount);
    }
}

