/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.entity.creeper;

import fathertoast.specialmobs.bestiary.BestiaryInfo;
import fathertoast.specialmobs.config.EnvironmentListConfig;
import fathertoast.specialmobs.config.TargetEnvironment;
import fathertoast.specialmobs.entity.creeper.Entity_SpecialCreeper;
import fathertoast.specialmobs.loot.LootTableBuilder;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAICreeperSwell;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;
import net.minecraftforge.fml.common.eventhandler.Event;

public class EntityEnderCreeper
extends Entity_SpecialCreeper {
    private static final ResourceLocation[] TEXTURES = new ResourceLocation[]{new ResourceLocation(EntityEnderCreeper.GET_TEXTURE_PATH("ender")), new ResourceLocation(EntityEnderCreeper.GET_TEXTURE_PATH("ender_eyes"))};
    public static ResourceLocation LOOT_TABLE;

    public static BestiaryInfo GET_BESTIARY_INFO() {
        BestiaryInfo info = new BestiaryInfo(13369594);
        info.weight = 50;
        info.weightExceptions = new EnvironmentListConfig(new TargetEnvironment.TargetDimension(DimensionType.THE_END, 400.0f));
        return info;
    }

    public static void BUILD_LOOT_TABLE(LootTableBuilder loot) {
        EntityEnderCreeper.ADD_BASE_LOOT(loot);
        loot.addLootTable("common", "Enderman loot", LootTableList.field_186439_u);
    }

    public EntityEnderCreeper(World world) {
        super(world);
        this.getSpecialData().setDamagedByWater(true);
    }

    @Override
    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAICreeperSwell((EntityCreeper)this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)this, EntityOcelot.class, 6.0f, 1.0, 1.2));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, false));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 0.8));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAITargetBeholder(this));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.initTypeAI();
    }

    @Override
    public ResourceLocation[] getDefaultTextures() {
        return TEXTURES;
    }

    protected ResourceLocation func_184647_J() {
        return LOOT_TABLE;
    }

    @Override
    protected void adjustTypeAttributes() {
        this.field_70728_aV += 2;
        this.getSpecialData().addAttribute(SharedMonsterAttributes.field_111267_a, 20.0);
    }

    @Override
    protected void initTypeAI() {
        this.setCanNotExplodeWhenWet(true);
    }

    @Override
    public void func_70636_d() {
        if (this.field_70170_p.field_72995_K) {
            for (int i = 0; i < 2; ++i) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.PORTAL, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O - 0.25, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, (this.field_70146_Z.nextDouble() - 0.5) * 2.0, -this.field_70146_Z.nextDouble(), (this.field_70146_Z.nextDouble() - 0.5) * 2.0, new int[0]);
            }
        }
        super.func_70636_d();
    }

    @Override
    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        if (source instanceof EntityDamageSourceIndirect) {
            for (int i = 0; i < 64; ++i) {
                if (!this.teleportRandomly()) continue;
                return true;
            }
            return false;
        }
        boolean success = super.func_70097_a(source, amount);
        if (source.func_76363_c() && this.field_70146_Z.nextInt(10) != 0) {
            this.teleportRandomly();
        }
        return success;
    }

    private boolean shouldAttackPlayer(EntityPlayer player) {
        ItemStack hat = (ItemStack)player.field_71071_by.field_70460_b.get(3);
        if (!hat.func_190926_b() && hat.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150423_aK)) {
            return false;
        }
        Vec3d playerLookVec = player.func_70676_i(1.0f).func_72432_b();
        Vec3d playerToSelfVec = new Vec3d(this.field_70165_t - player.field_70165_t, this.func_174813_aQ().field_72338_b + (double)this.func_70047_e() - (player.field_70163_u + (double)player.func_70047_e()), this.field_70161_v - player.field_70161_v);
        double distance = playerToSelfVec.func_72433_c();
        return playerLookVec.func_72430_b(playerToSelfVec.func_72432_b()) > 1.0 - 0.025 / distance && player.func_70685_l((Entity)this);
    }

    private boolean teleportRandomly() {
        double targetX = this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * 64.0;
        double targetY = this.field_70163_u + (double)(this.field_70146_Z.nextInt(64) - 32);
        double targetZ = this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * 64.0;
        return this.teleportTo(targetX, targetY, targetZ);
    }

    private boolean teleportToEntity(Entity entity) {
        Vec3d vec3d = new Vec3d(this.field_70165_t - entity.field_70165_t, this.func_174813_aQ().field_72338_b + (double)(this.field_70131_O / 2.0f) - entity.field_70163_u + (double)entity.func_70047_e(), this.field_70161_v - entity.field_70161_v);
        vec3d = vec3d.func_72432_b();
        double targetX = this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * 8.0 - vec3d.field_72450_a * 16.0;
        double targetY = this.field_70163_u + (double)(this.field_70146_Z.nextInt(16) - 8) - vec3d.field_72448_b * 16.0;
        double targetZ = this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * 8.0 - vec3d.field_72449_c * 16.0;
        return this.teleportTo(targetX, targetY, targetZ);
    }

    private boolean teleportTo(double x, double y, double z) {
        EnderTeleportEvent event = new EnderTeleportEvent((EntityLivingBase)this, x, y, z, 0.0f);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return false;
        }
        boolean success = this.func_184595_k(event.getTargetX(), event.getTargetY(), event.getTargetZ());
        if (success) {
            this.field_70170_p.func_184148_a(null, this.field_70169_q, this.field_70167_r, this.field_70166_s, SoundEvents.field_187534_aX, this.func_184176_by(), 1.0f, 1.0f);
            this.func_184185_a(SoundEvents.field_187534_aX, 1.0f, 1.0f);
        }
        return success;
    }

    static class EntityAITargetBeholder
    extends EntityAINearestAttackableTarget<EntityPlayer> {
        private final EntityEnderCreeper enderCreeper;
        private EntityPlayer player;
        private int aggroTime;
        private int teleportTime;

        EntityAITargetBeholder(EntityEnderCreeper entity) {
            super((EntityCreature)entity, EntityPlayer.class, false);
            this.enderCreeper = entity;
        }

        public boolean func_75250_a() {
            double targetDistance = this.func_111175_f();
            this.player = this.enderCreeper.field_70170_p.func_184150_a(this.enderCreeper.field_70165_t, this.enderCreeper.field_70163_u, this.enderCreeper.field_70161_v, targetDistance, targetDistance, null, apply -> apply != null && this.enderCreeper.shouldAttackPlayer(apply));
            return this.player != null;
        }

        public void func_75249_e() {
            this.aggroTime = 5;
            this.teleportTime = 0;
        }

        public void func_75251_c() {
            this.player = null;
            super.func_75251_c();
        }

        public boolean func_75253_b() {
            if (this.player != null) {
                if (!this.enderCreeper.shouldAttackPlayer(this.player)) {
                    return false;
                }
                this.enderCreeper.func_70625_a((Entity)this.player, 10.0f, 10.0f);
                return true;
            }
            return this.field_75309_a != null && ((EntityPlayer)this.field_75309_a).func_70089_S() || super.func_75253_b();
        }

        public void func_75246_d() {
            if (this.player != null) {
                if (--this.aggroTime <= 0) {
                    this.field_75309_a = this.player;
                    this.player = null;
                    super.func_75249_e();
                }
            } else {
                if (this.field_75309_a != null) {
                    if (this.enderCreeper.shouldAttackPlayer((EntityPlayer)this.field_75309_a)) {
                        if (((EntityPlayer)this.field_75309_a).func_70068_e((Entity)this.enderCreeper) < 16.0) {
                            this.enderCreeper.teleportRandomly();
                        }
                        this.teleportTime = 0;
                    } else if (((EntityPlayer)this.field_75309_a).func_70068_e((Entity)this.enderCreeper) > 256.0 && this.teleportTime++ >= 30 && this.enderCreeper.teleportToEntity((Entity)this.field_75309_a)) {
                        this.teleportTime = 0;
                    }
                }
                super.func_75246_d();
            }
        }
    }
}

