/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.entity.blaze;

import fathertoast.specialmobs.bestiary.BestiaryInfo;
import fathertoast.specialmobs.entity.SpecialMobData;
import fathertoast.specialmobs.entity.blaze.EntityCinderBlaze;
import fathertoast.specialmobs.entity.blaze.Entity_SpecialBlaze;
import fathertoast.specialmobs.loot.LootTableBuilder;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.monster.EntityBlaze;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemMonsterPlacer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class EntityWildfireBlaze
extends Entity_SpecialBlaze {
    private static final String TAG_BABY_SPAWN_COUNT = "BabySpawnCount";
    private static final String TAG_BABY_DEATH_SPAWN = "BabiesOnDeath";
    private static final ResourceLocation[] TEXTURES = new ResourceLocation[]{new ResourceLocation(EntityWildfireBlaze.GET_TEXTURE_PATH("wildfire"))};
    public static ResourceLocation LOOT_TABLE;
    private int babySpawnCount;
    private int babyDeathSpawnCount;

    public static BestiaryInfo GET_BESTIARY_INFO() {
        BestiaryInfo info = new BestiaryInfo(16051762);
        return info;
    }

    public static void BUILD_LOOT_TABLE(LootTableBuilder loot) {
        EntityWildfireBlaze.ADD_BASE_LOOT(loot);
        loot.addCommonDrop("common", "Coal", Items.field_151044_h, 1);
        ResourceLocation name = EntityList.func_191306_a(EntityBlaze.class);
        ItemStack spawnEgg = new ItemStack(Items.field_151063_bx);
        ItemMonsterPlacer.func_185078_a((ItemStack)spawnEgg, (ResourceLocation)name);
        loot.addUncommonDrop("uncommon", "Spawn egg", spawnEgg);
    }

    public EntityWildfireBlaze(World world) {
        super(world);
        this.func_70105_a(0.9f, 2.7f);
        this.getSpecialData().setBaseScale(1.5f);
    }

    @Override
    public ResourceLocation[] getDefaultTextures() {
        return TEXTURES;
    }

    protected ResourceLocation func_184647_J() {
        return LOOT_TABLE;
    }

    @Override
    protected void adjustTypeAttributes() {
        this.babySpawnCount = this.field_70146_Z.nextInt(7) + 4;
        this.babyDeathSpawnCount = this.field_70146_Z.nextInt(4) + 3;
        this.field_70728_aV += 2;
        this.getSpecialData().setRegenerationTime(40);
        this.getSpecialData().addAttribute(SharedMonsterAttributes.field_111267_a, 20.0);
    }

    @Override
    protected void initTypeAI() {
        this.getSpecialData().rangedAttackSpread *= 0.1f;
        this.setRangedAI(1, 0, 30, 50, 20.0f);
    }

    @Override
    public void func_82196_d(EntityLivingBase target, float distanceFactor) {
        if (this.babySpawnCount > 0 && this.field_70146_Z.nextInt(2) == 0) {
            --this.babySpawnCount;
            EntityCinderBlaze baby = new EntityCinderBlaze(this.field_70170_p);
            baby.func_82149_j((Entity)this);
            baby.func_70624_b(this.func_70638_az());
            baby.func_180482_a(this.field_70170_p.func_175649_E(new BlockPos((Entity)this)), null);
            double vX = target.field_70165_t - this.field_70165_t;
            double vZ = target.field_70161_v - this.field_70161_v;
            double vH = Math.sqrt(vX * vX + vZ * vZ);
            baby.field_70159_w = vX / vH * 0.8 + this.field_70159_w * 0.2;
            baby.field_70179_y = vZ / vH * 0.8 + this.field_70179_y * 0.2;
            baby.field_70122_E = false;
            this.field_70170_p.func_72838_d((Entity)baby);
            this.func_184185_a(SoundEvents.field_187606_E, 1.0f, 2.0f / (this.field_70146_Z.nextFloat() * 0.4f + 0.8f));
            baby.func_70656_aK();
        } else {
            super.func_82196_d(target, distanceFactor);
        }
    }

    @Override
    protected void onTypeAttack(Entity target) {
        target.func_70015_d(8);
    }

    public void func_70645_a(DamageSource cause) {
        if (!this.field_70729_aU && !this.field_70170_p.field_72995_K) {
            BlockPos pos = new BlockPos((Entity)this);
            for (int i = 0; i < this.babyDeathSpawnCount; ++i) {
                EntityCinderBlaze baby = new EntityCinderBlaze(this.field_70170_p);
                baby.func_82149_j((Entity)this);
                baby.func_70624_b(this.func_70638_az());
                baby.func_180482_a(this.field_70170_p.func_175649_E(pos), null);
                baby.field_70159_w = (this.field_70146_Z.nextDouble() - 0.5) * 0.3;
                baby.field_70179_y = (this.field_70146_Z.nextDouble() - 0.5) * 0.3;
                this.field_70170_p.func_72838_d((Entity)baby);
            }
            this.func_70656_aK();
            this.func_184185_a(SoundEvents.field_187606_E, 1.0f, 2.0f / (this.field_70146_Z.nextFloat() * 0.4f + 0.8f));
        }
        super.func_70645_a(cause);
    }

    @Override
    public void func_70014_b(NBTTagCompound tag) {
        super.func_70014_b(tag);
        NBTTagCompound saveTag = SpecialMobData.getSaveLocation(tag);
        saveTag.func_74768_a(TAG_BABY_SPAWN_COUNT, this.babySpawnCount);
        saveTag.func_74768_a(TAG_BABY_DEATH_SPAWN, this.babyDeathSpawnCount);
    }

    @Override
    public void func_70037_a(NBTTagCompound tag) {
        super.func_70037_a(tag);
        NBTTagCompound saveTag = SpecialMobData.getSaveLocation(tag);
        if (saveTag.func_150297_b(TAG_BABY_SPAWN_COUNT, 99)) {
            this.babySpawnCount = saveTag.func_74762_e(TAG_BABY_SPAWN_COUNT);
        }
        if (saveTag.func_150297_b(TAG_BABY_DEATH_SPAWN, 99)) {
            this.babyDeathSpawnCount = saveTag.func_74762_e(TAG_BABY_DEATH_SPAWN);
        }
    }
}

