/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.entity.blaze;

import fathertoast.specialmobs.bestiary.BestiaryInfo;
import fathertoast.specialmobs.entity.SpecialMobData;
import fathertoast.specialmobs.entity.blaze.Entity_SpecialBlaze;
import fathertoast.specialmobs.loot.LootTableBuilder;
import java.util.Collections;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.projectile.EntitySnowball;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class EntityConflagrationBlaze
extends Entity_SpecialBlaze {
    private static final String TAG_FEEDING_LEVEL = "FeedLevel";
    private static final ResourceLocation[] TEXTURES = new ResourceLocation[]{new ResourceLocation(EntityConflagrationBlaze.GET_TEXTURE_PATH("conflagration"))};
    public static ResourceLocation LOOT_TABLE;
    private byte feedingLevel = 0;

    public static BestiaryInfo GET_BESTIARY_INFO() {
        BestiaryInfo info = new BestiaryInfo(16775294);
        return info;
    }

    public static void BUILD_LOOT_TABLE(LootTableBuilder loot) {
        EntityConflagrationBlaze.ADD_BASE_LOOT(loot);
        loot.addCommonDrop("common", "Fire charges", Items.field_151059_bz);
        ItemStack potion = PotionUtils.func_185184_a((ItemStack)new ItemStack((Item)Items.field_151068_bn), Collections.singletonList(new PotionEffect(MobEffects.field_76426_n, 160)));
        loot.addRareDrop("rare", "Fire resist potion", potion);
    }

    public EntityConflagrationBlaze(World world) {
        super(world);
    }

    @Override
    public ResourceLocation[] getDefaultTextures() {
        return TEXTURES;
    }

    protected ResourceLocation func_184647_J() {
        return LOOT_TABLE;
    }

    @Override
    protected void adjustTypeAttributes() {
        this.field_70728_aV += 4;
    }

    public boolean func_70097_a(DamageSource damageSource, float damage) {
        if (!(damageSource.func_76347_k() || damageSource.func_94541_c() || damageSource.func_82725_o() || DamageSource.field_76369_e.field_76373_n.equals(damageSource.field_76373_n) || damageSource.func_76364_f() instanceof EntitySnowball)) {
            damage = Math.min(1.0f, damage);
            if (!this.field_70170_p.field_72995_K && this.feedingLevel < 7) {
                this.feedingLevel = (byte)(this.feedingLevel + 1);
                SpecialMobData data = this.getSpecialData();
                data.addAttribute(SharedMonsterAttributes.field_111264_e, 1.0);
                data.rangedAttackDamage += 0.5f;
                data.rangedAttackCooldown -= 4;
                data.rangedAttackMaxCooldown -= 4;
                if (this.feedingLevel == 7) {
                    ++this.fireballBurstCount;
                }
            }
        }
        return super.func_70097_a(damageSource, damage);
    }

    @Override
    public void func_70014_b(NBTTagCompound tag) {
        super.func_70014_b(tag);
        NBTTagCompound saveTag = SpecialMobData.getSaveLocation(tag);
        saveTag.func_74774_a(TAG_FEEDING_LEVEL, this.feedingLevel);
    }

    @Override
    public void func_70037_a(NBTTagCompound tag) {
        super.func_70037_a(tag);
        NBTTagCompound saveTag = SpecialMobData.getSaveLocation(tag);
        if (saveTag.func_150297_b(TAG_FEEDING_LEVEL, 99)) {
            this.feedingLevel = saveTag.func_74771_c(TAG_FEEDING_LEVEL);
        }
    }
}

