/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs;

import fathertoast.specialmobs.SpecialMobsMod;
import fathertoast.specialmobs.entity.ISpecialMob;
import fathertoast.specialmobs.entity.SpecialMobData;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.Entity;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class MessageTexture
implements IMessage {
    private static final int TEXTURE_COUNT = 3;
    private int entityId;
    private String[] texturePaths;

    public MessageTexture() {
    }

    public MessageTexture(Entity entity) {
        this.entityId = entity.func_145782_y();
        SpecialMobData data = ((ISpecialMob)entity).getSpecialData();
        this.texturePaths = new String[]{data.getTexture().toString(), data.getTextureEyes() == null ? "" : data.getTextureEyes().toString(), data.getTextureOverlay() == null ? "" : data.getTextureOverlay().toString()};
    }

    public void fromBytes(ByteBuf buf) {
        this.entityId = buf.readInt();
        this.texturePaths = new String[3];
        for (int i = 0; i < 3; ++i) {
            StringBuffer path = new StringBuffer();
            short len = buf.readShort();
            for (short c = 0; c < len; c = (short)(c + 1)) {
                path.append(buf.readChar());
            }
            this.texturePaths[i] = path.toString();
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.entityId);
        for (int i = 0; i < 3; ++i) {
            char[] path = this.texturePaths[i].toCharArray();
            buf.writeShort(path.length);
            for (char c : path) {
                buf.writeChar((int)c);
            }
        }
    }

    public static class Handler
    implements IMessageHandler<MessageTexture, IMessage> {
        public IMessage onMessage(MessageTexture message, MessageContext ctx) {
            try {
                WorldClient world = FMLClientHandler.instance().getWorldClient();
                ISpecialMob mob = (ISpecialMob)world.func_73045_a(message.entityId);
                if (mob != null) {
                    SpecialMobData data = mob.getSpecialData();
                    data.loadTextures(message.texturePaths);
                }
            }
            catch (Exception ex) {
                SpecialMobsMod.log().error("Failed to fetch mob texture from server for Entity:{}[{}]", (Object)message.entityId, (Object)message.texturePaths, (Object)ex);
            }
            return null;
        }
    }
}

