/*
 * Decompiled with CFR 0.152.
 */
package knightminer.ceramics.network;

import io.netty.buffer.ByteBuf;
import knightminer.ceramics.library.tank.IFluidUpdateReciever;
import knightminer.ceramics.network.PacketBase;
import net.minecraft.client.Minecraft;
import net.minecraft.client.network.NetHandlerPlayClient;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.network.ByteBufUtils;

public class FluidUpdatePacket
extends PacketBase {
    private BlockPos pos;
    private FluidStack fluid;

    public FluidUpdatePacket() {
    }

    public FluidUpdatePacket(BlockPos pos, FluidStack fluid) {
        this.pos = pos;
        this.fluid = fluid;
    }

    public void fromBytes(ByteBuf buf) {
        this.pos = FluidUpdatePacket.readPos(buf);
        NBTTagCompound tag = ByteBufUtils.readTag((ByteBuf)buf);
        this.fluid = FluidStack.loadFluidStackFromNBT((NBTTagCompound)tag);
    }

    public void toBytes(ByteBuf buf) {
        FluidUpdatePacket.writePos(this.pos, buf);
        NBTTagCompound tag = new NBTTagCompound();
        if (this.fluid != null) {
            this.fluid.writeToNBT(tag);
        }
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)tag);
    }

    @Override
    public void handleClient(NetHandlerPlayClient handler) {
        TileEntity te = Minecraft.func_71410_x().field_71441_e.func_175625_s(this.pos);
        if (te instanceof IFluidUpdateReciever) {
            ((IFluidUpdateReciever)te).updateFluidTo(this.fluid);
        }
    }
}

