/*
 * Decompiled with CFR 0.152.
 */
package knightminer.ceramics.blocks;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import knightminer.ceramics.Ceramics;
import knightminer.ceramics.blocks.BlockBarrel;
import knightminer.ceramics.library.Config;
import knightminer.ceramics.library.IFaucetDepthFallback;
import knightminer.ceramics.library.Util;
import knightminer.ceramics.tileentity.TileChannel;
import net.minecraft.block.Block;
import net.minecraft.block.BlockButton;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.BlockFence;
import net.minecraft.block.BlockLever;
import net.minecraft.block.BlockPane;
import net.minecraft.block.BlockWall;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Optional;
import slimeknights.tconstruct.library.smeltery.IFaucetDepth;

@Optional.Interface(iface="slimeknights.tconstruct.library.smeltery.IFaucetDepth", modid="tconstruct")
public class BlockChannel
extends BlockContainer
implements IFaucetDepth,
IFaucetDepthFallback {
    public static final PropertyBool DOWN = PropertyBool.func_177716_a((String)"down");
    public static final PropertyEnum<ChannelConnectionState> NORTH = PropertyEnum.func_177709_a((String)"north", ChannelConnectionState.class);
    public static final PropertyEnum<ChannelConnectionState> SOUTH = PropertyEnum.func_177709_a((String)"south", ChannelConnectionState.class);
    public static final PropertyEnum<ChannelConnectionState> WEST = PropertyEnum.func_177709_a((String)"west", ChannelConnectionState.class);
    public static final PropertyEnum<ChannelConnectionState> EAST = PropertyEnum.func_177709_a((String)"east", ChannelConnectionState.class);
    private static final AxisAlignedBB BOUNDS_CENTER = new AxisAlignedBB(0.3125, 0.125, 0.3125, 0.6875, 0.5, 0.6875);
    private static final AxisAlignedBB BOUNDS_CENTER_UNCONNECTED = new AxisAlignedBB(0.3125, 0.25, 0.3125, 0.6875, 0.5, 0.6875);
    private static final AxisAlignedBB BOUNDS_NORTH = new AxisAlignedBB(0.3125, 0.25, 0.0, 0.6875, 0.5, 0.3125);
    private static final AxisAlignedBB BOUNDS_SOUTH = new AxisAlignedBB(0.3125, 0.25, 0.6875, 0.6875, 0.5, 1.0);
    private static final AxisAlignedBB BOUNDS_WEST = new AxisAlignedBB(0.0, 0.25, 0.3125, 0.3125, 0.5, 0.6875);
    private static final AxisAlignedBB BOUNDS_EAST = new AxisAlignedBB(0.6875, 0.25, 0.3125, 1.0, 0.5, 0.6875);
    private static final AxisAlignedBB[] BOUNDS = new AxisAlignedBB[]{BOUNDS_CENTER, new AxisAlignedBB(0.3125, 0.125, 0.3125, 1.0, 0.5, 0.6875), new AxisAlignedBB(0.0, 0.125, 0.3125, 0.6875, 0.5, 0.6875), new AxisAlignedBB(0.0, 0.125, 0.3125, 1.0, 0.5, 0.6875), new AxisAlignedBB(0.3125, 0.125, 0.3125, 0.6875, 0.5, 1.0), new AxisAlignedBB(0.3125, 0.125, 0.3125, 1.0, 0.5, 1.0), new AxisAlignedBB(0.0, 0.125, 0.3125, 0.6875, 0.5, 1.0), new AxisAlignedBB(0.0, 0.125, 0.3125, 1.0, 0.5, 1.0), new AxisAlignedBB(0.3125, 0.125, 0.0, 0.6875, 0.5, 0.6875), new AxisAlignedBB(0.3125, 0.125, 0.0, 1.0, 0.5, 0.6875), new AxisAlignedBB(0.0, 0.125, 0.0, 0.6875, 0.5, 0.6875), new AxisAlignedBB(0.0, 0.125, 0.0, 1.0, 0.5, 0.6875), new AxisAlignedBB(0.3125, 0.125, 0.0, 0.6875, 0.5, 1.0), new AxisAlignedBB(0.3125, 0.125, 0.0, 1.0, 0.5, 1.0), new AxisAlignedBB(0.0, 0.125, 0.0, 0.6875, 0.5, 1.0), new AxisAlignedBB(0.0, 0.125, 0.0, 1.0, 0.5, 1.0)};

    public BlockChannel() {
        super(Material.field_151576_e);
        this.func_149647_a(Ceramics.tab);
        this.func_149711_c(3.0f);
        this.func_149752_b(20.0f);
        this.func_149672_a(SoundType.field_185852_e);
        this.func_180632_j(this.func_176223_P().func_177226_a((IProperty)DOWN, (Comparable)Boolean.valueOf(false)).func_177226_a(NORTH, (Comparable)((Object)ChannelConnectionState.NONE)).func_177226_a(SOUTH, (Comparable)((Object)ChannelConnectionState.NONE)).func_177226_a(WEST, (Comparable)((Object)ChannelConnectionState.NONE)).func_177226_a(EAST, (Comparable)((Object)ChannelConnectionState.NONE)));
    }

    @Nonnull
    public TileEntity func_149915_a(@Nonnull World worldIn, int meta) {
        return new TileChannel();
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{DOWN, NORTH, SOUTH, WEST, EAST});
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block oldBlock, BlockPos neighbor) {
        if (world.field_72995_K) {
            return;
        }
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileChannel) {
            ((TileChannel)te).handleBlockUpdate(neighbor, oldBlock == Blocks.field_150350_a, world.func_175640_z(pos));
        }
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (player.func_184586_b(hand).func_77973_b() == Item.func_150898_a((Block)Ceramics.channel) && facing != EnumFacing.UP) {
            return false;
        }
        TileEntity te = worldIn.func_175625_s(pos);
        if (te instanceof TileChannel) {
            EnumFacing side;
            EnumFacing enumFacing = side = facing == null || facing == EnumFacing.UP ? EnumFacing.DOWN : facing;
            if (Util.clickAABB(BOUNDS_NORTH, hitX, hitY, hitZ)) {
                side = EnumFacing.NORTH;
            } else if (Util.clickAABB(BOUNDS_SOUTH, hitX, hitY, hitZ)) {
                side = EnumFacing.SOUTH;
            } else if (Util.clickAABB(BOUNDS_WEST, hitX, hitY, hitZ)) {
                side = EnumFacing.WEST;
            } else if (Util.clickAABB(BOUNDS_EAST, hitX, hitY, hitZ)) {
                side = EnumFacing.EAST;
            }
            return ((TileChannel)te).interact(player, side);
        }
        return super.func_180639_a(worldIn, pos, state, player, hand, facing, hitX, hitY, hitZ);
    }

    @Deprecated
    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        state = this.addTEData(state, world, pos);
        state = this.addExtra(state, world, pos, NORTH, EnumFacing.NORTH);
        state = this.addExtra(state, world, pos, SOUTH, EnumFacing.SOUTH);
        state = this.addExtra(state, world, pos, WEST, EnumFacing.WEST);
        state = this.addExtra(state, world, pos, EAST, EnumFacing.EAST);
        return state;
    }

    private IBlockState addExtra(IBlockState state, IBlockAccess world, BlockPos pos, PropertyEnum<ChannelConnectionState> prop, EnumFacing side) {
        ChannelConnectionState connection = (ChannelConnectionState)((Object)state.func_177229_b(prop));
        IBlockState offsetState = world.func_180495_p(pos.func_177972_a(side));
        Block block = offsetState.func_177230_c();
        if (connection == ChannelConnectionState.OUT && block instanceof BlockBarrel) {
            state = state.func_177226_a(prop, (Comparable)((Object)ChannelConnectionState.BARREL));
        } else if (connection == ChannelConnectionState.NONE && (block instanceof BlockLever && ((BlockLever.EnumOrientation)offsetState.func_177229_b((IProperty)BlockLever.field_176360_a)).func_176852_c() == side || block instanceof BlockButton && offsetState.func_177229_b((IProperty)BlockButton.field_176387_N) == side)) {
            state = state.func_177226_a(prop, (Comparable)((Object)ChannelConnectionState.LEVER));
        }
        return state;
    }

    protected IBlockState addTEData(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (!(te instanceof TileChannel)) {
            return state;
        }
        TileChannel channel = (TileChannel)te;
        return state.func_177226_a((IProperty)DOWN, (Comparable)Boolean.valueOf(channel.isConnectedDown())).func_177226_a(NORTH, (Comparable)((Object)ChannelConnectionState.fromConnection(channel.getConnection(EnumFacing.NORTH)))).func_177226_a(SOUTH, (Comparable)((Object)ChannelConnectionState.fromConnection(channel.getConnection(EnumFacing.SOUTH)))).func_177226_a(WEST, (Comparable)((Object)ChannelConnectionState.fromConnection(channel.getConnection(EnumFacing.WEST)))).func_177226_a(EAST, (Comparable)((Object)ChannelConnectionState.fromConnection(channel.getConnection(EnumFacing.EAST))));
    }

    @Nonnull
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        int index = (((ChannelConnectionState)((Object)(state = state.func_185899_b(source, pos)).func_177229_b(NORTH))).canFlow() ? 8 : 0) + (((ChannelConnectionState)((Object)state.func_177229_b(SOUTH))).canFlow() ? 4 : 0) + (((ChannelConnectionState)((Object)state.func_177229_b(WEST))).canFlow() ? 2 : 0) + (((ChannelConnectionState)((Object)state.func_177229_b(EAST))).canFlow() ? 1 : 0);
        return BOUNDS[index];
    }

    public void func_185477_a(IBlockState state, World world, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entity, boolean p_185477_7_) {
        if (((Boolean)(state = state.func_185899_b((IBlockAccess)world, pos)).func_177229_b((IProperty)DOWN)).booleanValue()) {
            BlockChannel.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)BOUNDS_CENTER);
        } else {
            BlockChannel.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)BOUNDS_CENTER_UNCONNECTED);
        }
        if (((ChannelConnectionState)((Object)state.func_177229_b(NORTH))).canFlow()) {
            BlockChannel.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)BOUNDS_NORTH);
        }
        if (((ChannelConnectionState)((Object)state.func_177229_b(SOUTH))).canFlow()) {
            BlockChannel.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)BOUNDS_SOUTH);
        }
        if (((ChannelConnectionState)((Object)state.func_177229_b(WEST))).canFlow()) {
            BlockChannel.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)BOUNDS_WEST);
        }
        if (((ChannelConnectionState)((Object)state.func_177229_b(EAST))).canFlow()) {
            BlockChannel.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)BOUNDS_EAST);
        }
    }

    @Deprecated
    public RayTraceResult func_180636_a(IBlockState state, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull Vec3d start, @Nonnull Vec3d end) {
        state = state.func_185899_b((IBlockAccess)world, pos);
        ArrayList<RayTraceResult> list = new ArrayList<RayTraceResult>(5);
        list.add(this.func_185503_a(pos, start, end, BOUNDS_CENTER));
        if (((ChannelConnectionState)((Object)state.func_177229_b(NORTH))).canFlow()) {
            list.add(this.func_185503_a(pos, start, end, BOUNDS_NORTH));
        }
        if (((ChannelConnectionState)((Object)state.func_177229_b(SOUTH))).canFlow()) {
            list.add(this.func_185503_a(pos, start, end, BOUNDS_SOUTH));
        }
        if (((ChannelConnectionState)((Object)state.func_177229_b(WEST))).canFlow()) {
            list.add(this.func_185503_a(pos, start, end, BOUNDS_WEST));
        }
        if (((ChannelConnectionState)((Object)state.func_177229_b(EAST))).canFlow()) {
            list.add(this.func_185503_a(pos, start, end, BOUNDS_EAST));
        }
        RayTraceResult result = null;
        double max = 0.0;
        for (RayTraceResult raytraceresult : list) {
            double distance;
            if (raytraceresult == null || !((distance = raytraceresult.field_72307_f.func_72436_e(end)) > max)) continue;
            result = raytraceresult;
            max = distance;
        }
        return result;
    }

    @Nonnull
    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    @Deprecated
    public BlockFaceShape func_193383_a(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing side) {
        if (side.func_176740_k() == EnumFacing.Axis.Y) {
            return BlockFaceShape.UNDEFINED;
        }
        IBlockState offsetState = world.func_180495_p(pos.func_177972_a(side));
        Block block = offsetState.func_177230_c();
        return block instanceof BlockWall || block instanceof BlockFence || block instanceof BlockPane ? BlockFaceShape.UNDEFINED : BlockFaceShape.SOLID;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @Override
    public float getFlowDepth(World world, BlockPos pos, IBlockState state) {
        return 0.53125f;
    }

    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        if (Config.faucetEnabled) {
            list.add((Object)new ItemStack((Block)this));
        }
    }

    public static enum ChannelConnectionState implements IStringSerializable
    {
        NONE,
        IN,
        OUT,
        BARREL,
        LEVER;

        byte index = (byte)this.ordinal();

        public static ChannelConnectionState fromConnection(TileChannel.ChannelConnection connection) {
            return ChannelConnectionState.values()[connection.getIndex()];
        }

        public String func_176610_l() {
            return this.toString().toLowerCase(Locale.US);
        }

        public boolean canFlow() {
            return this != NONE;
        }
    }
}

