/*
 * Decompiled with CFR 0.152.
 */
package fionathemortal.betterbiomeblend.mixin;

import fionathemortal.betterbiomeblend.client.BiomeColor;
import fionathemortal.betterbiomeblend.client.ColorChunk;
import fionathemortal.betterbiomeblend.client.ColorChunkCache;
import fionathemortal.betterbiomeblend.client.ColorResolverCompatibility;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.biome.BiomeColorHelper;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;

@Mixin(value={BiomeColorHelper.class})
public abstract class MixinBiomeColorHelper {
    @Overwrite
    public static int func_180285_a(IBlockAccess blockAccess, BlockPos pos, BiomeColorHelper.ColorResolver colorResolver) {
        int x = pos.func_177958_n();
        int z = pos.func_177952_p();
        int chunkX = x >> 4;
        int chunkZ = z >> 4;
        int colorResolverID = ColorResolverCompatibility.getColorResolverID(colorResolver);
        ThreadLocal<ColorChunk> threadLocal = BiomeColor.getThreadLocalGenericChunkWrapper(blockAccess);
        ColorChunk chunk = BiomeColor.getThreadLocalChunk(threadLocal, chunkX, chunkZ, colorResolverID);
        if (chunk == null) {
            ColorChunkCache cache = BiomeColor.getColorChunkCacheForIBlockAccess(blockAccess);
            chunk = BiomeColor.getBlendedColorChunk(cache, blockAccess, colorResolverID, chunkX, chunkZ, colorResolver);
            BiomeColor.setThreadLocalChunk(threadLocal, chunk, cache);
        }
        return chunk.getColor(x, z);
    }

    @Overwrite
    public static int func_180286_a(IBlockAccess blockAccess, BlockPos pos) {
        int x = pos.func_177958_n();
        int z = pos.func_177952_p();
        int chunkX = x >> 4;
        int chunkZ = z >> 4;
        ThreadLocal<ColorChunk> threadLocal = BiomeColor.getThreadLocalGrassChunkWrapper(blockAccess);
        ColorChunk chunk = BiomeColor.getThreadLocalChunk(threadLocal, chunkX, chunkZ, 0);
        if (chunk == null) {
            ColorChunkCache cache = BiomeColor.getColorChunkCacheForIBlockAccess(blockAccess);
            chunk = BiomeColor.getBlendedColorChunk(cache, blockAccess, 0, chunkX, chunkZ, BiomeColorHelper.field_180291_a);
            BiomeColor.setThreadLocalChunk(threadLocal, chunk, cache);
        }
        return chunk.getColor(x, z);
    }

    @Overwrite
    public static int func_180287_b(IBlockAccess blockAccess, BlockPos pos) {
        int x = pos.func_177958_n();
        int z = pos.func_177952_p();
        int chunkX = x >> 4;
        int chunkZ = z >> 4;
        ThreadLocal<ColorChunk> threadLocal = BiomeColor.getThreadLocalFoliageChunkWrapper(blockAccess);
        ColorChunk chunk = BiomeColor.getThreadLocalChunk(threadLocal, chunkX, chunkZ, 2);
        if (chunk == null) {
            ColorChunkCache cache = BiomeColor.getColorChunkCacheForIBlockAccess(blockAccess);
            chunk = BiomeColor.getBlendedColorChunk(cache, blockAccess, 2, chunkX, chunkZ, BiomeColorHelper.field_180289_b);
            BiomeColor.setThreadLocalChunk(threadLocal, chunk, cache);
        }
        return chunk.getColor(x, z);
    }

    @Overwrite
    public static int func_180288_c(IBlockAccess blockAccess, BlockPos pos) {
        int x = pos.func_177958_n();
        int z = pos.func_177952_p();
        int chunkX = x >> 4;
        int chunkZ = z >> 4;
        ThreadLocal<ColorChunk> threadLocal = BiomeColor.getThreadLocalWaterChunkWrapper(blockAccess);
        ColorChunk chunk = BiomeColor.getThreadLocalChunk(threadLocal, chunkX, chunkZ, 1);
        if (chunk == null) {
            ColorChunkCache cache = BiomeColor.getColorChunkCacheForIBlockAccess(blockAccess);
            chunk = BiomeColor.getBlendedColorChunk(cache, blockAccess, 1, chunkX, chunkZ, BiomeColorHelper.field_180290_c);
            BiomeColor.setThreadLocalChunk(threadLocal, chunk, cache);
        }
        return chunk.getColor(x, z);
    }
}

