/*
 * Decompiled with CFR 0.152.
 */
package net.soggymustache.butterflies.util;

import com.google.common.collect.Lists;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.soggymustache.butterflies.client.render.RenderButterfly;
import net.soggymustache.butterflies.entity.EntityButterfly;
import net.soggymustache.butterflies.util.ButterflyInfo;
import net.soggymustache.butterflies.util.ButterflyType;
import net.soggymustache.butterflies.util.ColorUtilities;
import net.soggymustache.butterflies.util.IButterflyRenderer;

public class NameUtilities {
    public static List<String> pre;
    public static List<String> middle;
    public static final Random RANDOM;
    private static Map<Integer, ButterflyInfo> butterflies;
    private static int nextID;
    private static int[] IDS;

    public static Map<Integer, ButterflyInfo> getInfo() {
        return butterflies;
    }

    public static void addButterfly(ButterflyInfo info) {
        butterflies.put(nextID++, info);
    }

    public static void generateStats(EntityButterfly butterfly, EnumDyeColor colour) {
        if (RANDOM.nextInt(40) == 0) {
            int selection = IDS[RANDOM.nextInt(IDS.length)];
            ButterflyInfo info = butterflies.get(selection);
            butterfly.setBName(info.NAME);
            butterfly.setRarity(info.BRARITY);
            butterfly.setExtra(selection);
            if (info.colors != null) {
                butterfly.setRed(info.colors[0]);
                butterfly.setGreen(info.colors[1]);
                butterfly.setBlue(info.colors[2]);
            } else {
                Float[] col = ColorUtilities.generateColor(butterfly.getEColor());
                butterfly.setRed(col[0].floatValue());
                butterfly.setGreen(col[1].floatValue());
                butterfly.setBlue(col[2].floatValue());
            }
        } else {
            String name = "";
            float rarity = 0.0f;
            if (RANDOM.nextInt(pre.size() * 2) == 0) {
                name = name + pre.get(RANDOM.nextInt(pre.size()));
                rarity += 0.2f;
            }
            if (colour != null) {
                if (colour == EnumDyeColor.BLACK) {
                    colour = EnumDyeColor.WHITE;
                }
                name = name + " ";
                name = colour == EnumDyeColor.LIGHT_BLUE ? name + "Light Blue" : name + NameUtilities.fix(colour.func_176762_d().replaceAll("_", " "));
                rarity += (float)colour.func_176765_a() * 0.1f;
            }
            if (RANDOM.nextInt(middle.size() + 3) != 0) {
                name = name + " ";
                name = name + middle.get(RANDOM.nextInt(middle.size()));
                rarity += 0.1f;
            } else {
                rarity += 0.3f;
            }
            name = name + " ";
            ButterflyType type = ButterflyType.values()[RANDOM.nextInt(ButterflyType.values().length)];
            name = name + type.name;
            butterfly.setExtra(type.id);
            rarity += 0.1f;
            if (name.isEmpty() || name.length() <= 10) {
                name = "Undiscovered Majestic Something";
                rarity += 10.0f;
            }
            name = name.trim().replaceAll(" ", "_").replaceAll("_", " ");
            rarity = (float)Math.min((double)Math.round((double)rarity * 100.0) / 100.0, 10.0);
            butterfly.setBName(name);
            butterfly.setRarity(rarity);
            Float[] col = ColorUtilities.generateColor(butterfly.getEColor());
            butterfly.setRed(col[0].floatValue());
            butterfly.setGreen(col[1].floatValue());
            butterfly.setBlue(col[2].floatValue());
        }
    }

    public static String fix(String input) {
        StringBuilder titleCase = new StringBuilder();
        boolean n = true;
        for (char c : input.toCharArray()) {
            if (Character.isSpaceChar(c)) {
                n = true;
            } else if (n) {
                c = Character.toTitleCase(c);
                n = false;
            }
            titleCase.append(c);
        }
        return titleCase.toString();
    }

    static {
        RANDOM = new Random();
        nextID = 0;
        butterflies = new HashMap<Integer, ButterflyInfo>();
        middle = Lists.newArrayList();
        pre = Lists.newArrayList();
        pre.add("Rare");
        pre.add("Common");
        pre.add("Undiscovered");
        middle.add("Eastern");
        middle.add("Western");
        middle.add("Northern");
        middle.add("Old");
        middle.add("Mourning");
        middle.add("Pipevine");
        middle.add("Strange");
        nextID = ButterflyType.values().length;
        NameUtilities.addButterfly(new ButterflyInfo("Menelaus Blue Morpho Butterfly", 10.0f, 0.18f, 0.502f, 0.671f));
        NameUtilities.addButterfly(new ButterflyInfo("Erose's Butterfly", 10.0f, 0.875f, 0.592f, 0.824f));
        ButterflyInfo glasswing = new ButterflyInfo("Glasswing Butterfly", 10.0f){

            @Override
            @SideOnly(value=Side.CLIENT)
            public void render(ModelBase model, IButterflyRenderer render, EntityButterfly e, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
                GlStateManager.func_179094_E();
                GlStateManager.func_179141_d();
                GlStateManager.func_179147_l();
                GlStateManager.func_179131_c((float)e.getRed(), (float)e.getGreen(), (float)e.getBlue(), (float)0.5f);
                render.addTexture(RenderButterfly.WINGS);
                model.func_178686_a((ModelBase)RenderButterfly.BUTTERFLY);
                model.func_78088_a((Entity)e, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale);
                GlStateManager.func_179131_c((float)e.getRed(), (float)e.getGreen(), (float)e.getBlue(), (float)1.0f);
                GlStateManager.func_179118_c();
                GlStateManager.func_179084_k();
                GlStateManager.func_179121_F();
            }

            @Override
            @SideOnly(value=Side.CLIENT)
            public void renderCase(ModelBase model, IButterflyRenderer render, NBTTagCompound e, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
                GlStateManager.func_179094_E();
                GlStateManager.func_179131_c((float)e.func_74760_g("Red"), (float)e.func_74760_g("Green"), (float)e.func_74760_g("Blue"), (float)0.5f);
                render.addTexture(RenderButterfly.WINGS);
                model.func_178686_a((ModelBase)RenderButterfly.BUTTERFLY);
                model.func_78088_a(null, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale);
                GlStateManager.func_179131_c((float)e.func_74760_g("Red"), (float)e.func_74760_g("Green"), (float)e.func_74760_g("Blue"), (float)1.0f);
                GlStateManager.func_179121_F();
            }
        };
        NameUtilities.addButterfly(glasswing);
        ButterflyInfo rainbow = new ButterflyInfo("Rainbow Butterfly", 10.0f){

            @Override
            @SideOnly(value=Side.CLIENT)
            public void render(ModelBase model, IButterflyRenderer render, EntityButterfly e, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
                GlStateManager.func_179094_E();
                int i1 = 25;
                int i = e.field_70173_aa / 25 + e.func_145782_y();
                int j = EnumDyeColor.values().length;
                int k = i % j;
                int l = (i + 1) % j;
                float f = ((float)(e.field_70173_aa % 25) + 2.0f) / 25.0f;
                float[] afloat1 = EntitySheep.func_175513_a((EnumDyeColor)EnumDyeColor.func_176764_b((int)k));
                float[] afloat2 = EntitySheep.func_175513_a((EnumDyeColor)EnumDyeColor.func_176764_b((int)l));
                GlStateManager.func_179124_c((float)(afloat1[0] * (1.0f - f) + afloat2[0] * f), (float)(afloat1[1] * (1.0f - f) + afloat2[1] * f), (float)(afloat1[2] * (1.0f - f) + afloat2[2] * f));
                render.addTexture(RenderButterfly.WINGS);
                model.func_178686_a((ModelBase)RenderButterfly.BUTTERFLY);
                model.func_78088_a((Entity)e, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale);
                GlStateManager.func_179121_F();
            }

            @Override
            @SideOnly(value=Side.CLIENT)
            public void renderCase(ModelBase model, IButterflyRenderer render, NBTTagCompound e, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
                GlStateManager.func_179094_E();
                int i1 = 25;
                int i = Minecraft.func_71410_x().field_71439_g.field_70173_aa / 25;
                int j = EnumDyeColor.values().length;
                int k = i % j;
                int l = (i + 1) % j;
                float f = ((float)(Minecraft.func_71410_x().field_71439_g.field_70173_aa % 25) + 2.0f) / 25.0f;
                float[] afloat1 = EntitySheep.func_175513_a((EnumDyeColor)EnumDyeColor.func_176764_b((int)k));
                float[] afloat2 = EntitySheep.func_175513_a((EnumDyeColor)EnumDyeColor.func_176764_b((int)l));
                GlStateManager.func_179124_c((float)(afloat1[0] * (1.0f - f) + afloat2[0] * f), (float)(afloat1[1] * (1.0f - f) + afloat2[1] * f), (float)(afloat1[2] * (1.0f - f) + afloat2[2] * f));
                render.addTexture(RenderButterfly.WINGS);
                model.func_178686_a((ModelBase)RenderButterfly.BUTTERFLY);
                model.func_78088_a(null, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale);
                GlStateManager.func_179121_F();
            }
        };
        NameUtilities.addButterfly(rainbow);
        IDS = new int[butterflies.size()];
        int count = 0;
        for (Integer info : butterflies.keySet()) {
            NameUtilities.IDS[count] = info;
            ++count;
        }
    }
}

