/*
 * Decompiled with CFR 0.152.
 */
package net.soggymustache.butterflies.init.block;

import com.google.common.base.Predicate;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.soggymustache.butterflies.ButterfliesMain;
import net.soggymustache.butterflies.init.block.ButterflyBlocks;
import net.soggymustache.butterflies.init.block.te.TileEntityButterflyCase;
import net.soggymustache.butterflies.init.items.ButterflyItems;

public class BlockButterflyCase
extends Block
implements ITileEntityProvider {
    public static final PropertyDirection FACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);
    protected static final AxisAlignedBB NORTH_AABB = new AxisAlignedBB(0.0, 0.0, 1.0, 1.0, 1.0, 0.8);
    protected static final AxisAlignedBB WEST_AABB = new AxisAlignedBB(0.8, 0.0, 0.0, 1.0, 1.0, 1.0);
    protected static final AxisAlignedBB SOUTH_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 0.2);
    protected static final AxisAlignedBB EAST_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 0.2, 1.0, 1.0);

    public BlockButterflyCase(String name, Material materialIn) {
        super(materialIn);
        this.func_149663_c(name);
        this.setRegistryName(name);
        this.func_149647_a(CreativeTabs.field_78026_f);
        ButterflyBlocks.BLOCKS.add(this);
        ButterflyItems.ITEMS.add((Item)new ItemBlock((Block)this).setRegistryName(this.getRegistryName()));
    }

    public boolean func_149716_u() {
        return true;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileEntityButterflyCase();
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_190946_v(IBlockState state) {
        return true;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        switch ((EnumFacing)state.func_177229_b((IProperty)FACING)) {
            case EAST: {
                return EAST_AABB;
            }
            case WEST: {
                return WEST_AABB;
            }
            case SOUTH: {
                return SOUTH_AABB;
            }
        }
        return NORTH_AABB;
    }

    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return field_185506_k;
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        TileEntity te = worldIn.func_175625_s(pos);
        ItemStack stack = playerIn.field_71071_by.func_70448_g();
        if (stack != null && stack.func_77973_b() == ButterflyItems.BUTTERFLY) {
            if (stack.func_77978_p() != null) {
                NBTTagCompound nbt = stack.func_77978_p();
                NBTTagCompound data = worldIn.func_175625_s(pos).getTileData();
                if (data.func_74764_b("Name")) {
                    return false;
                }
                data.func_74778_a("Name", nbt.func_74779_i("Name"));
                data.func_74774_a("EColor", nbt.func_74771_c("EColor"));
                data.func_74776_a("Red", nbt.func_74760_g("Red"));
                data.func_74776_a("Green", nbt.func_74760_g("Green"));
                data.func_74776_a("Blue", nbt.func_74760_g("Blue"));
                data.func_74776_a("Rarity", nbt.func_74760_g("Rarity"));
                data.func_74776_a("Extra", nbt.func_74760_g("Extra"));
                stack.func_190918_g(1);
                te.func_70296_d();
            }
        } else if (stack != null && stack.func_77973_b() == ButterflyItems.LEPIDOPTEROLOGY_BOOK && te.getTileData().func_74764_b("Name") && playerIn.field_70170_p.field_72995_K) {
            playerIn.openGui((Object)ButterfliesMain.instance, 1, playerIn.field_70170_p, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }
        return super.func_180639_a(worldIn, pos, state, playerIn, hand, facing, hitX, hitY, hitZ);
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        TileEntity te = worldIn.func_175625_s(pos);
        super.func_176213_c(worldIn, pos, state);
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntity te = world.func_175625_s(pos);
        if (te.getTileData().func_74764_b("Name")) {
            ItemStack stack = new ItemStack(ButterflyItems.BUTTERFLY);
            NBTTagCompound comp = new NBTTagCompound();
            comp.func_74778_a("Name", te.getTileData().func_74779_i("Name"));
            comp.func_74774_a("EColor", te.getTileData().func_74771_c("EColor"));
            comp.func_74776_a("Red", te.getTileData().func_74760_g("Red"));
            comp.func_74776_a("Green", te.getTileData().func_74760_g("Green"));
            comp.func_74776_a("Blue", te.getTileData().func_74760_g("Blue"));
            comp.func_74776_a("Rarity", te.getTileData().func_74760_g("Rarity"));
            comp.func_74776_a("Extra", te.getTileData().func_74760_g("Extra"));
            stack.func_77982_d(comp);
            EntityItem item = new EntityItem(world, (double)pos.func_177958_n(), (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p(), stack);
            if (!world.field_72995_K) {
                world.func_72838_d((Entity)item);
            }
        }
        world.func_175713_t(pos);
        super.func_180663_b(world, pos, state);
    }

    public static void setState(boolean active, World worldIn, BlockPos pos) {
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (tileentity != null) {
            tileentity.func_145829_t();
            worldIn.func_175690_a(pos, tileentity);
        }
    }

    public IBlockState onBlockPlaced(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d());
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        super.func_180633_a(worldIn, pos, state, placer, stack);
        worldIn.func_180501_a(pos, state.func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d()), 2);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_176731_b((int)meta));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176736_b();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }

    public boolean func_189539_a(IBlockState state, World worldIn, BlockPos pos, int id, int param) {
        super.func_189539_a(state, worldIn, pos, id, param);
        TileEntity tileentity = worldIn.func_175625_s(pos);
        return tileentity == null ? false : tileentity.func_145842_c(id, param);
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityButterflyCase();
    }

    static final class SwitchEnumFacing {
        static final int[] FACING_LOOKUP = new int[EnumFacing.values().length];

        SwitchEnumFacing() {
        }

        static {
            try {
                SwitchEnumFacing.FACING_LOOKUP[EnumFacing.NORTH.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                SwitchEnumFacing.FACING_LOOKUP[EnumFacing.SOUTH.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                SwitchEnumFacing.FACING_LOOKUP[EnumFacing.WEST.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                SwitchEnumFacing.FACING_LOOKUP[EnumFacing.EAST.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }
    }
}

