/*
 * Decompiled with CFR 0.152.
 */
package net.soggymustache.butterflies.entity;

import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.soggymustache.butterflies.ButterfliesMain;
import net.soggymustache.butterflies.init.items.ButterflyItems;
import net.soggymustache.butterflies.util.NameUtilities;

public class EntityButterfly
extends EntityAnimal {
    private static final DataParameter<String> NAME = EntityDataManager.func_187226_a(EntityButterfly.class, (DataSerializer)DataSerializers.field_187194_d);
    private static final DataParameter<Byte> LANDED = EntityDataManager.func_187226_a(EntityButterfly.class, (DataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<Byte> ECOLOR = EntityDataManager.func_187226_a(EntityButterfly.class, (DataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<Float> RED = EntityDataManager.func_187226_a(EntityButterfly.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> GREEN = EntityDataManager.func_187226_a(EntityButterfly.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> BLUE = EntityDataManager.func_187226_a(EntityButterfly.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> RARITY = EntityDataManager.func_187226_a(EntityButterfly.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Integer> EXTRA = EntityDataManager.func_187226_a(EntityButterfly.class, (DataSerializer)DataSerializers.field_187192_b);
    private BlockPos spawnPosition;
    private int stopped;

    public EntityButterfly(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.3f, 0.3f);
        this.setIsButterflyLanded(false);
    }

    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, IEntityLivingData livingdata) {
        this.setEColor((byte)this.func_70681_au().nextInt(EnumDyeColor.values().length));
        EnumDyeColor color = EnumDyeColor.values()[this.getEColorB()];
        if (color == EnumDyeColor.BLACK) {
            this.setEColor((byte)this.func_70681_au().nextInt(EnumDyeColor.values().length));
            color = EnumDyeColor.values()[this.getEColorB()];
        }
        NameUtilities.generateStats(this, color);
        return super.func_180482_a(difficulty, livingdata);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(ECOLOR, (Object)0);
        this.field_70180_af.func_187214_a(LANDED, (Object)0);
        this.field_70180_af.func_187214_a(NAME, (Object)"");
        this.field_70180_af.func_187214_a(RED, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(GREEN, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(BLUE, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(RARITY, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(EXTRA, (Object)0);
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (stack == null || stack.func_190926_b()) {
            return false;
        }
        if (stack.func_77973_b() == ButterflyItems.LEPIDOPTEROLOGY_BOOK) {
            if (player.field_70170_p.field_72995_K) {
                player.openGui((Object)ButterfliesMain.instance, 0, player.field_70170_p, (int)Math.floor(this.field_70165_t), (int)this.field_70163_u, (int)Math.floor(this.field_70161_v));
            }
            return true;
        }
        return super.func_184645_a(player, hand);
    }

    public boolean func_70104_M() {
        return false;
    }

    protected void func_82167_n(Entity entityIn) {
    }

    protected void func_85033_bc() {
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(2.0);
    }

    public boolean getIsButterflyLanded() {
        return ((Byte)this.field_70180_af.func_187225_a(LANDED) & 1) != 0;
    }

    public void setIsButterflyLanded(boolean isLanded) {
        byte b0 = (Byte)this.field_70180_af.func_187225_a(LANDED);
        this.field_70180_af.func_187227_b(LANDED, (Object)(isLanded ? (byte)(b0 | 1) : (byte)(b0 & 0xFFFFFFFE)));
    }

    public EnumDyeColor getEColor() {
        return EnumDyeColor.values()[(Byte)this.field_70180_af.func_187225_a(ECOLOR)];
    }

    public byte getEColorB() {
        return (Byte)this.field_70180_af.func_187225_a(ECOLOR);
    }

    public void setEColor(byte b) {
        this.field_70180_af.func_187227_b(ECOLOR, (Object)b);
    }

    public int getExtra() {
        return (Integer)this.field_70180_af.func_187225_a(EXTRA);
    }

    public void setExtra(int nm) {
        this.field_70180_af.func_187227_b(EXTRA, (Object)nm);
    }

    public String getBName() {
        return (String)this.field_70180_af.func_187225_a(NAME);
    }

    public void setBName(String nm) {
        this.field_70180_af.func_187227_b(NAME, (Object)nm);
    }

    public float getRarity() {
        return ((Float)this.field_70180_af.func_187225_a(RARITY)).floatValue();
    }

    public void setRarity(float nm) {
        this.field_70180_af.func_187227_b(RARITY, (Object)Float.valueOf(nm));
    }

    public float getRed() {
        return ((Float)this.field_70180_af.func_187225_a(RED)).floatValue();
    }

    public void setRed(float nm) {
        this.field_70180_af.func_187227_b(RED, (Object)Float.valueOf(nm));
    }

    public float getGreen() {
        return ((Float)this.field_70180_af.func_187225_a(GREEN)).floatValue();
    }

    public void setGreen(float nm) {
        this.field_70180_af.func_187227_b(GREEN, (Object)Float.valueOf(nm));
    }

    public float getBlue() {
        return ((Float)this.field_70180_af.func_187225_a(BLUE)).floatValue();
    }

    public void setBlue(float nm) {
        this.field_70180_af.func_187227_b(BLUE, (Object)Float.valueOf(nm));
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.func_70090_H()) {
            if (this.getIsButterflyLanded()) {
                this.field_70159_w = 0.0;
                this.field_70181_x = 0.0;
                this.field_70179_y = 0.0;
                this.field_70163_u = (double)MathHelper.func_76128_c((double)this.field_70163_u) + 0.4 - (double)this.field_70131_O;
            } else {
                this.field_70181_x *= (double)0.6f;
            }
        }
    }

    protected void func_70628_a(boolean wasRecentlyHit, int lootingModifier) {
        super.func_70628_a(wasRecentlyHit, lootingModifier);
        ItemStack stack = new ItemStack(ButterflyItems.BUTTERFLY);
        stack.func_77982_d(new NBTTagCompound());
        stack.func_77978_p().func_74778_a("Name", this.getBName());
        stack.func_77978_p().func_74774_a("EColor", this.getEColorB());
        stack.func_77978_p().func_74776_a("Red", this.getRed());
        stack.func_77978_p().func_74776_a("Green", this.getGreen());
        stack.func_77978_p().func_74776_a("Blue", this.getBlue());
        stack.func_77978_p().func_74776_a("Rarity", this.getRarity());
        stack.func_77978_p().func_74776_a("Extra", (float)this.getExtra());
        this.func_70099_a(stack, 0.0f);
    }

    protected void func_70619_bc() {
        super.func_70619_bc();
        BlockPos blockpos = new BlockPos((Entity)this);
        BlockPos blockpos1 = blockpos.func_177977_b();
        if (!this.func_70090_H()) {
            if (this.getIsButterflyLanded()) {
                ++this.stopped;
                if (this.field_70170_p.func_180495_p(blockpos1).func_185915_l()) {
                    if (this.field_70146_Z.nextInt(200) == 0) {
                        this.field_70759_as = this.field_70146_Z.nextInt(360);
                    }
                    if (this.field_70170_p.func_184136_b((Entity)this, 4.0) != null) {
                        this.setIsButterflyLanded(false);
                        this.field_70170_p.func_180498_a((EntityPlayer)null, 1025, blockpos, 0);
                    }
                } else {
                    this.setIsButterflyLanded(false);
                    this.field_70170_p.func_180498_a((EntityPlayer)null, 1025, blockpos, 0);
                }
            } else {
                if (!(this.spawnPosition == null || this.field_70170_p.func_175623_d(this.spawnPosition) && this.spawnPosition.func_177956_o() >= 1)) {
                    this.spawnPosition = null;
                }
                if (this.spawnPosition == null || this.field_70146_Z.nextInt(30) == 0 || this.spawnPosition.func_177954_c((double)((int)this.field_70165_t), (double)((int)this.field_70163_u), (double)((int)this.field_70161_v)) < 4.0) {
                    this.spawnPosition = new BlockPos((int)this.field_70165_t + this.field_70146_Z.nextInt(7) - this.field_70146_Z.nextInt(7), (int)this.field_70163_u + this.field_70146_Z.nextInt(6) - 2, (int)this.field_70161_v + this.field_70146_Z.nextInt(7) - this.field_70146_Z.nextInt(7));
                }
                double d0 = (double)this.spawnPosition.func_177958_n() + 0.5 - this.field_70165_t;
                double d1 = (double)this.spawnPosition.func_177956_o() + 0.1 - this.field_70163_u;
                double d2 = (double)this.spawnPosition.func_177952_p() + 0.5 - this.field_70161_v;
                this.field_70159_w += (Math.signum(d0) * 0.5 - this.field_70159_w) * (double)0.1f;
                this.field_70181_x += (Math.signum(d1) * (double)0.7f - this.field_70181_x) * (double)0.1f;
                this.field_70179_y += (Math.signum(d2) * 0.5 - this.field_70179_y) * (double)0.1f;
                float f = (float)(MathHelper.func_181159_b((double)this.field_70179_y, (double)this.field_70159_w) * 57.29577951308232) - 90.0f;
                float f1 = MathHelper.func_76142_g((float)(f - this.field_70177_z));
                this.field_191988_bg = 0.5f;
                this.field_70177_z += f1;
                if (this.field_70170_p.func_72918_a(this.func_174813_aQ().func_72314_b(0.0, -4.0, 0.0).func_186664_h(0.001), Material.field_151586_h, (Entity)this)) {
                    this.field_70181_x = 0.1f;
                }
                if (this.field_70146_Z.nextInt(100) == 0 && this.field_70170_p.func_180495_p(blockpos1).func_185915_l()) {
                    this.setIsButterflyLanded(true);
                }
            }
            if (this.stopped >= 100 && !this.func_191953_am()) {
                this.setIsButterflyLanded(false);
                this.stopped = 0;
            }
        }
    }

    protected boolean func_70041_e_() {
        return false;
    }

    public void func_180430_e(float distance, float damageMultiplier) {
    }

    protected void func_184231_a(double y, boolean onGroundIn, IBlockState state, BlockPos pos) {
    }

    public boolean func_145773_az() {
        return true;
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.field_70180_af.func_187227_b(LANDED, (Object)compound.func_74771_c("ButterflyFlags"));
        this.field_70180_af.func_187227_b(NAME, (Object)compound.func_74779_i("Name"));
        this.field_70180_af.func_187227_b(ECOLOR, (Object)compound.func_74771_c("BColor"));
        this.field_70180_af.func_187227_b(RARITY, (Object)Float.valueOf(compound.func_74760_g("Rarity")));
        this.field_70180_af.func_187227_b(RED, (Object)Float.valueOf(compound.func_74760_g("Red")));
        this.field_70180_af.func_187227_b(GREEN, (Object)Float.valueOf(compound.func_74760_g("Green")));
        this.field_70180_af.func_187227_b(BLUE, (Object)Float.valueOf(compound.func_74760_g("Blue")));
        this.field_70180_af.func_187227_b(EXTRA, (Object)compound.func_74762_e("Extra"));
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74774_a("ButterflyFlags", ((Byte)this.field_70180_af.func_187225_a(LANDED)).byteValue());
        compound.func_74778_a("Name", (String)this.field_70180_af.func_187225_a(NAME));
        compound.func_74774_a("BColor", ((Byte)this.field_70180_af.func_187225_a(ECOLOR)).byteValue());
        compound.func_74776_a("Rarity", ((Float)this.field_70180_af.func_187225_a(RARITY)).floatValue());
        compound.func_74776_a("Red", ((Float)this.field_70180_af.func_187225_a(RED)).floatValue());
        compound.func_74776_a("Green", ((Float)this.field_70180_af.func_187225_a(GREEN)).floatValue());
        compound.func_74776_a("Blue", ((Float)this.field_70180_af.func_187225_a(BLUE)).floatValue());
        compound.func_74768_a("Extra", ((Integer)this.field_70180_af.func_187225_a(EXTRA)).intValue());
    }

    public float func_70047_e() {
        return this.field_70131_O / 2.0f;
    }

    public EntityAgeable func_90011_a(EntityAgeable ageable) {
        return null;
    }
}

