/*
 * Decompiled with CFR 0.152.
 */
package net.soggymustache.butterflies.client.render;

import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.soggymustache.butterflies.client.model.ModelButterfly;
import net.soggymustache.butterflies.client.model.ModelButterflyCase;
import net.soggymustache.butterflies.client.render.RenderButterfly;
import net.soggymustache.butterflies.init.block.BlockButterflyCase;
import net.soggymustache.butterflies.init.block.ButterflyBlocks;
import net.soggymustache.butterflies.init.block.te.TileEntityButterflyCase;
import net.soggymustache.butterflies.util.ButterflyType;
import net.soggymustache.butterflies.util.IButterflyRenderer;
import net.soggymustache.butterflies.util.NameUtilities;
import org.lwjgl.opengl.GL11;

public class TileEntityButterflyCaseRenderer
extends TileEntitySpecialRenderer<TileEntityButterflyCase>
implements IButterflyRenderer {
    private static final ModelButterflyCase CASE = new ModelButterflyCase();
    public static final ModelButterfly BUTTERFLY = new ModelButterfly();
    private static final ResourceLocation CASE_TEXTURE = new ResourceLocation("butterflies:textures/tile/case.png");

    public void render(TileEntityButterflyCase te, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        IBlockState bCase = te.func_145831_w().func_180495_p(te.func_174877_v());
        if (bCase == null || bCase != null && bCase.func_177230_c() != ButterflyBlocks.CASE) {
            return;
        }
        GL11.glPushMatrix();
        this.func_147499_a(CASE_TEXTURE);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glTranslatef((float)((float)x + 0.5f), (float)((float)y + 1.5f), (float)((float)z + 0.5f));
        switch ((EnumFacing)bCase.func_177229_b((IProperty)BlockButterflyCase.FACING)) {
            default: {
                GL11.glRotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                break;
            }
            case WEST: {
                GL11.glRotatef((float)-180.0f, (float)1.0f, (float)0.0f, (float)1.0f);
                break;
            }
            case EAST: {
                GL11.glRotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)-1.0f);
                break;
            }
            case NORTH: {
                GL11.glRotatef((float)-180.0f, (float)-0.0f, (float)-0.0f, (float)-1.0f);
            }
        }
        CASE.func_78088_a(null, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0625f);
        GlStateManager.func_179121_F();
        if (te.getTileData().func_74764_b("Name")) {
            GL11.glPushMatrix();
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.func_147499_a(RenderButterfly.TEXTURE);
            GL11.glTranslatef((float)((float)x + 0.5f), (float)((float)y + 1.2f), (float)((float)z + 0.5f));
            GL11.glScalef((float)0.35f, (float)0.35f, (float)0.35f);
            switch ((EnumFacing)bCase.func_177229_b((IProperty)BlockButterflyCase.FACING)) {
                default: {
                    GL11.glRotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                    break;
                }
                case WEST: {
                    GL11.glRotatef((float)-180.0f, (float)1.0f, (float)0.0f, (float)1.0f);
                    break;
                }
                case EAST: {
                    GL11.glRotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)-1.0f);
                    break;
                }
                case NORTH: {
                    GL11.glRotatef((float)-180.0f, (float)-0.0f, (float)-0.0f, (float)-1.0f);
                }
            }
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)0.33f);
            GL11.glRotatef((float)70.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glTranslatef((float)0.0f, (float)-0.05f, (float)1.6f);
            BUTTERFLY.func_78088_a(null, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0625f);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            int extra = te.getTileData().func_74762_e("Extra");
            if (extra > ButterflyType.values().length) {
                GlStateManager.func_179094_E();
                NameUtilities.getInfo().get(extra).renderCase(BUTTERFLY, this, te.getTileData(), 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0625f);
                GlStateManager.func_179121_F();
            } else {
                ResourceLocation color = null;
                ResourceLocation wings = null;
                if (extra == ButterflyType.ADMIRAL.id) {
                    wings = RenderButterfly.ADMIRAL_WINGS;
                    color = RenderButterfly.ADMIRAL_COLOR;
                } else if (extra == ButterflyType.MONARCH.id) {
                    wings = RenderButterfly.MONARCH_WINGS;
                    color = RenderButterfly.MONARCH_COLOR;
                } else if (extra == ButterflyType.CLOAK.id) {
                    wings = RenderButterfly.CLOAK_WINGS;
                    color = RenderButterfly.CLOAK_COLOR;
                } else {
                    color = RenderButterfly.WINGS;
                }
                GlStateManager.func_179094_E();
                if (wings != null) {
                    this.func_147499_a(wings);
                    BUTTERFLY.func_78088_a(null, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0625f);
                }
                GlStateManager.func_179124_c((float)te.getTileData().func_74760_g("Red"), (float)te.getTileData().func_74760_g("Green"), (float)te.getTileData().func_74760_g("Blue"));
                this.func_147499_a(color);
                GlStateManager.func_179121_F();
            }
            BUTTERFLY.func_78088_a(null, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0625f);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179121_F();
        }
    }

    @Override
    public void addTexture(ResourceLocation resource) {
        this.func_147499_a(resource);
    }
}

