/*
 * Decompiled with CFR 0.152.
 */
package net.soggymustache.butterflies.client.render;

import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.soggymustache.butterflies.client.model.ModelButterfly;
import net.soggymustache.butterflies.entity.EntityButterfly;
import net.soggymustache.butterflies.util.ButterflyType;
import net.soggymustache.butterflies.util.IButterflyRenderer;
import net.soggymustache.butterflies.util.NameUtilities;

@SideOnly(value=Side.CLIENT)
public class RenderButterfly
extends RenderLiving<EntityButterfly> {
    public static final ResourceLocation TEXTURE = new ResourceLocation("butterflies:textures/entity/butterfly/butterfly_base.png");
    public static final ResourceLocation WINGS = new ResourceLocation("butterflies:textures/entity/butterfly/butterfly.png");
    public static final ResourceLocation ADMIRAL_WINGS = new ResourceLocation("butterflies:textures/entity/butterfly/admiral_overlay.png");
    public static final ResourceLocation ADMIRAL_COLOR = new ResourceLocation("butterflies:textures/entity/butterfly/admiral_color.png");
    public static final ResourceLocation MONARCH_WINGS = new ResourceLocation("butterflies:textures/entity/butterfly/monarch_overlay.png");
    public static final ResourceLocation MONARCH_COLOR = new ResourceLocation("butterflies:textures/entity/butterfly/monarch_color.png");
    public static final ResourceLocation CLOAK_WINGS = new ResourceLocation("butterflies:textures/entity/butterfly/cloak_overlay.png");
    public static final ResourceLocation CLOAK_COLOR = new ResourceLocation("butterflies:textures/entity/butterfly/cloak_color.png");
    public static final ModelButterfly BUTTERFLY = new ModelButterfly();

    public RenderButterfly(RenderManager rm) {
        super(rm, (ModelBase)new ModelButterfly(), 0.1f);
        this.func_177094_a(new LayerButterfly(this));
    }

    protected void preRenderCallback(EntityButterfly entitylivingbaseIn, float partialTickTime) {
        super.func_77041_b((EntityLivingBase)entitylivingbaseIn, partialTickTime);
        GlStateManager.func_179152_a((float)0.35f, (float)0.35f, (float)0.35f);
        if (entitylivingbaseIn.getIsButterflyLanded()) {
            GlStateManager.func_179109_b((float)0.0f, (float)0.37f, (float)0.0f);
        } else {
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)0.0f);
        }
    }

    protected ResourceLocation getEntityTexture(EntityButterfly entity) {
        return TEXTURE;
    }

    @SideOnly(value=Side.CLIENT)
    public class LayerButterfly
    implements LayerRenderer<EntityButterfly>,
    IButterflyRenderer {
        private final RenderButterfly render;

        public LayerButterfly(RenderButterfly re) {
            this.render = re;
        }

        public void doRenderLayer(EntityButterfly e, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
            if (!e.func_82150_aj()) {
                if (e.getExtra() > ButterflyType.values().length) {
                    NameUtilities.getInfo().get(e.getExtra()).render(BUTTERFLY, this, e, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale);
                } else {
                    ResourceLocation color = null;
                    ResourceLocation wings = null;
                    if (e.getExtra() == ButterflyType.ADMIRAL.id) {
                        wings = ADMIRAL_WINGS;
                        color = ADMIRAL_COLOR;
                    } else if (e.getExtra() == ButterflyType.MONARCH.id) {
                        wings = MONARCH_WINGS;
                        color = MONARCH_COLOR;
                    } else if (e.getExtra() == ButterflyType.CLOAK.id) {
                        wings = CLOAK_WINGS;
                        color = CLOAK_COLOR;
                    } else {
                        color = WINGS;
                    }
                    GlStateManager.func_179094_E();
                    if (wings != null) {
                        this.render.func_110776_a(wings);
                        BUTTERFLY.func_178686_a(this.render.field_77045_g);
                        BUTTERFLY.func_78088_a((Entity)e, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale);
                    }
                    GlStateManager.func_179124_c((float)e.getRed(), (float)e.getGreen(), (float)e.getBlue());
                    this.render.func_110776_a(color);
                    BUTTERFLY.func_178686_a(this.render.field_77045_g);
                    BUTTERFLY.func_78088_a((Entity)e, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale);
                    GlStateManager.func_179121_F();
                }
            }
        }

        public boolean func_177142_b() {
            return true;
        }

        @Override
        public void addTexture(ResourceLocation resource) {
            this.render.func_110776_a(resource);
        }
    }
}

