/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.worldgen.json;

import com.ferreusveritas.dynamictrees.api.worldgen.BiomePropertySelectors;
import com.ferreusveritas.dynamictrees.worldgen.BiomeDataBase;
import com.ferreusveritas.dynamictrees.worldgen.json.IJsonBiomeApplier;
import com.ferreusveritas.dynamictrees.worldgen.json.JsonMath;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.biome.Biome;

public class JsonBiomePropertyApplierDensity
implements IJsonBiomeApplier {
    @Override
    public void apply(BiomeDataBase dbase, JsonElement element, Biome biome) {
        if (element.isJsonObject()) {
            JsonObject object = element.getAsJsonObject();
            BiomeDataBase.Operation operation = this.readMethod(object);
            dbase.setDensitySelector(biome, JsonBiomePropertyApplierDensity.readDensitySelector(object, biome), operation);
        } else if (element.isJsonArray()) {
            dbase.setDensitySelector(biome, JsonBiomePropertyApplierDensity.createScaleDensitySelector(element.getAsJsonArray()), BiomeDataBase.Operation.REPLACE);
        } else if (element.isJsonPrimitive()) {
            String simple;
            JsonPrimitive prim = element.getAsJsonPrimitive();
            if (prim.isNumber()) {
                float value = prim.getAsFloat();
                dbase.setDensitySelector(biome, (rnd, n) -> value, BiomeDataBase.Operation.REPLACE);
            } else if (prim.isString() && "standard".equals(simple = prim.getAsString())) {
                double treeDensity = MathHelper.func_76131_a((float)((float)biome.field_76760_I.field_76832_z / 10.0f), (float)0.0f, (float)1.0f);
                dbase.setDensitySelector(biome, (rnd, n) -> n * treeDensity, BiomeDataBase.Operation.REPLACE);
            }
        }
    }

    private static BiomePropertySelectors.IDensitySelector createScaleDensitySelector(JsonArray jsonArray) {
        if (jsonArray != null && jsonArray.isJsonArray()) {
            ArrayList<Float> parameters = new ArrayList<Float>();
            for (JsonElement element : jsonArray) {
                if (!element.isJsonPrimitive() || !element.getAsJsonPrimitive().isNumber()) continue;
                parameters.add(Float.valueOf(element.getAsJsonPrimitive().getAsFloat()));
            }
            switch (parameters.size()) {
                case 0: {
                    return (rnd, n) -> n;
                }
                case 1: {
                    return (rnd, n) -> n * (double)((Float)parameters.get(0)).floatValue();
                }
                case 2: {
                    return (rnd, n) -> n * (double)((Float)parameters.get(0)).floatValue() + (double)((Float)parameters.get(1)).floatValue();
                }
                case 3: {
                    return (rnd, n) -> (n * (double)((Float)parameters.get(0)).floatValue() + (double)((Float)parameters.get(1)).floatValue()) * (double)((Float)parameters.get(2)).floatValue();
                }
            }
            return (rnd, n) -> 0.0;
        }
        return (rnd, n) -> n;
    }

    private static BiomePropertySelectors.IDensitySelector readDensitySelector(JsonObject mainObject, Biome biome) {
        JsonElement scaleElement = mainObject.get("scale");
        if (scaleElement != null && scaleElement.isJsonArray()) {
            return JsonBiomePropertyApplierDensity.createScaleDensitySelector(scaleElement.getAsJsonArray());
        }
        JsonElement staticElement = mainObject.get("static");
        if (staticElement != null && staticElement.isJsonPrimitive() && staticElement.getAsJsonPrimitive().isNumber()) {
            return (rnd, n) -> staticElement.getAsJsonPrimitive().getAsFloat();
        }
        JsonElement mathElement = mainObject.get("math");
        if (mathElement != null) {
            JsonMath m = new JsonMath(mathElement, biome);
            return (rnd, n) -> m.apply(rnd, (float)n);
        }
        return null;
    }
}

