/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.models.bakedmodels;

import com.ferreusveritas.dynamictrees.ModConfigs;
import com.ferreusveritas.dynamictrees.client.ModelUtils;
import com.ferreusveritas.dynamictrees.models.ICustomDamageModel;
import com.ferreusveritas.dynamictrees.models.bakedmodels.BakedModelBlockBranchBasic;
import com.ferreusveritas.dynamictrees.util.CoordUtils;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockFaceUV;
import net.minecraft.client.renderer.block.model.BlockPart;
import net.minecraft.client.renderer.block.model.BlockPartFace;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.block.model.ModelRotation;
import net.minecraft.client.renderer.block.model.SimpleBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.common.model.ITransformation;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.util.vector.Vector3f;

@SideOnly(value=Side.CLIENT)
public class BakedModelBlockBranchThick
extends BakedModelBlockBranchBasic
implements ICustomDamageModel {
    private final IBakedModel[] trunksBark = new IBakedModel[16];
    private final IBakedModel[] trunksTopBark = new IBakedModel[16];
    private final IBakedModel[] trunksTopRings = new IBakedModel[16];
    private final IBakedModel[] trunksBotRings = new IBakedModel[16];

    public BakedModelBlockBranchThick(ResourceLocation barkRes, ResourceLocation ringsRes, ResourceLocation thickRingsRes, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        super(barkRes, ringsRes, bakedTextureGetter);
        TextureAtlasSprite barkIcon = bakedTextureGetter.apply(barkRes);
        TextureAtlasSprite ringIcon = bakedTextureGetter.apply(ringsRes);
        TextureAtlasSprite thickRingIcon = bakedTextureGetter.apply(thickRingsRes);
        this.barkParticles = barkIcon;
        for (int i = 0; i < 16; ++i) {
            int radius = i + 9;
            this.trunksBark[i] = this.bakeTrunkBark(radius, barkIcon, true);
            this.trunksTopBark[i] = this.bakeTrunkBark(radius, barkIcon, false);
            this.trunksTopRings[i] = this.bakeTrunkRings(radius, ModConfigs.fancyThickRings ? thickRingIcon : ringIcon, EnumFacing.UP);
            this.trunksBotRings[i] = this.bakeTrunkRings(radius, ModConfigs.fancyThickRings ? thickRingIcon : ringIcon, EnumFacing.DOWN);
        }
    }

    public IBakedModel bakeTrunkBark(int radius, TextureAtlasSprite bark, boolean side) {
        EnumFacing[] enumFacingArray;
        SimpleBakedModel.Builder builder = new SimpleBakedModel.Builder(this.modelBlock, ItemOverrideList.field_188022_a).func_177646_a(bark);
        AxisAlignedBB wholeVolume = new AxisAlignedBB((double)(8 - radius), 0.0, (double)(8 - radius), (double)(8 + radius), 16.0, (double)(8 + radius));
        if (side) {
            enumFacingArray = EnumFacing.field_176754_o;
        } else {
            EnumFacing[] enumFacingArray2 = new EnumFacing[2];
            enumFacingArray2[0] = EnumFacing.UP;
            enumFacingArray = enumFacingArray2;
            enumFacingArray2[1] = EnumFacing.DOWN;
        }
        EnumFacing[] run = enumFacingArray;
        ArrayList<Vec3i> offsets = new ArrayList<Vec3i>();
        for (CoordUtils.Surround surround : CoordUtils.Surround.values()) {
            offsets.add(surround.getOffset());
        }
        offsets.add(new Vec3i(0, 0, 0));
        for (CoordUtils.Surround surround : run) {
            for (Vec3i offset : offsets) {
                if (surround.func_176740_k() != EnumFacing.Axis.Y) {
                    Vec3d vec3d = new Vec3d(surround.func_176730_m());
                    Vec3d vec3d2 = new Vec3d(offset);
                    if (!(vec3d.func_178787_e(vec3d2).func_189985_c() > 2.25)) continue;
                }
                Vec3d scaledOffset = new Vec3d((double)(offset.func_177958_n() * 16), (double)(offset.func_177956_o() * 16), (double)(offset.func_177952_p() * 16));
                AxisAlignedBB partBoundary = new AxisAlignedBB(0.0, 0.0, 0.0, 16.0, 16.0, 16.0).func_191194_a(scaledOffset).func_191500_a(wholeVolume);
                Vector3f[] limits = ModelUtils.AABBLimits(partBoundary);
                EnumMap mapFacesIn = Maps.newEnumMap(EnumFacing.class);
                BlockFaceUV uvface = new BlockFaceUV(ModelUtils.modUV(ModelUtils.getUVs(partBoundary, (EnumFacing)surround)), this.getFaceAngle(EnumFacing.Axis.Y, (EnumFacing)surround));
                mapFacesIn.put(surround, new BlockPartFace(null, -1, null, uvface));
                BlockPart part = new BlockPart(limits[0], limits[1], (Map)mapFacesIn, null, true);
                builder.func_177650_a((EnumFacing)surround, ModelUtils.makeBakedQuad(part, (BlockPartFace)part.field_178240_c.get((Object)surround), bark, (EnumFacing)surround, (ITransformation)ModelRotation.X0_Y0, false));
            }
        }
        return builder.func_177645_b();
    }

    public IBakedModel bakeTrunkRings(int radius, TextureAtlasSprite ring, EnumFacing face) {
        return this.bakeTrunkRings(radius, ring, face, ModConfigs.fancyThickRings);
    }

    public IBakedModel bakeTrunkRings(int radius, TextureAtlasSprite ring, EnumFacing face, boolean fancy) {
        SimpleBakedModel.Builder builder = new SimpleBakedModel.Builder(this.modelBlock, ItemOverrideList.field_188022_a).func_177646_a(ring);
        AxisAlignedBB wholeVolume = new AxisAlignedBB((double)(8 - radius), 0.0, (double)(8 - radius), (double)(8 + radius), 16.0, (double)(8 + radius));
        int wholeVolumeWidth = fancy ? 48 : radius * 2;
        ArrayList<Vec3i> offsets = new ArrayList<Vec3i>();
        for (CoordUtils.Surround dir : CoordUtils.Surround.values()) {
            offsets.add(dir.getOffset());
        }
        offsets.add(new Vec3i(0, 0, 0));
        for (Vec3i offset : offsets) {
            Vec3d scaledOffset = new Vec3d((double)(offset.func_177958_n() * 16), (double)(offset.func_177956_o() * 16), (double)(offset.func_177952_p() * 16));
            AxisAlignedBB partBoundary = new AxisAlignedBB(0.0, 0.0, 0.0, 16.0, 16.0, 16.0).func_191194_a(scaledOffset).func_191500_a(wholeVolume);
            Vector3f posFrom = new Vector3f((float)partBoundary.field_72340_a, (float)partBoundary.field_72338_b, (float)partBoundary.field_72339_c);
            Vector3f posTo = new Vector3f((float)partBoundary.field_72336_d, (float)partBoundary.field_72337_e, (float)partBoundary.field_72334_f);
            EnumMap mapFacesIn = Maps.newEnumMap(EnumFacing.class);
            float textureOffsetX = fancy ? -16.0f : (float)wholeVolume.field_72340_a;
            float textureOffsetZ = fancy ? -16.0f : (float)wholeVolume.field_72339_c;
            float minX = (float)((partBoundary.field_72340_a - (double)textureOffsetX) / (double)wholeVolumeWidth) * 16.0f;
            float maxX = (float)((partBoundary.field_72336_d - (double)textureOffsetX) / (double)wholeVolumeWidth) * 16.0f;
            float minZ = (float)((partBoundary.field_72339_c - (double)textureOffsetZ) / (double)wholeVolumeWidth) * 16.0f;
            float maxZ = (float)((partBoundary.field_72334_f - (double)textureOffsetZ) / (double)wholeVolumeWidth) * 16.0f;
            if (face == EnumFacing.DOWN) {
                minZ = (float)((partBoundary.field_72334_f - (double)textureOffsetZ) / (double)wholeVolumeWidth) * 16.0f;
                maxZ = (float)((partBoundary.field_72339_c - (double)textureOffsetZ) / (double)wholeVolumeWidth) * 16.0f;
            }
            float[] uvs = new float[]{minX, minZ, maxX, maxZ};
            BlockFaceUV uvface = new BlockFaceUV(uvs, this.getFaceAngle(EnumFacing.Axis.Y, face));
            mapFacesIn.put(face, new BlockPartFace(null, -1, null, uvface));
            BlockPart part = new BlockPart(posFrom, posTo, (Map)mapFacesIn, null, true);
            builder.func_177650_a(face, ModelUtils.makeBakedQuad(part, (BlockPartFace)part.field_178240_c.get(face), ring, face, (ITransformation)ModelRotation.X0_Y0, false));
        }
        return builder.func_177645_b();
    }

    @Override
    public List<BakedQuad> func_188616_a(IBlockState state, EnumFacing side, long rand) {
        int coreRadius = this.getRadius(state);
        if (coreRadius <= 8) {
            return super.func_188616_a(state, side, rand);
        }
        coreRadius = MathHelper.func_76125_a((int)coreRadius, (int)9, (int)24);
        ArrayList<BakedQuad> quadsList = new ArrayList<BakedQuad>(30);
        quadsList.addAll(this.trunksBark[coreRadius - 9].func_188616_a(state, side, rand));
        if (state instanceof IExtendedBlockState) {
            boolean branchesAround;
            IExtendedBlockState extendedBlockState = (IExtendedBlockState)state;
            int[] connections = this.pollConnections(coreRadius, extendedBlockState);
            boolean bl = branchesAround = connections[2] + connections[3] + connections[4] + connections[5] != 0;
            if (connections[0] < 1) {
                quadsList.addAll(this.trunksBotRings[coreRadius - 9].func_188616_a(state, side, rand));
            }
            if (connections[1] < 1 && !branchesAround) {
                quadsList.addAll(this.trunksTopRings[coreRadius - 9].func_188616_a(state, side, rand));
            } else if (connections[1] == 1 && side == EnumFacing.UP) {
                quadsList.addAll(this.trunksTopBark[coreRadius - 9].func_188616_a(state, side, rand));
            }
        }
        return quadsList;
    }

    @Override
    public List<BakedQuad> getCustomDamageQuads(IBlockState blockState, EnumFacing side, long rand) {
        int coreRadius = this.getRadius(blockState);
        if (coreRadius <= 8) {
            return super.func_188616_a(blockState, side, rand);
        }
        coreRadius = MathHelper.func_76125_a((int)coreRadius, (int)9, (int)24);
        LinkedList<BakedQuad> quadsList = new LinkedList<BakedQuad>();
        quadsList.addAll(this.trunksBark[coreRadius - 9].func_188616_a(blockState, side, rand));
        quadsList.addAll(this.trunksTopBark[coreRadius - 9].func_188616_a(blockState, side, rand));
        return quadsList;
    }
}

