/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.event;

import com.ferreusveritas.dynamictrees.ModConfigs;
import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.WorldGenRegistry;
import com.ferreusveritas.dynamictrees.blocks.BlockBranch;
import com.ferreusveritas.dynamictrees.blocks.BlockTrunkShell;
import com.ferreusveritas.dynamictrees.client.TooltipHandler;
import com.ferreusveritas.dynamictrees.event.FutureBreak;
import com.ferreusveritas.dynamictrees.event.WorldListener;
import com.ferreusveritas.dynamictrees.seasons.SeasonHelper;
import net.minecraft.block.Block;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorldEventListener;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class CommonEventHandler {
    @SubscribeEvent
    public void onWorldTick(TickEvent.WorldTickEvent event) {
        if (event.side == Side.SERVER) {
            FutureBreak.process(event.world);
        }
        if (event.type == TickEvent.Type.WORLD && event.phase == TickEvent.Phase.START) {
            SeasonHelper.updateTick(event.world, event.world.func_72820_D());
        }
    }

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load event) {
        if (WorldGenRegistry.isWorldGenEnabled() && !event.getWorld().field_72995_K && !WorldGenRegistry.validateBiomeDataBases()) {
            WorldGenRegistry.populateDataBase();
        }
        event.getWorld().func_72954_a((IWorldEventListener)new WorldListener(event.getWorld(), event.getWorld().func_73046_m()));
    }

    @SubscribeEvent
    public void onTreeClick(PlayerInteractEvent.LeftClickBlock event) {
        int blockPosStumpY;
        int blockPosY;
        BlockPos blockPos;
        World world;
        Block block;
        if (ModConfigs.treeStumping && ((block = (world = event.getWorld()).func_180495_p(blockPos = event.getPos()).func_177230_c()) instanceof BlockBranch || block instanceof BlockTrunkShell) && (blockPosY = event.getPos().func_177956_o()) == (blockPosStumpY = TreeHelper.findRootNode(world, blockPos).func_177984_a().func_177956_o())) {
            event.setUseBlock(Event.Result.DENY);
            event.setUseItem(Event.Result.DENY);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onItemTooltipAdded(ItemTooltipEvent event) {
        TooltipHandler.setupTooltips(event);
    }
}

