/*
 * Decompiled with CFR 0.152.
 */
package bblsom.mixin.vanilla;

import bblsom.compat.AquaAcrobaticsCompat;
import bblsom.compat.CompatUtil;
import bblsom.handlers.ForgeConfigHandler;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.BlockDirt;
import net.minecraft.block.BlockGrass;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={BlockGrass.class}, priority=990)
public abstract class BlockGrassMixin {
    @Overwrite
    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if (!worldIn.field_72995_K) {
            int lightUp;
            if (!worldIn.func_175697_a(pos, 3)) {
                return;
            }
            if (CompatUtil.isAquaAcrobaticsLoaded()) {
                CallbackInfo ci = new CallbackInfo("bblsom$aquaAcrobaticsCompat", true);
                AquaAcrobaticsCompat.handleUnderwaterGrassLikeBlockWrapped(worldIn, pos, state, rand, ci);
                if (ci.isCancelled()) {
                    return;
                }
            }
            if ((lightUp = worldIn.func_175671_l(pos.func_177984_a())) < 4 && worldIn.getBlockLightOpacity(pos.func_177984_a()) > 2) {
                worldIn.func_175656_a(pos, Blocks.field_150346_d.func_176223_P());
            } else if (lightUp >= 9) {
                for (int i = 0; i < 4; ++i) {
                    BlockPos blockpos = pos.func_177982_a(rand.nextInt(3) - 1, rand.nextInt(5) - 3, rand.nextInt(3) - 1);
                    if (blockpos.func_177956_o() < 0 || blockpos.func_177956_o() >= 256 || !worldIn.func_175667_e(blockpos)) {
                        return;
                    }
                    IBlockState iblockstate = worldIn.func_180495_p(blockpos);
                    if (state.func_177230_c() == Blocks.field_150350_a || CompatUtil.isAquaAcrobaticsLoaded() && worldIn.func_180495_p(blockpos.func_177984_a()).func_185904_a().func_76224_d()) continue;
                    Map<ForgeConfigHandler.BlockEntry, ForgeConfigHandler.BlockEntry> conversionMap = ForgeConfigHandler.getGrassConversions(state);
                    if (conversionMap != null) {
                        boolean matched = false;
                        for (Map.Entry<ForgeConfigHandler.BlockEntry, ForgeConfigHandler.BlockEntry> entry : conversionMap.entrySet()) {
                            if (!entry.getKey().entryMatches(iblockstate)) continue;
                            if (worldIn.func_175671_l(blockpos.func_177984_a()) >= 4 && worldIn.getBlockLightOpacity(blockpos.func_177984_a()) <= 2) {
                                worldIn.func_175656_a(blockpos, entry.getValue().getState());
                            }
                            matched = true;
                            break;
                        }
                        if (matched) continue;
                    }
                    if (iblockstate.func_177230_c() != Blocks.field_150346_d || iblockstate.func_177229_b((IProperty)BlockDirt.field_176386_a) != BlockDirt.DirtType.DIRT || worldIn.func_175671_l(blockpos.func_177984_a()) < 4 || worldIn.getBlockLightOpacity(blockpos.func_177984_a()) > 2) continue;
                    worldIn.func_175656_a(blockpos, Blocks.field_150349_c.func_176223_P());
                }
            }
        }
    }
}

